/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.handler.ReflectorServletProcessor;

public class MeteorServlet
extends AtmosphereServlet {
    protected static final Logger logger = LoggerFactory.getLogger(MeteorServlet.class);
    private Servlet delegate;
    private String delegateMapping;
    private Collection<Filter> filters;

    public MeteorServlet() {
        this(false);
    }

    public MeteorServlet(boolean isFilter) {
        this(isFilter, false);
    }

    public MeteorServlet(boolean isFilter, boolean autoDetectHandlers) {
        super(isFilter, autoDetectHandlers);
    }

    public MeteorServlet(Servlet delegate, String delegateMapping, Filter ... filters) {
        this(delegate, delegateMapping, Arrays.asList(filters));
    }

    public MeteorServlet(Servlet delegate, String delegateMapping, Collection<Filter> filters) {
        this(false);
        if (delegate == null || delegateMapping == null) {
            throw new IllegalArgumentException("Delegate Servlet is undefined");
        }
        this.delegate = delegate;
        this.delegateMapping = delegateMapping;
        this.filters = filters == null ? Collections.emptyList() : filters;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        if (this.delegate == null) {
            this.loadDelegateViaConfig(sc);
        } else {
            ReflectorServletProcessor r = new ReflectorServletProcessor(this.delegate);
            for (Filter f : this.filters) {
                r.addFilter(f);
            }
            this.framework().getBroadcasterFactory().remove(this.delegateMapping);
            this.framework.addAtmosphereHandler(this.delegateMapping, r).initAtmosphereHandler(sc);
        }
    }

    private void loadDelegateViaConfig(ServletConfig sc) throws ServletException {
        String servletClass = this.framework().getAtmosphereConfig().getInitParameter("org.atmosphere.servlet");
        String mapping = this.framework().getAtmosphereConfig().getInitParameter("org.atmosphere.mapping");
        String filterClass = this.framework().getAtmosphereConfig().getInitParameter("org.atmosphere.filter");
        String filterName = this.framework().getAtmosphereConfig().getInitParameter("org.atmosphere.filter.name");
        if (servletClass != null) {
            logger.info("Installed Servlet/Meteor {} mapped to {}", (Object)servletClass, (Object)(mapping == null ? "/*" : mapping));
        }
        if (filterClass != null) {
            logger.info("Installed Filter/Meteor {} mapped to /*", (Object)filterClass, (Object)mapping);
        }
        if (servletClass != null || filterClass != null) {
            ReflectorServletProcessor r = new ReflectorServletProcessor();
            r.setServletClassName(servletClass);
            r.addFilterClassName(filterClass, filterName);
            if (mapping == null) {
                mapping = "/*";
                this.framework.getBroadcasterFactory().remove("/*");
            }
            this.framework.addAtmosphereHandler(mapping, r).initAtmosphereHandler(sc);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

