/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListenerAdapter;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;

public class AtmosphereResourceStateRecovery
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceStateRecovery.class);
    private final ConcurrentHashMap<String, BroadcasterTracker> states = new ConcurrentHashMap();
    private BroadcasterFactory factory;
    private ScheduledExecutorService stateTracker;
    private long timeout = 300000L;

    @Override
    public void configure(AtmosphereConfig config) {
        this.factory = config.getBroadcasterFactory();
        this.factory.addBroadcasterListener(new B());
        this.stateTracker = ExecutorsFactory.getScheduler(config);
        String s = config.getInitParameter(ApplicationConfig.STATE_RECOVERY_TIMEOUT);
        if (s != null) {
            this.timeout = Long.parseLong(s);
        }
        this.clearStateTracker();
        logger.trace("{} started.", (Object)AtmosphereResourceStateRecovery.class.getName());
    }

    protected void clearStateTracker() {
        this.stateTracker.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                for (Map.Entry t : AtmosphereResourceStateRecovery.this.states.entrySet()) {
                    if (now - ((BroadcasterTracker)t.getValue()).lastTick() <= AtmosphereResourceStateRecovery.this.timeout) continue;
                    logger.trace("AtmosphereResource {} state destroyed.", t.getKey());
                    AtmosphereResourceStateRecovery.this.states.remove(t.getKey());
                }
            }
        }, this.timeout, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        if (!Utils.pollableTransport(r.transport())) {
            final BroadcasterTracker tracker = this.track(r).tick();
            List<Object> cachedMessages = this.retrieveCache(r, tracker, false);
            if (cachedMessages.size() > 0) {
                logger.trace("cached messages");
                this.writeCache(r, cachedMessages);
                return Action.CANCELLED;
            }
            r.addEventListener(new AtmosphereResourceEventListenerAdapter.OnSuspend(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    logger.trace("onSuspend first");
                    final AtomicBoolean doNotSuspend = new AtomicBoolean(false);
                    r.addEventListener(new AtmosphereResourceEventListenerAdapter.OnBroadcast(){

                        @Override
                        public void onBroadcast(AtmosphereResourceEvent event) {
                            r.removeEventListener(this);
                            doNotSuspend.set(true);
                            logger.trace("onBroadcast");
                        }
                    });
                    for (String broadcasterID : tracker.ids()) {
                        Object b = AtmosphereResourceStateRecovery.this.factory.lookup(broadcasterID, false);
                        logger.trace("About to associate resource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                        if (b != null && !b.getID().equalsIgnoreCase(r.getBroadcaster().getID())) {
                            logger.trace("Associate AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                            b.addAtmosphereResource(r);
                            continue;
                        }
                        if (b == null) {
                            logger.trace("Broadcaster {} is no longer available for {}", (Object)broadcasterID, (Object)r);
                            continue;
                        }
                        logger.trace("AtmosphereResource {} already associated with {}", (Object)r.uuid(), (Object)broadcasterID);
                    }
                    List<Object> cachedMessages = AtmosphereResourceStateRecovery.this.retrieveCache(r, tracker, true);
                    if (logger.isTraceEnabled()) {
                        logger.trace("message size {}", (Object)cachedMessages.size());
                    }
                    if (cachedMessages.size() > 0) {
                        logger.trace("About to write to the cache {}", (Object)r.uuid());
                        AtmosphereResourceStateRecovery.this.writeCache(r, cachedMessages);
                        doNotSuspend.set(true);
                    }
                    if (doNotSuspend.get()) {
                        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).action().type(Action.TYPE.CONTINUE);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("doNotSuspend {}", (Object)doNotSuspend.get());
                    }
                }
            });
        }
        return Action.CONTINUE;
    }

    private BroadcasterTracker track(AtmosphereResource r) {
        BroadcasterTracker tracker = this.states.get(r.uuid());
        if (tracker == null) {
            tracker = new BroadcasterTracker();
            this.states.put(r.uuid(), tracker);
            logger.trace("AtmosphereResource {} state now tracked", (Object)r.uuid());
        }
        return tracker;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public ConcurrentHashMap<String, BroadcasterTracker> states() {
        return this.states;
    }

    public String toString() {
        return "AtmosphereResource state recovery";
    }

    public List<Object> retrieveCache(AtmosphereResource r, BroadcasterTracker tracker, boolean force) {
        List<Object> cachedMessages = new LinkedList<Object>();
        for (String broadcasterID : tracker.ids()) {
            Object b = this.factory.lookup(broadcasterID, false);
            logger.trace("About to retrieve cached messages for resource {} with Broadcaster {}, tracked by " + b, (Object)r.uuid(), (Object)r.getBroadcaster());
            if (b != null && (force || !b.getID().equalsIgnoreCase(r.getBroadcaster().getID()))) {
                BroadcasterCache cache = b.getBroadcasterConfig().getBroadcasterCache();
                List<Object> t = cache.retrieveFromCache(b.getID(), r);
                cachedMessages = b.getBroadcasterConfig().applyFilters(r, t);
                if (t.size() <= 0) continue;
                logger.trace("Found Cached Messages For AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                cachedMessages.addAll(t);
                continue;
            }
            logger.trace("Broadcaster {} is no longer available for {}", (Object)broadcasterID, (Object)r);
        }
        return cachedMessages;
    }

    private void writeCache(AtmosphereResource r, List<Object> cachedMessages) {
        try {
            logger.trace("Writing cached messages {} for {}", cachedMessages, (Object)r.uuid());
            r.getAtmosphereHandler().onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), false, false, null).setMessage(cachedMessages));
        }
        catch (IOException e) {
            logger.warn("Unable to recover from state recovery {}", (Object)r.uuid(), (Object)e);
        }
    }

    public static final class BroadcasterTracker {
        private final ConcurrentLinkedQueue<String> broadcasterIds = new ConcurrentLinkedQueue();
        private long tick = System.currentTimeMillis();

        public BroadcasterTracker add(Broadcaster b) {
            logger.trace("Adding {}", (Object)b.getID());
            if (!this.broadcasterIds.contains(b.getID())) {
                this.broadcasterIds.add(b.getID());
            }
            return this;
        }

        public BroadcasterTracker remove(Broadcaster b) {
            logger.trace("Removing {}", (Object)b.getID());
            this.broadcasterIds.remove(b.getID());
            return this;
        }

        public ConcurrentLinkedQueue<String> ids() {
            return this.broadcasterIds;
        }

        public BroadcasterTracker tick() {
            this.tick = System.currentTimeMillis();
            return this;
        }

        public long lastTick() {
            return this.tick;
        }
    }

    public final class B
    extends BroadcasterListenerAdapter {
        @Override
        public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            if (t == null) {
                t = AtmosphereResourceStateRecovery.this.track(r);
            }
            logger.trace("Starting tracking the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
            t.add(b);
        }

        @Override
        public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            AtmosphereResourceEvent e = r.getAtmosphereResourceEvent();
            if (e.isClosedByClient() || !r.isResumed() && !e.isResumedOnTimeout()) {
                logger.trace("Deleting the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
                if (t != null) {
                    t.remove(b);
                }
            } else {
                this.onAddAtmosphereResource(b, r);
                logger.trace("Keeping the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
                logger.trace("State for {} with broadcaster {}", (Object)r.uuid(), t != null ? t.ids() : "null");
            }
        }
    }
}

