/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.Map;
import javax.servlet.Servlet;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.interceptor.InvokationOrder;

public class MeteorServiceInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MeteorServiceInterceptor.class);
    private AtmosphereConfig config;
    private boolean wildcardMapping = false;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        this.optimizeMapping();
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!this.wildcardMapping) {
            return Action.CONTINUE;
        }
        this.mapAnnotatedService(r.getRequest(), (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER));
        return Action.CONTINUE;
    }

    protected void optimizeMapping() {
        for (String w : this.config.handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapAnnotatedService(AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Broadcaster b = w.broadcaster;
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (b.getID().contains("{")) {
            this.config.getBroadcasterFactory().remove(b.getID());
        }
        Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> map = this.config.handlers();
        synchronized (map) {
            String targetPath;
            Servlet s;
            MeteorService m;
            if (this.config.handlers().get(path) == null && ReflectorServletProcessor.class.isAssignableFrom(w.atmosphereHandler.getClass()) && (m = (s = ((ReflectorServletProcessor)ReflectorServletProcessor.class.cast(w.atmosphereHandler)).getServlet()).getClass().getAnnotation(MeteorService.class)) != null && (targetPath = m.path()).indexOf("{") != -1 && targetPath.indexOf("}") != -1) {
                try {
                    boolean singleton;
                    boolean bl = singleton = s.getClass().getAnnotation(Singleton.class) != null;
                    if (!singleton) {
                        ReflectorServletProcessor r = this.config.framework().newClassInstance(ReflectorServletProcessor.class, ReflectorServletProcessor.class);
                        r.setServlet(this.config.framework().newClassInstance(Servlet.class, s.getClass()));
                        r.init(this.config);
                        this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)r, this.config.getBroadcasterFactory().lookup(m.broadcaster(), path, true), w.interceptors);
                    } else {
                        this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler, this.config.getBroadcasterFactory().lookup(m.broadcaster(), path, true), w.interceptors);
                    }
                    request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                }
                catch (Throwable e) {
                    logger.warn("Unable to create AtmosphereHandler", e);
                }
            }
        }
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }
}

