package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.LoadPreviewResponse;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;

import tools.jackson.databind.JsonNode;

public class LoadPreviewHandler implements MessageHandler {

    private final HasThemeModifier hasThemeModifier;

    public LoadPreviewHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonNode data) {
        String css = hasThemeModifier.getThemeModifier().getCss();
        return new LoadPreviewResponse(css);
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.LOAD_PREVIEW.getValue();
    }
}
