package com.vaadin.copilot.javarewriter.exception;

import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;

/** Happens when component info not found for unknown reasons. */
public class ComponentInfoNotFoundException extends RuntimeException {
    private final transient ComponentTypeAndSourceLocation componentTypeAndSourceLocation;
    private final String message;

    /**
     * @param componentTypeAndSourceLocation
     *            ComponentTypeAndSourceLocation that causes the exception
     * @param message
     *            default message
     */
    public ComponentInfoNotFoundException(ComponentTypeAndSourceLocation componentTypeAndSourceLocation,
            String message) {
        this.componentTypeAndSourceLocation = componentTypeAndSourceLocation;
        this.message = message;
    }

    public ComponentTypeAndSourceLocation getComponentTypeAndSourceLocation() {
        return componentTypeAndSourceLocation;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
