import { ad as t } from "./copilot-DE_b6Vgc.js";
const C = {
  adsClick: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.775 13.5C7.575 13.4375 6.5625 12.975 5.7375 12.1125C4.9125 11.25 4.5 10.2125 4.5 9C4.5 7.75 4.9375 6.6875 5.8125 5.8125C6.6875 4.9375 7.75 4.5 9 4.5C10.2125 4.5 11.25 4.9125 12.1125 5.7375C12.975 6.5625 13.4375 7.575 13.5 8.775L11.925 8.30625C11.7625 7.63125 11.4125 7.07812 10.875 6.64688C10.3375 6.21563 9.7125 6 9 6C8.175 6 7.46875 6.29375 6.88125 6.88125C6.29375 7.46875 6 8.175 6 9C6 9.7125 6.21563 10.3375 6.64688 10.875C7.07812 11.4125 7.63125 11.7625 8.30625 11.925L8.775 13.5ZM9.675 16.4625C9.5625 16.4875 9.45 16.5 9.3375 16.5H9C7.9625 16.5 6.9875 16.3031 6.075 15.9094C5.1625 15.5156 4.36875 14.9813 3.69375 14.3063C3.01875 13.6313 2.48438 12.8375 2.09063 11.925C1.69688 11.0125 1.5 10.0375 1.5 9C1.5 7.9625 1.69688 6.9875 2.09063 6.075C2.48438 5.1625 3.01875 4.36875 3.69375 3.69375C4.36875 3.01875 5.1625 2.48438 6.075 2.09063C6.9875 1.69688 7.9625 1.5 9 1.5C10.0375 1.5 11.0125 1.69688 11.925 2.09063C12.8375 2.48438 13.6313 3.01875 14.3063 3.69375C14.9813 4.36875 15.5156 5.1625 15.9094 6.075C16.3031 6.9875 16.5 7.9625 16.5 9V9.3375C16.5 9.45 16.4875 9.5625 16.4625 9.675L15 9.225V9C15 7.325 14.4188 5.90625 13.2563 4.74375C12.0938 3.58125 10.675 3 9 3C7.325 3 5.90625 3.58125 4.74375 4.74375C3.58125 5.90625 3 7.325 3 9C3 10.675 3.58125 12.0938 4.74375 13.2563C5.90625 14.4188 7.325 15 9 15H9.225L9.675 16.4625ZM15.3938 16.875L12.1875 13.6688L11.25 16.5L9 9L16.5 11.25L13.6688 12.1875L16.875 15.3938L15.3938 16.875Z"
    fill="currentColor"
  />
</svg>`,
  alertCircle: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 6V9M9 12H9.0075M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alertTriangle: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.99985 6.74999V9.75M8.99985 12.75H9.00735M7.96133 2.91878L1.79264 13.5737C1.45049 14.1647 1.27941 14.4602 1.30469 14.7028C1.32675 14.9143 1.43758 15.1065 1.6096 15.2316C1.80681 15.375 2.14826 15.375 2.83115 15.375H15.1684C15.8514 15.375 16.1928 15.375 16.39 15.2316C16.562 15.1065 16.6729 14.9143 16.6949 14.7028C16.7202 14.4602 16.5491 14.1647 16.207 13.5737L10.0383 2.91878C9.69743 2.3299 9.52695 2.03547 9.30458 1.93658C9.11055 1.85032 8.88908 1.85032 8.69513 1.93658C8.47268 2.03547 8.3022 2.32991 7.96133 2.91878Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignBottom: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 15.75H15.75M9 2.25V12.75M9 12.75L14.25 7.5M9 12.75L3.75 7.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignCenter: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 7.5H4.5M15.75 4.5H2.25M15.75 10.5H2.25M13.5 13.5H4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignHorizontalAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 2.25V15.75M16.5 9H11.625M11.625 9L14.625 12M11.625 9L14.625 6M1.5 9H6.375M6.375 9L3.375 12M6.375 9L3.375 6"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignHorizontal: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12 7.5C12.6989 7.5 13.0484 7.5 13.3241 7.38582C13.6916 7.23358 13.9836 6.94157 14.1359 6.57403C14.25 6.29837 14.25 5.94891 14.25 5.25C14.25 4.55109 14.25 4.20164 14.1359 3.92597C13.9836 3.55844 13.6916 3.26642 13.3241 3.11418C13.0484 3 12.6989 3 12 3H6C5.30109 3 4.95164 3 4.67597 3.11418C4.30844 3.26642 4.01642 3.55844 3.86418 3.92597C3.75 4.20164 3.75 4.55109 3.75 5.25C3.75 5.94891 3.75 6.29837 3.86418 6.57403C4.01642 6.94157 4.30844 7.23358 4.67597 7.38582C4.95164 7.5 5.30109 7.5 6 7.5H12Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M13.5 15C14.1989 15 14.5483 15 14.824 14.8858C15.1915 14.7336 15.4836 14.4415 15.6358 14.074C15.75 13.7983 15.75 13.4489 15.75 12.75C15.75 12.0511 15.75 11.7017 15.6358 11.426C15.4836 11.0585 15.1915 10.7664 14.824 10.6141C14.5483 10.5 14.1989 10.5 13.5 10.5H4.5C3.80109 10.5 3.45164 10.5 3.17597 10.6141C2.80844 10.7664 2.51642 11.0585 2.36418 11.426C2.25 11.7017 2.25 12.0511 2.25 12.75C2.25 13.4489 2.25 13.7983 2.36418 14.074C2.51642 14.4415 2.80844 14.7336 3.17597 14.8858C3.45164 15 3.80109 15 4.5 15H13.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 2.25V15.75M15.75 9H5.25M5.25 9L10.5 14.25M5.25 9L10.5 3.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 15.75V2.25M2.25 9H12.75M12.75 9L7.5 3.75M12.75 9L7.5 14.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignTop: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 2.25H2.25M9 15.75V5.25M9 5.25L3.75 10.5M9 5.25L14.25 10.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignVerticalAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 9H15.75M9 1.5V6.375M9 6.375L12 3.375M9 6.375L6 3.375M9 16.5V11.625M9 11.625L12 14.625M9 11.625L6 14.625"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  alignVertical: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M7.5 13.5V4.5C7.5 3.80109 7.5 3.45164 7.38582 3.17597C7.23358 2.80844 6.94157 2.51642 6.57403 2.36418C6.29837 2.25 5.94891 2.25 5.25 2.25C4.55109 2.25 4.20164 2.25 3.92597 2.36418C3.55844 2.51642 3.26642 2.80844 3.11418 3.17597C3 3.45164 3 3.80109 3 4.5V13.5C3 14.1989 3 14.5483 3.11418 14.824C3.26642 15.1915 3.55844 15.4836 3.92597 15.6358C4.20164 15.75 4.55109 15.75 5.25 15.75C5.94891 15.75 6.29837 15.75 6.57403 15.6358C6.94157 15.4836 7.23358 15.1915 7.38582 14.824C7.5 14.5483 7.5 14.1989 7.5 13.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M15 12V6C15 5.30109 15 4.95164 14.8858 4.67597C14.7336 4.30844 14.4415 4.01642 14.074 3.86418C13.7983 3.75 13.4489 3.75 12.75 3.75C12.0511 3.75 11.7017 3.75 11.426 3.86418C11.0585 4.01642 10.7664 4.30844 10.6141 4.67597C10.5 4.95164 10.5 5.30109 10.5 6V12C10.5 12.6989 10.5 13.0483 10.6141 13.324C10.7664 13.6915 11.0585 13.9836 11.426 14.1358C11.7017 14.25 12.0511 14.25 12.75 14.25C13.4489 14.25 13.7983 14.25 14.074 14.1358C14.4415 13.9836 14.7336 13.6915 14.8858 13.324C15 13.0483 15 12.6989 15 12Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  annotation: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V10.125C15.75 11.1734 15.75 11.6975 15.5787 12.1111C15.3504 12.6623 14.9123 13.1004 14.3611 13.3287C13.9475 13.5 13.4233 13.5 12.375 13.5C12.0086 13.5 11.8253 13.5 11.6554 13.5401C11.4287 13.5936 11.2177 13.6992 11.0389 13.8484C10.9048 13.9603 10.7948 14.1068 10.575 14.4L9.48 15.86C9.31718 16.0772 9.23573 16.1857 9.1359 16.2245C9.04853 16.2585 8.95147 16.2585 8.8641 16.2245C8.76427 16.1857 8.68282 16.0772 8.52 15.86L7.425 14.4C7.20514 14.1068 7.09521 13.9603 6.96112 13.8484C6.78234 13.6992 6.57127 13.5936 6.34463 13.5401C6.17465 13.5 5.99143 13.5 5.625 13.5C4.57664 13.5 4.05245 13.5 3.63896 13.3287C3.08765 13.1004 2.64963 12.6623 2.42127 12.1111C2.25 11.6975 2.25 11.1734 2.25 10.125V5.85Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  areaChart: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.25 15V5.25L5.25 7.5L9 2.25L12.75 5.25H15.75V15H2.25ZM6 12.75L9 8.625L14.25 12.7125V6.75H12.225L9.3 4.40625L5.5875 9.61875L3.75 8.25V10.95L6 12.75Z" fill="currentColor"/>
</svg>
`,
  arrowCircleUp: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_2008_20454)">
    <path
      d="M12 9L9 6M9 6L6 9M9 6V12M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_2008_20454">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  arrowDownLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 5.25L5.25 12.75M5.25 12.75H12.75M5.25 12.75V5.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  arrowDownRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 5.25L12.75 12.75M12.75 12.75V5.25M12.75 12.75H5.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  arrowDown: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 3.75V14.25M9 14.25L14.25 9M9 14.25L3.75 9"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  arrowLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15 9H3M3 9L7.5 13.5M3 9L7.5 4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  arrowRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 9H15M15 9L10.5 4.5M15 9L10.5 13.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  arrowUpLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 12.75L5.25 5.25M5.25 5.25V12.75M5.25 5.25H12.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  arrowUpRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 12.75L12.75 5.25M12.75 5.25H5.25M12.75 5.25V12.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  atSign: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_858_19587)">
    <path
      d="M12 5.99999V9.75C12 10.3467 12.2371 10.919 12.659 11.341C13.081 11.7629 13.6532 12 14.25 12C14.8467 12 15.419 11.7629 15.841 11.341C16.2629 10.919 16.5 10.3467 16.5 9.75V9C16.4999 7.30726 15.9272 5.66435 14.875 4.33839C13.8227 3.01243 12.3529 2.08141 10.7045 1.69672C9.05604 1.31202 7.32596 1.49627 5.79552 2.21952C4.26508 2.94276 3.0243 4.16246 2.27495 5.68028C1.52559 7.19811 1.31173 8.92477 1.66813 10.5796C2.02453 12.2344 2.93024 13.7199 4.23798 14.7947C5.54572 15.8695 7.17858 16.4702 8.87109 16.4993C10.5635 16.5284 12.2161 15.9842 13.56 14.955M12 9C12 10.6568 10.6568 12 9.00001 12C7.34316 12 6.00001 10.6568 6.00001 9C6.00001 7.34314 7.34316 5.99999 9.00001 5.99999C10.6568 5.99999 12 7.34314 12 9Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_858_19587">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  atom: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.99963 9.00007H9.00713M11.6513 11.6518C8.1366 15.1665 4.10014 16.8285 2.63567 15.364C1.17121 13.8996 2.83327 9.86317 6.34799 6.34846C9.86273 2.83374 13.8992 1.17168 15.3636 2.63614C16.8281 4.10061 15.166 8.13705 11.6513 11.6518ZM11.6513 6.34832C15.166 9.86302 16.8281 13.8995 15.3636 15.3639C13.8991 16.8284 9.86265 15.1663 6.34796 11.6516C2.83324 8.1369 1.17118 4.10047 2.63564 2.63601C4.10011 1.17154 8.13653 2.8336 11.6513 6.34832ZM9.37463 9.00007C9.37463 9.20722 9.20678 9.37507 8.99963 9.37507C8.79255 9.37507 8.62463 9.20722 8.62463 9.00007C8.62463 8.793 8.79255 8.62507 8.99963 8.62507C9.20678 8.62507 9.37463 8.793 9.37463 9.00007Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  avatar: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_881_4201)">
    <path
      d="M3.98722 14.5788C4.44346 13.5039 5.50869 12.75 6.75 12.75H11.25C12.4913 12.75 13.5566 13.5039 14.0128 14.5788M12 7.125C12 8.78183 10.6568 10.125 9 10.125C7.34314 10.125 6 8.78183 6 7.125C6 5.46814 7.34314 4.125 9 4.125C10.6568 4.125 12 5.46814 12 7.125ZM16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_881_4201">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  barChartAlt: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.75 5.25H3.45C3.02996 5.25 2.81994 5.25 2.65951 5.33174C2.51839 5.40365 2.40365 5.51839 2.33174 5.65951C2.25 5.81994 2.25 6.02996 2.25 6.45V14.55C2.25 14.9701 2.25 15.1801 2.33174 15.3405C2.40365 15.4817 2.51839 15.5963 2.65951 15.6683C2.81994 15.75 3.02996 15.75 3.45 15.75H6.75M6.75 15.75H11.25M6.75 15.75V3.45C6.75 3.02996 6.75 2.81994 6.83174 2.65951C6.90365 2.51839 7.01839 2.40365 7.15951 2.33174C7.31994 2.25 7.52993 2.25 7.95 2.25H10.05C10.4701 2.25 10.6801 2.25 10.8405 2.33174C10.9817 2.40365 11.0963 2.51839 11.1682 2.65951C11.25 2.81994 11.25 3.02996 11.25 3.45V15.75M11.25 15.75H14.55C14.9701 15.75 15.1801 15.75 15.3405 15.6683C15.4817 15.5963 15.5963 15.4817 15.6683 15.3405C15.75 15.1801 15.75 14.9701 15.75 14.55V9.45C15.75 9.02993 15.75 8.81992 15.6683 8.6595C15.5963 8.51835 15.4817 8.40368 15.3405 8.33175C15.1801 8.25 14.9701 8.25 14.55 8.25H11.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
  `,
  barChart: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 15V7.5M9 15V3M4.5 15V10.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  bell: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M11.2498 14.25C11.2498 15.4927 10.2424 16.5 8.99977 16.5C7.75717 16.5 6.74979 15.4927 6.74979 14.25M10.3471 4.67892C10.6738 4.34148 10.8748 3.88172 10.8748 3.375C10.8748 2.33947 10.0353 1.5 8.99977 1.5C7.96425 1.5 7.12479 2.33947 7.12479 3.375C7.12479 3.88172 7.32579 4.34148 7.6524 4.67892M13.4998 8.4C13.4998 7.36565 13.0257 6.37367 12.1818 5.64228C11.3378 4.91089 10.1932 4.5 8.99977 4.5C7.8063 4.5 6.66172 4.91089 5.81781 5.64228C4.97389 6.37367 4.49979 7.36565 4.49979 8.4C4.49979 10.1113 4.07538 11.3629 3.54583 12.2585C2.94229 13.2792 2.64052 13.7896 2.65244 13.9114C2.66607 14.0509 2.69118 14.095 2.80429 14.1777C2.90316 14.25 3.39992 14.25 4.39343 14.25H13.6061C14.5996 14.25 15.0964 14.25 15.1953 14.1777C15.3084 14.095 15.3335 14.0509 15.3472 13.9114C15.359 13.7896 15.0573 13.2792 14.4538 12.2585C13.9242 11.3629 13.4998 10.1113 13.4998 8.4Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  bookOpen: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 15.75L8.92493 15.6374C8.40398 14.856 8.1435 14.4652 7.79933 14.1823C7.49465 13.9319 7.14357 13.744 6.76621 13.6294C6.33994 13.5 5.87033 13.5 4.93112 13.5H3.9C3.05992 13.5 2.63988 13.5 2.31902 13.3365C2.03677 13.1927 1.8073 12.9632 1.66349 12.681C1.5 12.3602 1.5 11.9401 1.5 11.1V4.65C1.5 3.80992 1.5 3.38988 1.66349 3.06902C1.8073 2.78677 2.03677 2.5573 2.31902 2.41349C2.63988 2.25 3.05992 2.25 3.9 2.25H4.2C5.88016 2.25 6.72023 2.25 7.36197 2.57698C7.92645 2.8646 8.38538 3.32354 8.673 3.88803C9 4.52976 9 5.36984 9 7.05M9 15.75V7.05M9 15.75L9.07507 15.6374C9.59602 14.856 9.8565 14.4652 10.2007 14.1823C10.5053 13.9319 10.8564 13.744 11.2338 13.6294C11.66 13.5 12.1297 13.5 13.0689 13.5H14.1C14.9401 13.5 15.3602 13.5 15.681 13.3365C15.9632 13.1927 16.1927 12.9632 16.3365 12.681C16.5 12.3602 16.5 11.9401 16.5 11.1V4.65C16.5 3.80992 16.5 3.38988 16.3365 3.06902C16.1927 2.78677 15.9632 2.5573 15.681 2.41349C15.3602 2.25 14.9401 2.25 14.1 2.25H13.8C12.1198 2.25 11.2798 2.25 10.638 2.57698C10.0736 2.8646 9.61462 3.32354 9.327 3.88803C9 4.52976 9 5.36984 9 7.05"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  browser: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M16.5 6.75H1.5M1.5 5.85V12.15C1.5 13.4102 1.5 14.0401 1.74524 14.5215C1.96095 14.9449 2.30516 15.2891 2.72852 15.5048C3.20982 15.75 3.83988 15.75 5.1 15.75H12.9C14.1602 15.75 14.7901 15.75 15.2715 15.5048C15.6949 15.2891 16.0391 14.9449 16.2548 14.5215C16.5 14.0401 16.5 13.4102 16.5 12.15V5.85C16.5 4.58988 16.5 3.95983 16.2548 3.47852C16.0391 3.05516 15.6949 2.71095 15.2715 2.49524C14.7901 2.25 14.1602 2.25 12.9 2.25H5.1C3.83988 2.25 3.20982 2.25 2.72852 2.49524C2.30516 2.71095 1.96095 3.05516 1.74524 3.47852C1.5 3.95982 1.5 4.58988 1.5 5.85Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  bubbleChart: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.875 15.75C10.25 15.75 9.71875 15.5313 9.28125 15.0938C8.84375 14.6563 8.625 14.125 8.625 13.5C8.625 12.875 8.84375 12.3438 9.28125 11.9063C9.71875 11.4688 10.25 11.25 10.875 11.25C11.5 11.25 12.0313 11.4688 12.4688 11.9063C12.9063 12.3438 13.125 12.875 13.125 13.5C13.125 14.125 12.9063 14.6563 12.4688 15.0938C12.0313 15.5313 11.5 15.75 10.875 15.75ZM10.875 14.25C11.0875 14.25 11.2656 14.1781 11.4094 14.0344C11.5531 13.8906 11.625 13.7125 11.625 13.5C11.625 13.2875 11.5531 13.1094 11.4094 12.9656C11.2656 12.8219 11.0875 12.75 10.875 12.75C10.6625 12.75 10.4844 12.8219 10.3406 12.9656C10.1969 13.1094 10.125 13.2875 10.125 13.5C10.125 13.7125 10.1969 13.8906 10.3406 14.0344C10.4844 14.1781 10.6625 14.25 10.875 14.25ZM12.375 10.5C11.225 10.5 10.25 10.1 9.45 9.3C8.65 8.5 8.25 7.525 8.25 6.375C8.25 5.225 8.65 4.25 9.45 3.45C10.25 2.65 11.225 2.25 12.375 2.25C13.525 2.25 14.5 2.65 15.3 3.45C16.1 4.25 16.5 5.225 16.5 6.375C16.5 7.525 16.1 8.5 15.3 9.3C14.5 10.1 13.525 10.5 12.375 10.5ZM12.375 9C13.1125 9 13.7344 8.74688 14.2406 8.24063C14.7469 7.73438 15 7.1125 15 6.375C15 5.6375 14.7469 5.01563 14.2406 4.50938C13.7344 4.00313 13.1125 3.75 12.375 3.75C11.6375 3.75 11.0156 4.00313 10.5094 4.50938C10.0031 5.01563 9.75 5.6375 9.75 6.375C9.75 7.1125 10.0031 7.73438 10.5094 8.24063C11.0156 8.74688 11.6375 9 12.375 9ZM5.25 13.5C4.425 13.5 3.71875 13.2063 3.13125 12.6188C2.54375 12.0313 2.25 11.325 2.25 10.5C2.25 9.675 2.54375 8.96875 3.13125 8.38125C3.71875 7.79375 4.425 7.5 5.25 7.5C6.075 7.5 6.78125 7.79375 7.36875 8.38125C7.95625 8.96875 8.25 9.675 8.25 10.5C8.25 11.325 7.95625 12.0313 7.36875 12.6188C6.78125 13.2063 6.075 13.5 5.25 13.5ZM5.25 12C5.6625 12 6.01563 11.8531 6.30938 11.5594C6.60313 11.2656 6.75 10.9125 6.75 10.5C6.75 10.0875 6.60313 9.73438 6.30938 9.44063C6.01563 9.14688 5.6625 9 5.25 9C4.8375 9 4.48438 9.14688 4.19063 9.44063C3.89688 9.73438 3.75 10.0875 3.75 10.5C3.75 10.9125 3.89688 11.2656 4.19063 11.5594C4.48438 11.8531 4.8375 12 5.25 12Z" fill="currentColor"/>
</svg>`,
  calendarPlus: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 6H2.25M12 1.5V3.75M6 1.5V3.75M9 13.5V9M6.75 11.25H11.25M5.85 16.5H12.15C13.4102 16.5 14.0401 16.5 14.5215 16.2548C14.9449 16.0391 15.2891 15.6949 15.5048 15.2715C15.75 14.7901 15.75 14.1602 15.75 12.9V6.6C15.75 5.33988 15.75 4.70982 15.5048 4.22852C15.2891 3.80516 14.9449 3.46095 14.5215 3.24524C14.0401 3 13.4102 3 12.15 3H5.85C4.58988 3 3.95982 3 3.47852 3.24524C3.05516 3.46095 2.71095 3.80516 2.49524 4.22852C2.25 4.70982 2.25 5.33988 2.25 6.6V12.9C2.25 14.1602 2.25 14.7901 2.49524 15.2715C2.71095 15.6949 3.05516 16.0391 3.47852 16.2548C3.95982 16.5 4.58988 16.5 5.85 16.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  calendar: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 7.5H2.25M12 1.5V4.5M6 1.5V4.5M5.85 16.5H12.15C13.4102 16.5 14.0401 16.5 14.5215 16.2548C14.9449 16.0391 15.2891 15.6949 15.5048 15.2715C15.75 14.7901 15.75 14.1602 15.75 12.9V6.6C15.75 5.33988 15.75 4.70982 15.5048 4.22852C15.2891 3.80516 14.9449 3.46095 14.5215 3.24524C14.0401 3 13.4102 3 12.15 3H5.85C4.58988 3 3.95982 3 3.47852 3.24524C3.05516 3.46095 2.71095 3.80516 2.49524 4.22852C2.25 4.70982 2.25 5.33988 2.25 6.6V12.9C2.25 14.1602 2.25 14.7901 2.49524 15.2715C2.71095 15.6949 3.05516 16.0391 3.47852 16.2548C3.95982 16.5 4.58988 16.5 5.85 16.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  caretDown: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path d="M9 12L4 7H14L9 12Z" fill="currentColor" />
</svg>`,
  caretLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path d="M7 9L12 4V14L7 9Z" fill="currentColor" />
</svg>`,
  caretRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path d="M12 9L7 4V14L12 9Z" fill="currentColor" />
</svg>`,
  caretUp: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path d="M9 7L4 12H14L9 7Z" fill="currentColor" />
</svg>`,
  checkCircle: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_863_3902)">
    <path
      d="M5.625 9L7.875 11.25L12.375 6.75M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_863_3902">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  checkDone: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_858_19549)">
    <path
      d="M12 6V3.9C12 3.05992 12 2.63988 11.8365 2.31902C11.6927 2.03677 11.4632 1.8073 11.181 1.66349C10.8601 1.5 10.4401 1.5 9.6 1.5H3.9C3.05992 1.5 2.63988 1.5 2.31902 1.66349C2.03677 1.8073 1.8073 2.03677 1.66349 2.31902C1.5 2.63988 1.5 3.05992 1.5 3.9V9.6C1.5 10.4401 1.5 10.8601 1.66349 11.181C1.8073 11.4632 2.03677 11.6927 2.31902 11.8365C2.63988 12 3.05992 12 3.9 12H6M9 11.25L10.5 12.75L13.875 9.375M8.4 16.5H14.1C14.9401 16.5 15.3602 16.5 15.681 16.3365C15.9632 16.1927 16.1927 15.9632 16.3365 15.681C16.5 15.3602 16.5 14.9401 16.5 14.1V8.4C16.5 7.55992 16.5 7.13988 16.3365 6.81902C16.1927 6.53677 15.9632 6.3073 15.681 6.16349C15.3602 6 14.9401 6 14.1 6H8.4C7.55992 6 7.13988 6 6.81902 6.16349C6.53677 6.3073 6.3073 6.53677 6.16349 6.81902C6 7.13988 6 7.55992 6 8.4V14.1C6 14.9401 6 15.3602 6.16349 15.681C6.3073 15.9632 6.53677 16.1927 6.81902 16.3365C7.13988 16.5 7.55992 16.5 8.4 16.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_858_19549">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  checkSquare: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.625 9L7.875 11.25L12.375 6.75M5.85 15.75H12.15C13.4102 15.75 14.0401 15.75 14.5215 15.5048C14.9449 15.2891 15.2891 14.9449 15.5048 14.5215C15.75 14.0401 15.75 13.4102 15.75 12.15V5.85C15.75 4.58988 15.75 3.95982 15.5048 3.47852C15.2891 3.05516 14.9449 2.71095 14.5215 2.49524C14.0401 2.25 13.4102 2.25 12.15 2.25H5.85C4.58988 2.25 3.95982 2.25 3.47852 2.49524C3.05516 2.71095 2.71095 3.05516 2.49524 3.47852C2.25 3.95982 2.25 4.58988 2.25 5.85V12.15C2.25 13.4102 2.25 14.0401 2.49524 14.5215C2.71095 14.9449 3.05516 15.2891 3.47852 15.5048C3.95982 15.75 4.58988 15.75 5.85 15.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  check: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15 4.5L6.75 12.75L3 9"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  checklist: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.1625 14.25L1.5 11.5875L2.55 10.5375L4.14375 12.1313L7.33125 8.94376L8.38125 10.0125L4.1625 14.25ZM4.1625 8.25001L1.5 5.58751L2.55 4.53751L4.14375 6.13126L7.33125 2.94376L8.38125 4.01251L4.1625 8.25001ZM9.75 12.75V11.25H16.5V12.75H9.75ZM9.75 6.75001V5.25001H16.5V6.75001H9.75Z"
    fill="currentColor"
  />
</svg>`,
  chevronDown: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 6.75L9 11.25L13.5 6.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  chevronLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M11.25 13.5L6.75 9L11.25 4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  chevronRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 13.5L11.25 9L6.75 4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  chevronRightDouble: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.5 12.75L8.25 9L4.5 5.25M9.75 12.75L13.5 9L9.75 5.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  chevronSelectorVertical: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 11.25L9 15L12.75 11.25M5.25 6.75L9 3L12.75 6.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  chevronUp: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 11.25L9 6.75L4.5 11.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  circle: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_907_8660)">
    <path
      d="M9 16.5C13.1421 16.5 16.5 13.1421 16.5 9C16.5 4.85786 13.1421 1.5 9 1.5C4.85786 1.5 1.5 4.85786 1.5 9C1.5 13.1421 4.85786 16.5 9 16.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_907_8660">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  clickAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1705_14570)">
    <path
      d="M6.75 2.625V1.5M3.79549 3.79549L3 3M3.79549 9.75L3 10.5455M9.75 3.79549L10.5455 3M2.625 6.75H1.5M6.375 6.375L9.45833 15.9583L11.625 13.7917L14.3333 16.5L16.5 14.3333L13.7917 11.625L15.9583 9.45833L6.375 6.375Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1705_14570">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  click: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1705_14569)">
    <path
      d="M6.75 2.625V1.5M3.79549 3.79549L3 3M3.79549 9.75L3 10.5455M9.75 3.79549L10.5455 3M2.625 6.75H1.5M11.8984 12.1422L10.0295 15.6127C9.81607 16.0093 9.70927 16.2075 9.58087 16.2577C9.46942 16.3012 9.34388 16.2889 9.243 16.2246C9.12668 16.1505 9.06045 15.9353 8.92785 15.505L6.33389 7.08394C6.2256 6.73238 6.17145 6.5566 6.21502 6.43787C6.25297 6.33446 6.33446 6.25297 6.43787 6.21503C6.5566 6.17146 6.73237 6.2256 7.08394 6.33389L15.5049 8.92785C15.9353 9.06045 16.1504 9.12675 16.2245 9.243C16.2889 9.34395 16.3011 9.46942 16.2576 9.58087C16.2075 9.70935 16.0092 9.81607 15.6127 10.0296L12.1422 11.8984C12.0832 11.9301 12.0538 11.9459 12.028 11.9663C12.0051 11.9844 11.9844 12.0051 11.9663 12.028C11.9459 12.0538 11.9301 12.0832 11.8984 12.1422Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1705_14569">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  clipboardCheck: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12 3C12.6975 3 13.0463 3 13.3324 3.07667C14.1088 3.28472 14.7153 3.8912 14.9234 4.66765C15 4.95378 15 5.30252 15 6V12.9C15 14.1602 15 14.7901 14.7548 15.2715C14.5391 15.6949 14.1949 16.0391 13.7715 16.2548C13.2901 16.5 12.6601 16.5 11.4 16.5H6.6C5.33988 16.5 4.70982 16.5 4.22852 16.2548C3.80516 16.0391 3.46095 15.6949 3.24524 15.2715C3 14.7901 3 14.1602 3 12.9V6C3 5.30252 3 4.95378 3.07667 4.66765C3.28472 3.8912 3.8912 3.28472 4.66765 3.07667C4.95378 3 5.30252 3 6 3M6.75 11.25L8.25 12.75L11.625 9.375M7.2 4.5H10.8C11.2201 4.5 11.4301 4.5 11.5905 4.41826C11.7317 4.34635 11.8463 4.23161 11.9182 4.09049C12 3.93006 12 3.72004 12 3.3V2.7C12 2.27996 12 2.06994 11.9182 1.90951C11.8463 1.76839 11.7317 1.65365 11.5905 1.58174C11.4301 1.5 11.2201 1.5 10.8 1.5H7.2C6.77996 1.5 6.56994 1.5 6.40951 1.58174C6.26839 1.65365 6.15365 1.76839 6.08174 1.90951C6 2.06994 6 2.27996 6 2.7V3.3C6 3.72004 6 3.93006 6.08174 4.09049C6.15365 4.23161 6.26839 4.34635 6.40951 4.41826C6.56994 4.5 6.77996 4.5 7.2 4.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  clipboard: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12 3C12.6975 3 13.0463 3 13.3324 3.07667C14.1088 3.28472 14.7153 3.8912 14.9234 4.66765C15 4.95378 15 5.30252 15 6V12.9C15 14.1602 15 14.7901 14.7548 15.2715C14.5391 15.6949 14.1949 16.0391 13.7715 16.2548C13.2901 16.5 12.6601 16.5 11.4 16.5H6.6C5.33988 16.5 4.70982 16.5 4.22852 16.2548C3.80516 16.0391 3.46095 15.6949 3.24524 15.2715C3 14.7901 3 14.1602 3 12.9V6C3 5.30252 3 4.95378 3.07667 4.66765C3.28472 3.8912 3.8912 3.28472 4.66765 3.07667C4.95378 3 5.30252 3 6 3M7.2 4.5H10.8C11.2201 4.5 11.4301 4.5 11.5905 4.41826C11.7317 4.34635 11.8463 4.23161 11.9182 4.09049C12 3.93006 12 3.72004 12 3.3V2.7C12 2.27996 12 2.06994 11.9182 1.90951C11.8463 1.76839 11.7317 1.65365 11.5905 1.58174C11.4301 1.5 11.2201 1.5 10.8 1.5H7.2C6.77996 1.5 6.56994 1.5 6.40951 1.58174C6.26839 1.65365 6.15365 1.76839 6.08174 1.90951C6 2.06994 6 2.27996 6 2.7V3.3C6 3.72004 6 3.93006 6.08174 4.09049C6.15365 4.23161 6.26839 4.34635 6.40951 4.41826C6.56994 4.5 6.77996 4.5 7.2 4.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  clock: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_868_4216)">
    <path
      d="M9 4.5V9L12 10.5M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_868_4216">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  cloud: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.875 14.25C3.01104 14.25 1.5 12.739 1.5 10.875C1.5 9.1173 2.84363 7.67348 4.5598 7.51455C4.91086 5.3791 6.76518 3.75 9 3.75C11.2348 3.75 13.0891 5.3791 13.4402 7.51455C15.1564 7.67348 16.5 9.1173 16.5 10.875C16.5 12.739 14.989 14.25 13.125 14.25C9.83265 14.25 7.75747 14.25 4.875 14.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  codeAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 12.75L16.5 9L12.75 5.25M5.25 5.25L1.5 9L5.25 12.75M10.5 2.25L7.5 15.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  code: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12 13.5L16.5 9L12 4.5M6 4.5L1.5 9L6 13.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  coinsHand: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_2290_25891)">
<path d="M10.1471 6.2639C9.71783 6.56996 9.19245 6.75 8.625 6.75C7.17525 6.75 6 5.57475 6 4.125C6 2.67525 7.17525 1.5 8.625 1.5C9.56475 1.5 10.3891 1.99381 10.8529 2.7361M4.5 15.0654H6.45772C6.71297 15.0654 6.96666 15.0958 7.21411 15.1564L9.28267 15.6592C9.73147 15.7685 10.1991 15.7791 10.6526 15.6911L12.9398 15.2461C13.5439 15.1284 14.0997 14.8391 14.5352 14.4154L16.1534 12.8413C16.6155 12.3926 16.6155 11.6643 16.1534 11.2148C15.7374 10.8101 15.0785 10.7645 14.6078 11.1077L12.722 12.4837C12.4519 12.6811 12.1232 12.7874 11.7853 12.7874H9.96412H11.1233C11.7767 12.7874 12.3059 12.2725 12.3059 11.6369V11.4068C12.3059 10.8791 11.9367 10.419 11.4106 10.2914L9.62145 9.85627C9.3303 9.7857 9.0321 9.75 8.73232 9.75C8.00872 9.75 6.69892 10.3491 6.69892 10.3491L4.5 11.2687M15 4.875C15 6.32475 13.8247 7.5 12.375 7.5C10.9253 7.5 9.75 6.32475 9.75 4.875C9.75 3.42525 10.9253 2.25 12.375 2.25C13.8247 2.25 15 3.42525 15 4.875ZM1.5 10.95V15.3C1.5 15.7201 1.5 15.9301 1.58174 16.0905C1.65365 16.2317 1.76839 16.3463 1.90951 16.4183C2.06994 16.5 2.27996 16.5 2.7 16.5H3.3C3.72004 16.5 3.93006 16.5 4.09049 16.4183C4.23161 16.3463 4.34635 16.2317 4.41826 16.0905C4.5 15.9301 4.5 15.7201 4.5 15.3V10.95C4.5 10.5299 4.5 10.3199 4.41826 10.1595C4.34635 10.0183 4.23161 9.90368 4.09049 9.83175C3.93006 9.75 3.72004 9.75 3.3 9.75H2.7C2.27996 9.75 2.06994 9.75 1.90951 9.83175C1.76839 9.90368 1.65365 10.0183 1.58174 10.1595C1.5 10.3199 1.5 10.5299 1.5 10.95Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</g>
<defs>
<clipPath id="clip0_2290_25891">
<rect width="18" height="18" fill="white"/>
</clipPath>
</defs>
</svg>

  `,
  columns: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  command: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 6.75V4.5C6.75 3.25736 5.74264 2.25 4.5 2.25C3.25736 2.25 2.25 3.25736 2.25 4.5C2.25 5.74264 3.25736 6.75 4.5 6.75H6.75ZM6.75 6.75V11.25M6.75 6.75H11.25M6.75 11.25V13.5C6.75 14.7427 5.74264 15.75 4.5 15.75C3.25736 15.75 2.25 14.7427 2.25 13.5C2.25 12.2573 3.25736 11.25 4.5 11.25H6.75ZM6.75 11.25H11.25M11.25 6.75V11.25M11.25 6.75V4.5C11.25 3.25736 12.2573 2.25 13.5 2.25C14.7427 2.25 15.75 3.25736 15.75 4.5C15.75 5.74264 14.7427 6.75 13.5 6.75H11.25ZM11.25 11.25H13.5C14.7427 11.25 15.75 12.2573 15.75 13.5C15.75 14.7427 14.7427 15.75 13.5 15.75C12.2573 15.75 11.25 14.7427 11.25 13.5V11.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  components: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M11.8301 16.3828C14.9274 16.3828 17.4375 13.921 17.4375 10.8848C17.4375 7.84862 14.9274 5.38678 11.8301 5.38678C8.73355 5.38678 6.22278 7.84794 6.22278 10.8848C6.22278 13.921 8.73288 16.3828 11.8301 16.3828Z"
    fill="#FF707A"
  />
  <path
    d="M4.96774 2.25307L0.736386 9.44213C0.651353 9.58624 0.596082 9.74548 0.573739 9.91063C0.551401 10.0758 0.562432 10.2437 0.606201 10.4047C0.649975 10.5657 0.72562 10.7166 0.828805 10.8487C0.93199 10.9808 1.06067 11.0917 1.20747 11.1747C1.40435 11.2854 1.62653 11.345 1.85294 11.3456H10.3206C10.5475 11.3457 10.7705 11.2872 10.9673 11.176C11.1641 11.0648 11.3277 10.9047 11.442 10.7118C11.5556 10.519 11.6153 10.3002 11.6153 10.0773C11.6153 9.8545 11.5556 9.63563 11.442 9.44286L7.21069 2.25307C7.09712 2.05936 6.9336 1.89857 6.73673 1.78692C6.53979 1.67527 6.31648 1.61673 6.08923 1.61719C5.86209 1.61736 5.63901 1.67617 5.44219 1.78776C5.24539 1.89934 5.08179 2.05979 4.96774 2.25307Z"
    fill="#00B4F0"
  />
  <path
    d="M11.442 9.44287L9.38465 5.94519C8.43897 6.39418 7.64056 7.09567 7.08053 7.96974C6.52163 8.84268 6.2243 9.85305 6.22278 10.8848C6.22278 11.0412 6.22278 11.1934 6.24877 11.3456H10.3205C10.5474 11.3458 10.7704 11.2873 10.9672 11.176C11.164 11.0648 11.3277 10.9048 11.442 10.7118C11.5555 10.519 11.6153 10.3002 11.6153 10.0773C11.6153 9.85451 11.5555 9.63564 11.442 9.44287Z"
    fill="#5748FF"
  />
</svg>`,
  cookie: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 16.5C7.9625 16.5 6.9875 16.3031 6.075 15.9094C5.1625 15.5156 4.36875 14.9813 3.69375 14.3063C3.01875 13.6313 2.48438 12.8375 2.09063 11.925C1.69688 11.0125 1.5 10.0375 1.5 9.00001C1.5 8.06251 1.68125 7.14376 2.04375 6.24376C2.40625 5.34376 2.9125 4.54064 3.5625 3.83439C4.2125 3.12814 4.99375 2.55939 5.90625 2.12814C6.81875 1.69689 7.81875 1.48126 8.90625 1.48126C9.16875 1.48126 9.4375 1.49376 9.7125 1.51876C9.9875 1.54376 10.2688 1.58751 10.5563 1.65001C10.4438 2.21251 10.4813 2.74376 10.6688 3.24376C10.8563 3.74376 11.1375 4.15939 11.5125 4.49064C11.8875 4.82189 12.3344 5.05001 12.8531 5.17501C13.3719 5.30001 13.9063 5.26876 14.4563 5.08126C14.1313 5.81876 14.1781 6.52501 14.5969 7.20001C15.0156 7.87501 15.6375 8.22501 16.4625 8.25001C16.475 8.38751 16.4844 8.51564 16.4906 8.63439C16.4969 8.75314 16.5 8.88126 16.5 9.01876C16.5 10.0438 16.3031 11.0094 15.9094 11.9156C15.5156 12.8219 14.9813 13.6156 14.3063 14.2969C13.6313 14.9781 12.8375 15.5156 11.925 15.9094C11.0125 16.3031 10.0375 16.5 9 16.5ZM7.875 7.50001C8.1875 7.50001 8.45313 7.39064 8.67188 7.17189C8.89063 6.95314 9 6.68751 9 6.37501C9 6.06251 8.89063 5.79689 8.67188 5.57814C8.45313 5.35939 8.1875 5.25001 7.875 5.25001C7.5625 5.25001 7.29688 5.35939 7.07812 5.57814C6.85938 5.79689 6.75 6.06251 6.75 6.37501C6.75 6.68751 6.85938 6.95314 7.07812 7.17189C7.29688 7.39064 7.5625 7.50001 7.875 7.50001ZM6.375 11.25C6.6875 11.25 6.95312 11.1406 7.17188 10.9219C7.39063 10.7031 7.5 10.4375 7.5 10.125C7.5 9.81251 7.39063 9.54689 7.17188 9.32814C6.95312 9.10939 6.6875 9.00001 6.375 9.00001C6.0625 9.00001 5.79688 9.10939 5.57812 9.32814C5.35938 9.54689 5.25 9.81251 5.25 10.125C5.25 10.4375 5.35938 10.7031 5.57812 10.9219C5.79688 11.1406 6.0625 11.25 6.375 11.25ZM11.25 12C11.4625 12 11.6406 11.9281 11.7844 11.7844C11.9281 11.6406 12 11.4625 12 11.25C12 11.0375 11.9281 10.8594 11.7844 10.7156C11.6406 10.5719 11.4625 10.5 11.25 10.5C11.0375 10.5 10.8594 10.5719 10.7156 10.7156C10.5719 10.8594 10.5 11.0375 10.5 11.25C10.5 11.4625 10.5719 11.6406 10.7156 11.7844C10.8594 11.9281 11.0375 12 11.25 12ZM9 15C10.525 15 11.8781 14.475 13.0594 13.425C14.2406 12.375 14.8875 11.0375 15 9.41251C14.375 9.13751 13.8844 8.76251 13.5281 8.28751C13.1719 7.81251 12.9313 7.28126 12.8063 6.69376C11.8438 6.55626 11.0188 6.14376 10.3313 5.45626C9.64375 4.76876 9.21875 3.94376 9.05625 2.98126C8.05625 2.95626 7.17813 3.13751 6.42188 3.52501C5.66563 3.91251 5.03438 4.40939 4.52813 5.01564C4.02188 5.62189 3.64062 6.28126 3.38438 6.99376C3.12813 7.70626 3 8.37501 3 9.00001C3 10.6625 3.58438 12.0781 4.75313 13.2469C5.92188 14.4156 7.3375 15 9 15Z"
    fill="currentColor"
  />
</svg>`,
  copilot: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <mask
    id="mask0_2008_20980"
    style="mask-type: luminance"
    maskUnits="userSpaceOnUse"
    x="0"
    y="2"
    width="18"
    height="13"
  >
    <path d="M18 2.35413H0V14.8641H18V2.35413Z" fill="white" />
  </mask>
  <g mask="url(#mask0_2008_20980)">
    <path
      d="M4.94876 3.65988L1.30575 7.30291C0.584607 8.02408 0.584607 9.19329 1.30575 9.91441L4.94877 13.5575C5.6699 14.2786 6.83911 14.2786 7.56027 13.5575L11.2033 9.91441C11.9244 9.19329 11.9244 8.02408 11.2033 7.30291L7.56022 3.65988C6.83911 2.93873 5.6699 2.93873 4.94876 3.65988Z"
      fill="#00B4F0"
    />
    <path
      d="M10.4397 3.66079L6.79669 7.30383C6.07558 8.025 6.07558 9.19421 6.79669 9.91533L10.4397 13.5584C11.1608 14.2795 12.3301 14.2795 13.0512 13.5584L16.6942 9.91533C17.4154 9.19421 17.4154 8.025 16.6942 7.30383L13.0512 3.66079C12.3301 2.93965 11.1608 2.93965 10.4397 3.66079Z"
      fill="#FF707A"
    />
    <path
      d="M11.2065 7.30385L8.99055 5.08789L6.77464 7.30385C6.42846 7.65014 6.23401 8.11973 6.23401 8.60939C6.23401 9.09905 6.42846 9.56864 6.77464 9.91493L8.99055 12.1309L11.2065 9.91493C11.5526 9.56864 11.7471 9.09905 11.7471 8.60939C11.7471 8.11973 11.5526 7.65014 11.2065 7.30385Z"
      fill="#5748FF"
    />
  </g>
</svg>`,
  copyAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1705_14554)">
    <path
      d="M7.875 1.5021C7.36871 1.50895 7.06478 1.53827 6.81902 1.66349C6.53677 1.8073 6.3073 2.03677 6.16349 2.31902C6.03827 2.56478 6.00895 2.86871 6.0021 3.375M14.625 1.5021C15.1313 1.50895 15.4352 1.53827 15.681 1.66349C15.9632 1.8073 16.1927 2.03677 16.3365 2.31902C16.4617 2.56478 16.4911 2.8687 16.4979 3.37499M16.4979 10.125C16.4911 10.6313 16.4617 10.9352 16.3365 11.181C16.1927 11.4632 15.9632 11.6927 15.681 11.8365C15.4352 11.9617 15.1313 11.9911 14.625 11.9979M16.5 5.99999V7.49999M10.5001 1.5H12M3.9 16.5H9.6C10.4401 16.5 10.8601 16.5 11.181 16.3365C11.4632 16.1927 11.6927 15.9632 11.8365 15.681C12 15.3602 12 14.9401 12 14.1V8.4C12 7.55992 12 7.13988 11.8365 6.81902C11.6927 6.53677 11.4632 6.3073 11.181 6.16349C10.8601 6 10.4401 6 9.6 6H3.9C3.05992 6 2.63988 6 2.31902 6.16349C2.03677 6.3073 1.8073 6.53677 1.66349 6.81902C1.5 7.13988 1.5 7.55992 1.5 8.4V14.1C1.5 14.9401 1.5 15.3602 1.66349 15.681C1.8073 15.9632 2.03677 16.1927 2.31902 16.3365C2.63988 16.5 3.05992 16.5 3.9 16.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1705_14554">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  copy: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1705_14558)">
    <path
      d="M6 6V3.9C6 3.05992 6 2.63988 6.16349 2.31902C6.3073 2.03677 6.53677 1.8073 6.81902 1.66349C7.13988 1.5 7.55992 1.5 8.4 1.5H14.1C14.9401 1.5 15.3602 1.5 15.681 1.66349C15.9632 1.8073 16.1927 2.03677 16.3365 2.31902C16.5 2.63988 16.5 3.05992 16.5 3.9V9.6C16.5 10.4401 16.5 10.8601 16.3365 11.181C16.1927 11.4632 15.9632 11.6927 15.681 11.8365C15.3602 12 14.9401 12 14.1 12H12M3.9 16.5H9.6C10.4401 16.5 10.8601 16.5 11.181 16.3365C11.4632 16.1927 11.6927 15.9632 11.8365 15.681C12 15.3602 12 14.9401 12 14.1V8.4C12 7.55992 12 7.13988 11.8365 6.81902C11.6927 6.53677 11.4632 6.3073 11.181 6.16349C10.8601 6 10.4401 6 9.6 6H3.9C3.05992 6 2.63988 6 2.31902 6.16349C2.03677 6.3073 1.8073 6.53677 1.66349 6.81902C1.5 7.13988 1.5 7.55992 1.5 8.4V14.1C1.5 14.9401 1.5 15.3602 1.66349 15.681C1.8073 15.9632 2.03677 16.1927 2.31902 16.3365C2.63988 16.5 3.05992 16.5 3.9 16.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1705_14558">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  cornerDownRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 3V4.05C3 6.57023 3 7.83037 3.49047 8.79292C3.9219 9.63967 4.61031 10.3281 5.45705 10.7595C6.41965 11.25 7.67978 11.25 10.2 11.25H15M15 11.25L11.25 7.5M15 11.25L11.25 15"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  creditCard: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M16.5 7.5H1.5M1.5 6.15V11.85C1.5 12.6901 1.5 13.1102 1.66349 13.431C1.8073 13.7132 2.03677 13.9427 2.31901 14.0865C2.63988 14.25 3.05992 14.25 3.9 14.25H14.1C14.9401 14.25 15.3601 14.25 15.681 14.0865C15.9632 13.9427 16.1927 13.7132 16.3365 13.431C16.5 13.1102 16.5 12.6901 16.5 11.85V6.15C16.5 5.30993 16.5 4.88988 16.3365 4.56902C16.1927 4.28678 15.9632 4.0573 15.681 3.91349C15.3601 3.75 14.9401 3.75 14.1 3.75H3.9C3.05992 3.75 2.63988 3.75 2.31901 3.91349C2.03677 4.0573 1.8073 4.28677 1.66349 4.56902C1.5 4.88988 1.5 5.30992 1.5 6.15Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  cube: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.375 5.45837L9 9.00008M9 9.00008L2.62498 5.45837M9 9.00008V16.1251M15.75 12.0439V5.95615C15.75 5.69917 15.75 5.57068 15.7121 5.45608C15.6787 5.35469 15.6238 5.26163 15.5515 5.18312C15.4697 5.09436 15.3575 5.03196 15.1328 4.90716L9.58275 1.82383C9.37005 1.70566 9.2637 1.64657 9.15112 1.62341C9.05137 1.60291 8.94863 1.60291 8.84895 1.62341C8.7363 1.64657 8.62995 1.70566 8.41725 1.82383L2.86723 4.90716C2.64259 5.03196 2.53027 5.09436 2.44847 5.18312C2.37612 5.26163 2.32136 5.35469 2.28786 5.45608C2.25 5.57068 2.25 5.69917 2.25 5.95615V12.0439C2.25 12.301 2.25 12.4295 2.28786 12.5441C2.32136 12.6455 2.37612 12.7385 2.44847 12.817C2.53027 12.9058 2.64259 12.9682 2.86723 13.093L8.41725 16.1763C8.62995 16.2945 8.7363 16.3535 8.84895 16.3767C8.94863 16.3972 9.05137 16.3972 9.15112 16.3767C9.2637 16.3535 9.37005 16.2945 9.58275 16.1763L15.1328 13.093C15.3575 12.9682 15.4697 12.9058 15.5515 12.817C15.6238 12.7385 15.6787 12.6455 15.7121 12.5441C15.75 12.4295 15.75 12.301 15.75 12.0439Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  cursorAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.3791 8.08155C15.8418 7.90162 16.0732 7.81162 16.1381 7.68442C16.1944 7.57425 16.1927 7.44334 16.1336 7.33465C16.0653 7.20919 15.8317 7.12533 15.3644 6.9576L3.44716 2.6796C3.06489 2.54237 2.87375 2.47376 2.74879 2.51704C2.64016 2.55466 2.55478 2.64003 2.51716 2.74867C2.47388 2.87362 2.5425 3.06476 2.67972 3.44704L6.95769 15.3643C7.12542 15.8316 7.20928 16.0652 7.33474 16.1335C7.44343 16.1926 7.57426 16.1943 7.68451 16.138C7.81171 16.0731 7.90164 15.8417 8.08164 15.379L10.0292 10.3708C10.0645 10.2802 10.0821 10.2349 10.1093 10.1968C10.1335 10.1629 10.163 10.1334 10.1969 10.1092C10.235 10.082 10.2803 10.0644 10.3709 10.0291L15.3791 8.08155Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  cursorBox: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 7.125V5.85C15.75 4.58988 15.75 3.95982 15.5048 3.47852C15.2891 3.05516 14.9449 2.71095 14.5215 2.49524C14.0401 2.25 13.4102 2.25 12.15 2.25H5.85C4.58988 2.25 3.95982 2.25 3.47852 2.49524C3.05516 2.71095 2.71095 3.05516 2.49524 3.47852C2.25 3.95982 2.25 4.58988 2.25 5.85V12.15C2.25 13.4102 2.25 14.0401 2.49524 14.5215C2.71095 14.9449 3.05516 15.2891 3.47852 15.5048C3.95982 15.75 4.58988 15.75 5.85 15.75H7.125M13.0396 13.2835L11.7659 15.649C11.5577 16.0356 11.4536 16.229 11.3267 16.2794C11.2166 16.3232 11.0922 16.3123 10.9913 16.2501C10.8751 16.1784 10.8061 15.97 10.6681 15.5531L8.6253 9.38348C8.5044 9.01838 8.44395 8.8359 8.48745 8.71432C8.52525 8.6085 8.6085 8.52525 8.71432 8.48745C8.8359 8.44395 9.01838 8.5044 9.38348 8.6253L15.5531 10.6681C15.97 10.8062 16.1784 10.8751 16.2501 10.9913C16.3123 11.0923 16.3231 11.2166 16.2793 11.3268C16.2289 11.4536 16.0356 11.5577 15.6489 11.7659L13.2835 13.0396C13.2246 13.0714 13.1951 13.0873 13.1693 13.1076C13.1464 13.1258 13.1258 13.1464 13.1076 13.1693C13.0873 13.1951 13.0714 13.2246 13.0396 13.2835Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  cursor: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9.74992 9.74992L14.2499 14.2499M13.473 8.0634L9.71497 9.33982C9.61222 9.3747 9.56085 9.39217 9.5181 9.4215C9.4803 9.44752 9.44752 9.4803 9.4215 9.5181C9.39217 9.56085 9.3747 9.61222 9.33982 9.71497L8.0634 13.473C7.90515 13.939 7.82595 14.172 7.7022 14.2425C7.59502 14.3035 7.46461 14.3079 7.35351 14.2542C7.2253 14.1922 7.13067 13.9651 6.94141 13.5108L2.81024 3.59484C2.63462 3.17332 2.54682 2.96255 2.58954 2.83069C2.6266 2.71629 2.71629 2.6266 2.83069 2.58954C2.96255 2.54682 3.17332 2.63462 3.59484 2.81024L13.5108 6.94141C13.9651 7.13067 14.1922 7.2253 14.2542 7.35351C14.3079 7.46461 14.3035 7.59502 14.2425 7.7022C14.172 7.82595 13.939 7.90515 13.473 8.0634Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  dashboard: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9.75 6.75V2.25H15.75V6.75H9.75ZM2.25 9.75V2.25H8.25V9.75H2.25ZM9.75 15.75V8.25H15.75V15.75H9.75ZM2.25 15.75V11.25H8.25V15.75H2.25ZM3.75 8.25H6.75V3.75H3.75V8.25ZM11.25 14.25H14.25V9.75H11.25V14.25ZM11.25 5.25H14.25V3.75H11.25V5.25ZM3.75 14.25H6.75V12.75H3.75V14.25Z"
    fill="currentColor"
  />
</svg>`,
  databaseUpload: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 6.76875C10.1125 6.76875 11.2312 6.60312 12.3562 6.27187C13.4812 5.94062 14.1125 5.60625 14.25 5.26875C14.1125 4.90625 13.4844 4.5625 12.3656 4.2375C11.2469 3.9125 10.125 3.75 9 3.75C7.8625 3.75 6.74687 3.90937 5.65312 4.22812C4.55937 4.54687 3.925 4.89375 3.75 5.26875C3.925 5.60625 4.55937 5.94062 5.65312 6.27187C6.74687 6.60312 7.8625 6.76875 9 6.76875ZM13.125 15.75H13.875V12.675L15.225 14.025L15.75 13.5L13.5 11.25L11.25 13.5L11.775 14.025L13.125 12.675V15.75ZM13.5 17.25C12.4625 17.25 11.5781 16.8844 10.8469 16.1531C10.1156 15.4219 9.75 14.5375 9.75 13.5C9.75 12.4625 10.1156 11.5781 10.8469 10.8469C11.5781 10.1156 12.4625 9.75 13.5 9.75C14.5375 9.75 15.4219 10.1156 16.1531 10.8469C16.8844 11.5781 17.25 12.4625 17.25 13.5C17.25 14.5375 16.8844 15.4219 16.1531 16.1531C15.4219 16.8844 14.5375 17.25 13.5 17.25ZM8.30625 14.2312C8.34375 14.5062 8.4 14.7687 8.475 15.0187C8.55 15.2687 8.64375 15.5125 8.75625 15.75C7.84375 15.7375 6.99375 15.65 6.20625 15.4875C5.41875 15.325 4.73125 15.1094 4.14375 14.8406C3.55625 14.5719 3.09375 14.2594 2.75625 13.9031C2.41875 13.5469 2.25 13.1625 2.25 12.75V5.25C2.25 4.425 2.90937 3.71875 4.22812 3.13125C5.54687 2.54375 7.1375 2.25 9 2.25C10.8625 2.25 12.4531 2.54375 13.7719 3.13125C15.0906 3.71875 15.75 4.425 15.75 5.25V8.75625C15.5125 8.64375 15.2687 8.55 15.0187 8.475C14.7687 8.4 14.5125 8.34375 14.25 8.30625V7.14375C13.6 7.50625 12.825 7.78125 11.925 7.96875C11.025 8.15625 10.05 8.25 9 8.25C7.9375 8.25 6.95625 8.15625 6.05625 7.96875C5.15625 7.78125 4.3875 7.50625 3.75 7.14375V9.0375C4.3875 9.625 5.20312 10.0156 6.19687 10.2094C7.19062 10.4031 8.125 10.5 9 10.5H9.20625C9.04375 10.725 8.90312 10.9625 8.78437 11.2125C8.66562 11.4625 8.5625 11.725 8.475 12C7.525 11.95 6.64375 11.8344 5.83125 11.6531C5.01875 11.4719 4.325 11.2187 3.75 10.8937V12.75C3.8375 12.9125 4.025 13.0781 4.3125 13.2469C4.6 13.4156 4.95 13.5656 5.3625 13.6969C5.775 13.8281 6.23437 13.9406 6.74062 14.0344C7.24687 14.1281 7.76875 14.1937 8.30625 14.2312Z"
    fill="currentColor"
  />
</svg>`,
  database: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 15.75C7.1125 15.75 5.51562 15.4594 4.20938 14.8781C2.90313 14.2969 2.25 13.5875 2.25 12.75V5.25C2.25 4.425 2.90937 3.71875 4.22813 3.13125C5.54688 2.54375 7.1375 2.25 9 2.25C10.8625 2.25 12.4531 2.54375 13.7719 3.13125C15.0906 3.71875 15.75 4.425 15.75 5.25V12.75C15.75 13.5875 15.0969 14.2969 13.7906 14.8781C12.4844 15.4594 10.8875 15.75 9 15.75ZM9 6.76875C10.1125 6.76875 11.2313 6.60938 12.3563 6.29063C13.4813 5.97188 14.1125 5.63125 14.25 5.26875C14.1125 4.90625 13.4844 4.5625 12.3656 4.2375C11.2469 3.9125 10.125 3.75 9 3.75C7.8625 3.75 6.74688 3.90938 5.65313 4.22813C4.55938 4.54688 3.925 4.89375 3.75 5.26875C3.925 5.64375 4.55938 5.9875 5.65313 6.3C6.74688 6.6125 7.8625 6.76875 9 6.76875ZM9 10.5C9.525 10.5 10.0313 10.475 10.5188 10.425C11.0063 10.375 11.4719 10.3031 11.9156 10.2094C12.3594 10.1156 12.7781 10 13.1719 9.8625C13.5656 9.725 13.925 9.56875 14.25 9.39375V7.14375C13.925 7.31875 13.5656 7.475 13.1719 7.6125C12.7781 7.75 12.3594 7.86563 11.9156 7.95938C11.4719 8.05313 11.0063 8.125 10.5188 8.175C10.0313 8.225 9.525 8.25 9 8.25C8.475 8.25 7.9625 8.225 7.4625 8.175C6.9625 8.125 6.49063 8.05313 6.04688 7.95938C5.60313 7.86563 5.1875 7.75 4.8 7.6125C4.4125 7.475 4.0625 7.31875 3.75 7.14375V9.39375C4.0625 9.56875 4.4125 9.725 4.8 9.8625C5.1875 10 5.60313 10.1156 6.04688 10.2094C6.49063 10.3031 6.9625 10.375 7.4625 10.425C7.9625 10.475 8.475 10.5 9 10.5ZM9 14.25C9.575 14.25 10.1594 14.2063 10.7531 14.1188C11.3469 14.0312 11.8938 13.9156 12.3938 13.7719C12.8938 13.6281 13.3125 13.4656 13.65 13.2844C13.9875 13.1031 14.1875 12.9188 14.25 12.7313V10.8938C13.925 11.0688 13.5656 11.225 13.1719 11.3625C12.7781 11.5 12.3594 11.6156 11.9156 11.7094C11.4719 11.8031 11.0063 11.875 10.5188 11.925C10.0313 11.975 9.525 12 9 12C8.475 12 7.9625 11.975 7.4625 11.925C6.9625 11.875 6.49063 11.8031 6.04688 11.7094C5.60313 11.6156 5.1875 11.5 4.8 11.3625C4.4125 11.225 4.0625 11.0688 3.75 10.8938V12.75C3.8125 12.9375 4.00938 13.1188 4.34063 13.2938C4.67188 13.4688 5.0875 13.6281 5.5875 13.7719C6.0875 13.9156 6.6375 14.0312 7.2375 14.1188C7.8375 14.2063 8.425 14.25 9 14.25Z"
    fill="currentColor"
  />
</svg>`,
  distributeSpaceHorizontal: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 15.75V2.25M2.25 15.75V2.25M6.75 6V12C6.75 12.6989 6.75 13.0483 6.86418 13.324C7.01642 13.6915 7.30844 13.9836 7.67595 14.1358C7.95165 14.25 8.30107 14.25 9 14.25C9.69893 14.25 10.0483 14.25 10.324 14.1358C10.6915 13.9836 10.9836 13.6915 11.1359 13.324C11.25 13.0483 11.25 12.6989 11.25 12V6C11.25 5.30109 11.25 4.95164 11.1359 4.67597C10.9836 4.30844 10.6915 4.01642 10.324 3.86418C10.0483 3.75 9.69893 3.75 9 3.75C8.30107 3.75 7.95165 3.75 7.67595 3.86418C7.30844 4.01642 7.01642 4.30844 6.86418 4.67597C6.75 4.95164 6.75 5.30109 6.75 6Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  distributeSpaceVertical: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 2.25H2.25M15.75 15.75H2.25M3.75 9C3.75 8.30107 3.75 7.95165 3.86418 7.67595C4.01642 7.30844 4.30844 7.01642 4.67597 6.86418C4.95164 6.75 5.30109 6.75 6 6.75H12C12.6989 6.75 13.0483 6.75 13.324 6.86418C13.6915 7.01642 13.9836 7.30844 14.1358 7.67595C14.25 7.95165 14.25 8.30107 14.25 9C14.25 9.69893 14.25 10.0483 14.1358 10.324C13.9836 10.6915 13.6915 10.9836 13.324 11.1359C13.0483 11.25 12.6989 11.25 12 11.25H6C5.30109 11.25 4.95164 11.25 4.67597 11.1359C4.30844 10.9836 4.01642 10.6915 3.86418 10.324C3.75 10.0483 3.75 9.69893 3.75 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  dotpoints: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.75 3.75H7.5M15.75 14.25H7.5M15.75 9H7.5M4.5 3.75C4.5 4.37132 3.99632 4.875 3.375 4.875C2.75368 4.875 2.25 4.37132 2.25 3.75C2.25 3.12868 2.75368 2.625 3.375 2.625C3.99632 2.625 4.5 3.12868 4.5 3.75ZM4.5 14.25C4.5 14.8713 3.99632 15.375 3.375 15.375C2.75368 15.375 2.25 14.8713 2.25 14.25C2.25 13.6287 2.75368 13.125 3.375 13.125C3.99632 13.125 4.5 13.6287 4.5 14.25ZM4.5 9C4.5 9.6213 3.99632 10.125 3.375 10.125C2.75368 10.125 2.25 9.6213 2.25 9C2.25 8.3787 2.75368 7.875 3.375 7.875C3.99632 7.875 4.5 8.3787 4.5 9Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>

  `,
  dots: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 9.75C9.41422 9.75 9.75 9.41422 9.75 9C9.75 8.58577 9.41422 8.25 9 8.25C8.58577 8.25 8.25 8.58577 8.25 9C8.25 9.41422 8.58577 9.75 9 9.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9 4.5C9.41422 4.5 9.75 4.16421 9.75 3.75C9.75 3.33579 9.41422 3 9 3C8.58577 3 8.25 3.33579 8.25 3.75C8.25 4.16421 8.58577 4.5 9 4.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9 15C9.41422 15 9.75 14.6642 9.75 14.25C9.75 13.8358 9.41422 13.5 9 13.5C8.58577 13.5 8.25 13.8358 8.25 14.25C8.25 14.6642 8.58577 15 9 15Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  download: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 15.75H15.75M9 2.25V12.75M9 12.75L14.25 7.5M9 12.75L3.75 7.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  dragHandle: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 6.375H15.75M2.25 11.625H15.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  dragIndicator: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.375 4.5C6.78922 4.5 7.125 4.16421 7.125 3.75C7.125 3.33579 6.78922 3 6.375 3C5.96077 3 5.625 3.33579 5.625 3.75C5.625 4.16421 5.96077 4.5 6.375 4.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M6.375 9.75C6.78922 9.75 7.125 9.41422 7.125 9C7.125 8.58577 6.78922 8.25 6.375 8.25C5.96077 8.25 5.625 8.58577 5.625 9C5.625 9.41422 5.96077 9.75 6.375 9.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M6.375 15C6.78922 15 7.125 14.6642 7.125 14.25C7.125 13.8358 6.78922 13.5 6.375 13.5C5.96077 13.5 5.625 13.8358 5.625 14.25C5.625 14.6642 5.96077 15 6.375 15Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M11.625 4.5C12.0392 4.5 12.375 4.16421 12.375 3.75C12.375 3.33579 12.0392 3 11.625 3C11.2108 3 10.875 3.33579 10.875 3.75C10.875 4.16421 11.2108 4.5 11.625 4.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M11.625 9.75C12.0392 9.75 12.375 9.41422 12.375 9C12.375 8.58577 12.0392 8.25 11.625 8.25C11.2108 8.25 10.875 8.58577 10.875 9C10.875 9.41422 11.2108 9.75 11.625 9.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M11.625 15C12.0392 15 12.375 14.6642 12.375 14.25C12.375 13.8358 12.0392 13.5 11.625 13.5C11.2108 13.5 10.875 13.8358 10.875 14.25C10.875 14.6642 11.2108 15 11.625 15Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  dragPan: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 16.5L5.8125 13.3125L6.88125 12.2438L8.25 13.6125V9.75H4.40625L5.775 11.1L4.6875 12.1875L1.5 9L4.66875 5.83125L5.7375 6.9L4.3875 8.25H8.25V4.3875L6.88125 5.75625L5.8125 4.6875L9 1.5L12.1875 4.6875L11.1188 5.75625L9.75 4.3875V8.25H13.5938L12.225 6.9L13.3125 5.8125L16.5 9L13.3125 12.1875L12.2438 11.1188L13.6125 9.75H9.75V13.5938L11.1 12.225L12.1875 13.3125L9 16.5Z"
    fill="currentColor"
  />
</svg>`,
  editAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.25 2.99999H5.1C3.83988 2.99999 3.20982 2.99999 2.72852 3.24522C2.30516 3.46094 1.96095 3.80515 1.74524 4.22851C1.5 4.70981 1.5 5.33987 1.5 6.59999V12.9C1.5 14.1601 1.5 14.7901 1.74524 15.2715C1.96095 15.6948 2.30516 16.0391 2.72852 16.2548C3.20982 16.5 3.83988 16.5 5.1 16.5H11.4C12.6601 16.5 13.2901 16.5 13.7715 16.2548C14.1949 16.0391 14.5391 15.6948 14.7548 15.2715C15 14.7901 15 14.1601 15 12.9V9.75M5.99998 12H7.25589C7.62277 12 7.80623 12 7.97888 11.9585C8.13188 11.9218 8.2782 11.8612 8.41245 11.779C8.5638 11.6862 8.69355 11.5565 8.95297 11.297L16.125 4.12499C16.7463 3.50367 16.7463 2.49631 16.125 1.87499C15.5037 1.25367 14.4963 1.25366 13.875 1.87499L6.70292 9.04703C6.4435 9.30645 6.31379 9.4362 6.22102 9.58755C6.13878 9.7218 6.07817 9.86805 6.04142 10.0211C5.99998 10.1938 5.99998 10.3772 5.99998 10.7441V12Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  edit: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 7.49998L10.5 4.49998M1.875 16.125L4.41328 15.843C4.72339 15.8085 4.87845 15.7912 5.02339 15.7444C5.15197 15.7027 5.27434 15.6439 5.38717 15.5695C5.51434 15.4856 5.62466 15.3754 5.8453 15.1547L15.75 5.24998C16.5785 4.42156 16.5785 3.07841 15.75 2.24998C14.9216 1.42156 13.5785 1.42156 12.75 2.24998L2.8453 12.1547C2.62466 12.3754 2.51434 12.4856 2.43048 12.6128C2.35607 12.7257 2.29726 12.848 2.25563 12.9766C2.20872 13.1215 2.19148 13.2766 2.15703 13.5867L1.875 16.125Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  expandAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12 6L15.75 2.25M15.75 2.25H12M15.75 2.25V6M6 6L2.25 2.25M2.25 2.25V6M2.25 2.25H6M6 12L2.25 15.75M2.25 15.75H6M2.25 15.75V12M12 12L15.75 15.75M15.75 15.75V12M15.75 15.75H12"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  expand: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 10.5V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H10.5M7.5 2.25H5.85C4.58988 2.25 3.95982 2.25 3.47852 2.49524C3.05516 2.71095 2.71095 3.05516 2.49524 3.47852C2.25 3.95982 2.25 4.58988 2.25 5.85V7.5M11.25 6.75L15.75 2.25M15.75 2.25H11.25M15.75 2.25V6.75M6.75 11.25L2.25 15.75M2.25 15.75H6.75M2.25 15.75V11.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  eyeOff: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.05717 3.81924C8.36205 3.77417 8.67645 3.75 9.0003 3.75C12.829 3.75 15.3415 7.12863 16.1855 8.4651C16.2877 8.62688 16.3387 8.70773 16.3673 8.83253C16.3888 8.9262 16.3888 9.07403 16.3673 9.1677C16.3387 9.29243 16.2873 9.37388 16.1844 9.5367C15.9595 9.89258 15.6166 10.3928 15.1624 10.9354M5.04324 5.03628C3.42169 6.13628 2.32084 7.66455 1.81583 8.46398C1.71321 8.62643 1.6619 8.70765 1.6333 8.83237C1.61182 8.92605 1.61182 9.0738 1.63328 9.16755C1.66187 9.29228 1.71295 9.37312 1.8151 9.5349C2.65915 10.8714 5.17156 14.25 9.0003 14.25C10.5441 14.25 11.8739 13.7007 12.9666 12.9574M2.25031 2.25L15.7503 15.75M7.40932 7.40901C7.00215 7.8162 6.75031 8.3787 6.75031 9C6.75031 10.2427 7.7577 11.25 9.0003 11.25C9.6216 11.25 10.1841 10.9981 10.5913 10.591"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  eye: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M1.81509 9.5349C1.71296 9.37312 1.66188 9.29228 1.63329 9.16755C1.61182 9.07388 1.61182 8.92612 1.63329 8.83245C1.66188 8.70772 1.71296 8.62688 1.81509 8.4651C2.65915 7.12863 5.17155 3.75 9.0003 3.75C12.8291 3.75 15.3415 7.12863 16.1855 8.4651C16.2877 8.62688 16.3388 8.70772 16.3673 8.83245C16.3888 8.92612 16.3888 9.07388 16.3673 9.16755C16.3388 9.29228 16.2877 9.37312 16.1855 9.5349C15.3415 10.8714 12.8291 14.25 9.0003 14.25C5.17155 14.25 2.65915 10.8714 1.81509 9.5349Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9.00024 11.25C10.2429 11.25 11.2502 10.2427 11.2502 9C11.2502 7.75732 10.2429 6.75 9.00024 6.75C7.75757 6.75 6.75024 7.75732 6.75024 9C6.75024 10.2427 7.75757 11.25 9.00024 11.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  faceSmile: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_881_4225)">
    <path
      d="M6 10.5C6 10.5 7.125 12 9 12C10.875 12 12 10.5 12 10.5M11.25 6.75H11.2575M6.75 6.75H6.7575M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9ZM11.625 6.75C11.625 6.95711 11.4571 7.125 11.25 7.125C11.0429 7.125 10.875 6.95711 10.875 6.75C10.875 6.54289 11.0429 6.375 11.25 6.375C11.4571 6.375 11.625 6.54289 11.625 6.75ZM7.125 6.75C7.125 6.95711 6.95711 7.125 6.75 7.125C6.54289 7.125 6.375 6.95711 6.375 6.75C6.375 6.54289 6.54289 6.375 6.75 6.375C6.95711 6.375 7.125 6.54289 7.125 6.75Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_881_4225">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  fileCodeAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M10.5 1.70215V4.80005C10.5 5.22009 10.5 5.43011 10.5818 5.59055C10.6537 5.73167 10.7683 5.8464 10.9095 5.91831C11.0699 6.00005 11.2799 6.00005 11.7 6.00005H14.7979M10.5 13.125L12.375 11.25L10.5 9.375M7.5 9.375L5.625 11.25L7.5 13.125M15 7.49117V12.9C15 14.1602 15 14.7901 14.7548 15.2715C14.5391 15.6949 14.1949 16.0391 13.7715 16.2548C13.2901 16.5 12.6601 16.5 11.4 16.5H6.6C5.33988 16.5 4.70982 16.5 4.22852 16.2548C3.80516 16.0391 3.46095 15.6949 3.24524 15.2715C3 14.7901 3 14.1602 3 12.9V5.1C3 3.83988 3 3.20982 3.24524 2.72852C3.46095 2.30516 3.80516 1.96095 4.22852 1.74524C4.70982 1.5 5.33988 1.5 6.6 1.5H9.00885C9.55912 1.5 9.8343 1.5 10.0933 1.56217C10.3228 1.61729 10.5423 1.70819 10.7437 1.83156C10.9707 1.9707 11.1653 2.16527 11.5544 2.55442L13.9456 4.94558C14.3348 5.33473 14.5293 5.5293 14.6684 5.75636C14.7918 5.95767 14.8827 6.17715 14.9378 6.40673C15 6.66568 15 6.94084 15 7.49117Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  fileCode: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3.75 13.875C3.75 14.2233 3.75 14.3974 3.76925 14.5437C3.90218 15.5533 4.69666 16.3478 5.70631 16.4807C5.85253 16.5 6.02669 16.5 6.375 16.5H12.15C13.4102 16.5 14.0401 16.5 14.5215 16.2548C14.9449 16.0391 15.2891 15.6949 15.5048 15.2715C15.75 14.7901 15.75 14.1602 15.75 12.9V7.49117C15.75 6.94084 15.75 6.66568 15.6878 6.40673C15.6327 6.17715 15.5418 5.95767 15.4184 5.75636C15.2793 5.5293 15.0848 5.33472 14.6956 4.94558L12.3044 2.55442C11.9152 2.16527 11.7207 1.9707 11.4937 1.83156C11.2923 1.70819 11.0728 1.61729 10.8433 1.56217C10.5843 1.5 10.3091 1.5 9.75885 1.5H6.375C6.02669 1.5 5.85253 1.5 5.70631 1.51925C4.69666 1.65218 3.90218 2.44666 3.76925 3.45631C3.75 3.60253 3.75 3.77669 3.75 4.125M6.75 10.875L8.625 9L6.75 7.125M3.75 7.125L1.875 9L3.75 10.875"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  file: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M10.5 1.70209V4.8C10.5 5.22004 10.5 5.43006 10.5818 5.59049C10.6537 5.73161 10.7683 5.84635 10.9095 5.91826C11.0699 6 11.2799 6 11.7 6H14.7979M15 7.49117V12.9C15 14.1602 15 14.7901 14.7548 15.2715C14.5391 15.6949 14.1949 16.0391 13.7715 16.2548C13.2901 16.5 12.6601 16.5 11.4 16.5H6.6C5.33988 16.5 4.70982 16.5 4.22852 16.2548C3.80516 16.0391 3.46095 15.6949 3.24524 15.2715C3 14.7901 3 14.1602 3 12.9V5.1C3 3.83988 3 3.20982 3.24524 2.72852C3.46095 2.30516 3.80516 1.96095 4.22852 1.74524C4.70982 1.5 5.33988 1.5 6.6 1.5H9.00885C9.55912 1.5 9.8343 1.5 10.0933 1.56217C10.3228 1.61729 10.5423 1.70819 10.7437 1.83156C10.9707 1.9707 11.1653 2.16527 11.5544 2.55442L13.9456 4.94558C14.3348 5.33473 14.5293 5.5293 14.6684 5.75636C14.7918 5.95767 14.8827 6.17715 14.9378 6.40673C15 6.66568 15 6.94084 15 7.49117Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  filterFunnel: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.5 3.45C1.5 3.02996 1.5 2.81994 1.58174 2.65951C1.65365 2.51839 1.76839 2.40365 1.90951 2.33174C2.06994 2.25 2.27996 2.25 2.7 2.25H15.3C15.7201 2.25 15.9301 2.25 16.0905 2.33174C16.2317 2.40365 16.3463 2.51839 16.4183 2.65951C16.5 2.81994 16.5 3.02996 16.5 3.45V3.95204C16.5 4.15364 16.5 4.25444 16.4754 4.34817C16.4535 4.43123 16.4176 4.50992 16.3691 4.58082C16.3145 4.66082 16.2383 4.72684 16.0859 4.85887L11.2891 9.01612C11.1368 9.14812 11.0606 9.2142 11.0059 9.29415C10.9574 9.3651 10.9215 9.44378 10.8996 9.5268C10.875 9.62055 10.875 9.72135 10.875 9.92295V13.8438C10.875 13.9904 10.875 14.0638 10.8514 14.1272C10.8305 14.1832 10.7965 14.2334 10.7522 14.2736C10.7021 14.3191 10.634 14.3464 10.4978 14.4009L7.94783 15.4209C7.6722 15.5311 7.53435 15.5863 7.4237 15.5632C7.32695 15.5431 7.24204 15.4857 7.18744 15.4033C7.125 15.3092 7.125 15.1606 7.125 14.8638V9.92295C7.125 9.72135 7.125 9.62055 7.10036 9.5268C7.07854 9.44378 7.04261 9.3651 6.99413 9.29415C6.93944 9.2142 6.86327 9.14812 6.71092 9.01612L1.91408 4.85887C1.76173 4.72684 1.68556 4.66082 1.63087 4.58082C1.58239 4.50992 1.54646 4.43123 1.52464 4.34817C1.5 4.25444 1.5 4.15364 1.5 3.95204V3.45Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  flexAlignBottom: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.125 13.2H4.875M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  flexAlignLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.875 13.125V4.875M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  flexAlignRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.125 13.125V4.875M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  flexAlignTop: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.125 4.875H4.875M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  flipBack: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 6.75H12.375C14.239 6.75 15.75 8.26103 15.75 10.125C15.75 11.989 14.239 13.5 12.375 13.5H9M2.25 6.75L5.25 3.75M2.25 6.75L5.25 9.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  flipForward: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 6.75H5.625C3.76104 6.75 2.25 8.26103 2.25 10.125C2.25 11.989 3.76104 13.5 5.625 13.5H9M15.75 6.75L12.75 3.75M15.75 6.75L12.75 9.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  flow: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M16.4251 9.33334C13.4602 11.5926 8.46833 9.90501 6.6915 7.57429C4.00813 4.06026 -1.08616 8.24395 2.18637 11.7714C6.41908 16.187 13.9558 14.6823 16.4251 9.33334Z"
    fill="#00B4F0"
  />
  <path
    d="M2.18311 11.7758C6.42015 16.1869 13.9613 14.6823 16.4258 9.33772C18.8593 3.93075 10.6841 1.1179 9.10789 6.62782C8.89082 7.42258 8.53408 8.17233 8.05438 8.84216C6.75062 10.6593 4.60745 11.7758 2.18311 11.7758Z"
    fill="#FF707A"
  />
  <path
    d="M16.4258 9.33333C14.0417 11.1551 10.3358 10.4139 8.05438 8.83777C6.75062 10.6595 4.60745 11.7758 2.18311 11.7711C3.90191 13.5616 6.17023 14.3786 8.42046 14.3565C11.7067 14.3296 14.9614 12.5125 16.4258 9.33333Z"
    fill="#5748FF"
  />
</svg>`,
  github: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 0C13.9725 0 18 4.0275 18 9C17.9995 10.8857 17.4077 12.7238 16.3078 14.2556C15.2079 15.7873 13.6554 16.9356 11.8688 17.5387C11.4188 17.6287 11.25 17.3475 11.25 17.1112C11.25 16.8075 11.2613 15.84 11.2613 14.6363C11.2613 13.7925 10.98 13.2525 10.6538 12.9712C12.6563 12.7463 14.76 11.9812 14.76 8.5275C14.76 7.5375 14.4113 6.73875 13.8375 6.10875C13.9275 5.88375 14.2425 4.96125 13.7475 3.72375C13.7475 3.72375 12.9938 3.47625 11.2725 4.64625C10.5525 4.44375 9.7875 4.3425 9.0225 4.3425C8.2575 4.3425 7.4925 4.44375 6.7725 4.64625C5.05125 3.4875 4.2975 3.72375 4.2975 3.72375C3.8025 4.96125 4.1175 5.88375 4.2075 6.10875C3.63375 6.73875 3.285 7.54875 3.285 8.5275C3.285 11.97 5.3775 12.7463 7.38 12.9712C7.12125 13.1962 6.885 13.59 6.80625 14.175C6.28875 14.4113 4.995 14.7937 4.185 13.4325C4.01625 13.1625 3.51 12.4987 2.80125 12.51C2.0475 12.5212 2.4975 12.9375 2.8125 13.1062C3.195 13.32 3.63375 14.1187 3.735 14.3775C3.915 14.8837 4.5 15.8513 6.76125 15.435C6.76125 16.1888 6.7725 16.8975 6.7725 17.1112C6.7725 17.3475 6.60375 17.6175 6.15375 17.5387C4.36122 16.9421 2.80208 15.7961 1.6975 14.2635C0.592928 12.7308 -0.000990539 10.8892 1.2401e-06 9C1.2401e-06 4.0275 4.0275 0 9 0Z"
    fill="currentColor"
  />
</svg>`,
  globe: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1795_16049)">
    <path
      d="M9 1.5C10.876 3.55376 11.9421 6.21902 12 9C11.9421 11.781 10.876 14.4462 9 16.5M9 1.5C7.12404 3.55376 6.05794 6.21902 6 9C6.05794 11.781 7.12404 14.4462 9 16.5M9 1.5C4.85786 1.5 1.5 4.85786 1.5 9C1.5 13.1421 4.85786 16.5 9 16.5M9 1.5C13.1421 1.5 16.5 4.85786 16.5 9C16.5 13.1421 13.1421 16.5 9 16.5M1.87501 6.75H16.125M1.875 11.25H16.125"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1795_16049">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  gridAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 9H15.75M9 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsBlank: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 2.25H2.2575M2.25 9H2.2575M2.25 15.75H2.2575M2.25 12.375H2.2575M2.25 5.625H2.2575M5.625 2.25H5.6325M5.625 9H5.6325M5.625 15.75H5.6325M12.375 2.25H12.3825M12.375 9H12.3825M12.375 15.75H12.3825M9 2.25H9.0075M9 9H9.0075M9 15.75H9.0075M9 12.375H9.0075M9 5.625H9.0075M15.75 2.25H15.7575M15.75 9H15.7575M15.75 15.75H15.7575M15.75 12.375H15.7575M15.75 5.625H15.7575"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsBottom: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 2.25H2.2575M2.25 9H2.2575M2.25 12.375H2.2575M2.25 5.625H2.2575M5.625 2.25H5.6325M5.625 9H5.6325M12.375 2.25H12.3825M12.375 9H12.3825M9 2.25H9.0075M9 9H9.0075M9 12.375H9.0075M9 5.625H9.0075M15.75 2.25H15.7575M15.75 9H15.7575M15.75 12.375H15.7575M15.75 5.625H15.7575M15.75 15.75H2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsHorizontal: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 2.25H2.2575M2.25 9H2.2575M2.25 15.75H2.2575M2.25 12.375H2.2575M2.25 5.625H2.2575M5.625 2.25H5.6325M5.625 9H5.6325M5.625 15.75H5.6325M12.375 2.25H12.3825M12.375 9H12.3825M12.375 15.75H12.3825M15.75 2.25H15.7575M15.75 9H15.7575M15.75 15.75H15.7575M15.75 12.375H15.7575M15.75 5.625H15.7575M9 15.75V2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.625 2.25H5.6325M5.625 9H5.6325M5.625 15.75H5.6325M12.375 2.25H12.3825M12.375 9H12.3825M12.375 15.75H12.3825M9 2.25H9.0075M9 9H9.0075M9 15.75H9.0075M9 12.375H9.0075M9 5.625H9.0075M15.75 2.25H15.7575M15.75 9H15.7575M15.75 15.75H15.7575M15.75 12.375H15.7575M15.75 5.625H15.7575M2.25 15.75V2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.625 2.25H5.6325M5.625 9H5.6325M5.625 15.75H5.6325M12.375 2.25H12.3825M12.375 9H12.3825M12.375 15.75H12.3825M9 2.25H9.0075M9 9H9.0075M9 15.75H9.0075M9 12.375H9.0075M9 5.625H9.0075M2.25 2.25H2.2575M2.25 9H2.2575M2.25 15.75H2.2575M2.25 12.375H2.2575M2.25 5.625H2.2575M15.75 15.75V2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsTop: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 15.75H2.2575M2.25 9H2.2575M2.25 12.375H2.2575M2.25 5.625H2.2575M5.625 15.75H5.6325M5.625 9H5.6325M12.375 15.75H12.3825M12.375 9H12.3825M9 15.75H9.0075M9 9H9.0075M9 12.375H9.0075M9 5.625H9.0075M15.75 15.75H15.7575M15.75 9H15.7575M15.75 12.375H15.7575M15.75 5.625H15.7575M15.75 2.25H2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  gridDotsVertical: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 2.25H2.2575M2.25 15.75H2.2575M2.25 12.375H2.2575M2.25 5.625H2.2575M5.625 2.25H5.6325M5.625 15.75H5.6325M12.375 2.25H12.3825M12.375 15.75H12.3825M9 2.25H9.0075M9 15.75H9.0075M9 12.375H9.0075M9 5.625H9.0075M15.75 2.25H15.7575M15.75 15.75H15.7575M15.75 12.375H15.7575M15.75 5.625H15.7575M15.75 9H2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  grid: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.3 2.25H3.45C3.02996 2.25 2.81994 2.25 2.65951 2.33174C2.51839 2.40365 2.40365 2.51839 2.33174 2.65951C2.25 2.81994 2.25 3.02996 2.25 3.45V6.3C2.25 6.72004 2.25 6.93006 2.33174 7.09049C2.40365 7.23161 2.51839 7.34635 2.65951 7.41826C2.81994 7.5 3.02996 7.5 3.45 7.5H6.3C6.72004 7.5 6.93006 7.5 7.09049 7.41826C7.23161 7.34635 7.34635 7.23161 7.41826 7.09049C7.5 6.93006 7.5 6.72004 7.5 6.3V3.45C7.5 3.02996 7.5 2.81994 7.41826 2.65951C7.34635 2.51839 7.23161 2.40365 7.09049 2.33174C6.93006 2.25 6.72004 2.25 6.3 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M14.55 2.25H11.7C11.2799 2.25 11.0699 2.25 10.9095 2.33174C10.7683 2.40365 10.6537 2.51839 10.5818 2.65951C10.5 2.81994 10.5 3.02996 10.5 3.45V6.3C10.5 6.72004 10.5 6.93006 10.5818 7.09049C10.6537 7.23161 10.7683 7.34635 10.9095 7.41826C11.0699 7.5 11.2799 7.5 11.7 7.5H14.55C14.9701 7.5 15.1801 7.5 15.3405 7.41826C15.4817 7.34635 15.5963 7.23161 15.6683 7.09049C15.75 6.93006 15.75 6.72004 15.75 6.3V3.45C15.75 3.02996 15.75 2.81994 15.6683 2.65951C15.5963 2.51839 15.4817 2.40365 15.3405 2.33174C15.1801 2.25 14.9701 2.25 14.55 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M14.55 10.5H11.7C11.2799 10.5 11.0699 10.5 10.9095 10.5818C10.7683 10.6537 10.6537 10.7683 10.5818 10.9095C10.5 11.0699 10.5 11.2799 10.5 11.7V14.55C10.5 14.9701 10.5 15.1801 10.5818 15.3405C10.6537 15.4817 10.7683 15.5963 10.9095 15.6683C11.0699 15.75 11.2799 15.75 11.7 15.75H14.55C14.9701 15.75 15.1801 15.75 15.3405 15.6683C15.4817 15.5963 15.5963 15.4817 15.6683 15.3405C15.75 15.1801 15.75 14.9701 15.75 14.55V11.7C15.75 11.2799 15.75 11.0699 15.6683 10.9095C15.5963 10.7683 15.4817 10.6537 15.3405 10.5818C15.1801 10.5 14.9701 10.5 14.55 10.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M6.3 10.5H3.45C3.02996 10.5 2.81994 10.5 2.65951 10.5818C2.51839 10.6537 2.40365 10.7683 2.33174 10.9095C2.25 11.0699 2.25 11.2799 2.25 11.7V14.55C2.25 14.9701 2.25 15.1801 2.33174 15.3405C2.40365 15.4817 2.51839 15.5963 2.65951 15.6683C2.81994 15.75 3.02996 15.75 3.45 15.75H6.3C6.72004 15.75 6.93006 15.75 7.09049 15.6683C7.23161 15.5963 7.34635 15.4817 7.41826 15.3405C7.5 15.1801 7.5 14.9701 7.5 14.55V11.7C7.5 11.2799 7.5 11.0699 7.41826 10.9095C7.34635 10.7683 7.23161 10.6537 7.09049 10.5818C6.93006 10.5 6.72004 10.5 6.3 10.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  group: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M0.75 15V12.9C0.75 12.475 0.859375 12.0844 1.07812 11.7281C1.29688 11.3719 1.5875 11.1 1.95 10.9125C2.725 10.525 3.5125 10.2344 4.3125 10.0406C5.1125 9.84688 5.925 9.75 6.75 9.75C7.575 9.75 8.3875 9.84688 9.1875 10.0406C9.9875 10.2344 10.775 10.525 11.55 10.9125C11.9125 11.1 12.2031 11.3719 12.4219 11.7281C12.6406 12.0844 12.75 12.475 12.75 12.9V15H0.75ZM14.25 15V12.75C14.25 12.2 14.0969 11.6719 13.7906 11.1656C13.4844 10.6594 13.05 10.225 12.4875 9.8625C13.125 9.9375 13.725 10.0656 14.2875 10.2469C14.85 10.4281 15.375 10.65 15.8625 10.9125C16.3125 11.1625 16.6563 11.4406 16.8938 11.7469C17.1313 12.0531 17.25 12.3875 17.25 12.75V15H14.25ZM6.75 9C5.925 9 5.21875 8.70625 4.63125 8.11875C4.04375 7.53125 3.75 6.825 3.75 6C3.75 5.175 4.04375 4.46875 4.63125 3.88125C5.21875 3.29375 5.925 3 6.75 3C7.575 3 8.28125 3.29375 8.86875 3.88125C9.45625 4.46875 9.75 5.175 9.75 6C9.75 6.825 9.45625 7.53125 8.86875 8.11875C8.28125 8.70625 7.575 9 6.75 9ZM14.25 6C14.25 6.825 13.9563 7.53125 13.3688 8.11875C12.7812 8.70625 12.075 9 11.25 9C11.1125 9 10.9375 8.98438 10.725 8.95312C10.5125 8.92188 10.3375 8.8875 10.2 8.85C10.5375 8.45 10.7969 8.00625 10.9781 7.51875C11.1594 7.03125 11.25 6.525 11.25 6C11.25 5.475 11.1594 4.96875 10.9781 4.48125C10.7969 3.99375 10.5375 3.55 10.2 3.15C10.375 3.0875 10.55 3.04688 10.725 3.02813C10.9 3.00938 11.075 3 11.25 3C12.075 3 12.7812 3.29375 13.3688 3.88125C13.9563 4.46875 14.25 5.175 14.25 6ZM2.25 13.5H11.25V12.9C11.25 12.7625 11.2156 12.6375 11.1469 12.525C11.0781 12.4125 10.9875 12.325 10.875 12.2625C10.2 11.925 9.51875 11.6719 8.83125 11.5031C8.14375 11.3344 7.45 11.25 6.75 11.25C6.05 11.25 5.35625 11.3344 4.66875 11.5031C3.98125 11.6719 3.3 11.925 2.625 12.2625C2.5125 12.325 2.42188 12.4125 2.35313 12.525C2.28438 12.6375 2.25 12.7625 2.25 12.9V13.5ZM6.75 7.5C7.1625 7.5 7.51563 7.35313 7.80938 7.05938C8.10313 6.76563 8.25 6.4125 8.25 6C8.25 5.5875 8.10313 5.23438 7.80938 4.94063C7.51563 4.64688 7.1625 4.5 6.75 4.5C6.3375 4.5 5.98438 4.64688 5.69063 4.94063C5.39688 5.23438 5.25 5.5875 5.25 6C5.25 6.4125 5.39688 6.76563 5.69063 7.05938C5.98438 7.35313 6.3375 7.5 6.75 7.5Z"
    fill="currentColor"
  />
</svg>`,
  h1: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.75 12.75V5.25H5.25V8.25H8.25V5.25H9.75V12.75H8.25V9.75H5.25V12.75H3.75ZM12.75 12.75V6.75H11.25V5.25H14.25V12.75H12.75Z" fill="currentColor"/>
</svg>`,
  h2: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.25 12.75V5.25H3.75V8.25H6.75V5.25H8.25V12.75H6.75V9.75H3.75V12.75H2.25ZM9.75 12.75V9.75C9.75 9.3375 9.89688 8.98438 10.1906 8.69063C10.4844 8.39688 10.8375 8.25 11.25 8.25H14.25V6.75H9.75V5.25H14.25C14.6625 5.25 15.0156 5.39687 15.3094 5.69063C15.6031 5.98438 15.75 6.3375 15.75 6.75V8.25C15.75 8.6625 15.6031 9.01563 15.3094 9.30938C15.0156 9.60313 14.6625 9.75 14.25 9.75H11.25V11.25H15.75V12.75H9.75Z" fill="currentColor"/>
</svg>`,
  h3: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.25 12.75V5.25H3.75V8.25H6.75V5.25H8.25V12.75H6.75V9.75H3.75V12.75H2.25ZM9.75 12.75V11.25H14.25V9.75H11.25V8.25H14.25V6.75H9.75V5.25H14.25C14.6625 5.25 15.0156 5.39687 15.3094 5.69063C15.6031 5.98438 15.75 6.3375 15.75 6.75V11.25C15.75 11.6625 15.6031 12.0156 15.3094 12.3094C15.0156 12.6031 14.6625 12.75 14.25 12.75H9.75Z" fill="currentColor"/>
</svg>`,
  h4: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.25 12.75V5.25H3.75V8.25H6.75V5.25H8.25V12.75H6.75V9.75H3.75V12.75H2.25ZM13.5 12.75V10.5H9.75V5.25H11.25V9H13.5V5.25H15V9H16.5V10.5H15V12.75H13.5Z" fill="currentColor"/>
</svg>`,
  h5: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.25 12.75V5.25H3.75V8.25H6.75V5.25H8.25V12.75H6.75V9.75H3.75V12.75H2.25ZM9.75 12.75V11.25H14.25V9.75H9.75V5.25H15.75V6.75H11.25V8.25H14.25C14.6625 8.25 15.0156 8.39688 15.3094 8.69063C15.6031 8.98438 15.75 9.3375 15.75 9.75V11.25C15.75 11.6625 15.6031 12.0156 15.3094 12.3094C15.0156 12.6031 14.6625 12.75 14.25 12.75H9.75Z" fill="currentColor"/>
</svg>`,
  h6: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.25 12.75V5.25H3.75V8.25H6.75V5.25H8.25V12.75H6.75V9.75H3.75V12.75H2.25ZM11.25 12.75C10.8375 12.75 10.4844 12.6031 10.1906 12.3094C9.89688 12.0156 9.75 11.6625 9.75 11.25V6.75C9.75 6.3375 9.89688 5.98438 10.1906 5.69063C10.4844 5.39687 10.8375 5.25 11.25 5.25H15.75V6.75H11.25V8.25H14.25C14.6625 8.25 15.0156 8.39688 15.3094 8.69063C15.6031 8.98438 15.75 9.3375 15.75 9.75V11.25C15.75 11.6625 15.6031 12.0156 15.3094 12.3094C15.0156 12.6031 14.6625 12.75 14.25 12.75H11.25ZM11.25 9.75V11.25H14.25V9.75H11.25Z" fill="currentColor"/>
</svg>`,
  hash: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 6H15M3 12H15M6 2.25V15.75M12 2.25V15.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  heading: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 3V15M13.5 3V15M6 3H3M13.5 9H4.5M6 15H3M15 15H12M15 3H12"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  heightFill: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.75 6.25L9 3M9 15L12.25 12.25M9 15L5.75 12.25M9 15V3M9 3L12.25 6.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  heightFixed: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 15.125V2.87503M9 2.87503L12.2501 2.87501M9 2.87503L5.75 2.875M12.2501 15.125H5.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  heightHug: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 15L9 11.25L12.75 15M5.25 3L9 6.75L12.75 3"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  help: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.8175 6.75C6.99382 6.24875 7.34186 5.82608 7.8 5.55685C8.2581 5.28762 8.79667 5.1892 9.3204 5.27903C9.84412 5.36887 10.3191 5.64114 10.6613 6.04765C11.0035 6.45415 11.1908 6.96864 11.19 7.5C11.19 9 8.94 9.75 8.94 9.75M9 12.75H9.0075M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  hexagon: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.41725 1.82383C8.62995 1.70566 8.7363 1.64657 8.84888 1.62341C8.94863 1.60291 9.05137 1.60291 9.15112 1.62341C9.2637 1.64657 9.37005 1.70566 9.58275 1.82383L15.1328 4.90716C15.3575 5.03196 15.4697 5.09436 15.5515 5.18312C15.6238 5.26163 15.6787 5.35469 15.7121 5.45608C15.75 5.57067 15.75 5.69917 15.75 5.95615V12.0439C15.75 12.301 15.75 12.4295 15.7121 12.5441C15.6787 12.6455 15.6238 12.7385 15.5515 12.817C15.4697 12.9058 15.3575 12.9682 15.1328 13.093L9.58275 16.1763C9.37005 16.2945 9.2637 16.3535 9.15112 16.3767C9.05137 16.3972 8.94863 16.3972 8.84888 16.3767C8.7363 16.3535 8.62995 16.2945 8.41725 16.1763L2.86723 13.093C2.64259 12.9682 2.53027 12.9058 2.44847 12.817C2.37612 12.7385 2.32136 12.6455 2.28786 12.5441C2.25 12.4295 2.25 12.301 2.25 12.0439V5.95615C2.25 5.69917 2.25 5.57067 2.28786 5.45608C2.32136 5.35469 2.37612 5.26163 2.44847 5.18312C2.53027 5.09436 2.64259 5.03196 2.86723 4.90716L8.41725 1.82383Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  horizontalBarChart: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 7.125V4.575C12.75 4.15496 12.75 3.94494 12.6683 3.78451C12.5963 3.64339 12.4817 3.52865 12.3405 3.45674C12.1801 3.375 11.9701 3.375 11.55 3.375H2.25M9.75 10.875V13.425C9.75 13.8451 9.75 14.0551 9.66825 14.2155C9.59632 14.3567 9.48165 14.4713 9.3405 14.5433C9.18008 14.625 8.97007 14.625 8.55 14.625H2.25M2.25 1.5V16.5M2.25 10.875H14.55C14.9701 10.875 15.1801 10.875 15.3405 10.7932C15.4817 10.7213 15.5963 10.6067 15.6683 10.4655C15.75 10.3051 15.75 10.0951 15.75 9.675V8.325C15.75 7.90493 15.75 7.69492 15.6683 7.5345C15.5963 7.39339 15.4817 7.27865 15.3405 7.20674C15.1801 7.125 14.9701 7.125 14.55 7.125H2.25V10.875Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  hilla: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <mask
    id="mask0_1795_30940"
    style="mask-type: luminance"
    maskUnits="userSpaceOnUse"
    x="1"
    y="1"
    width="16"
    height="16"
  >
    <path d="M16.875 1.6875H1.125V16.3125H16.875V1.6875Z" fill="white" />
  </mask>
  <g mask="url(#mask0_1795_30940)">
    <mask
      id="mask1_1795_30940"
      style="mask-type: alpha"
      maskUnits="userSpaceOnUse"
      x="1"
      y="1"
      width="16"
      height="16"
    >
      <path
        d="M16.7644 8.20405C16.469 7.03427 15.4391 6.11683 14.2563 5.94628C15.464 2.60481 11.2299 0.180846 8.99083 2.89325C6.74837 0.178915 2.51524 2.60915 3.72629 5.94769C0.259345 6.55457 0.256463 11.4556 3.72629 12.062C3.04942 13.7468 4.0395 15.7242 5.79195 16.1755C6.93816 16.5046 8.26014 16.0625 8.98937 15.1189C9.53702 15.8344 10.5012 16.2963 11.386 16.2785C13.5031 16.306 15.0634 14.0791 14.2539 12.0581C16.0136 11.8243 17.2631 9.96124 16.7644 8.20405ZM9.88239 10.4942C9.86029 10.5077 9.83773 10.5207 9.81518 10.5332C9.33238 10.8111 8.65119 10.8111 8.1684 10.5332C8.14629 10.5197 8.12374 10.5067 8.10113 10.4942H8.09685C7.84974 10.3434 7.64404 10.1329 7.49858 9.88176C7.35306 9.6306 7.27239 9.34682 7.26384 9.05629C7.26384 9.02248 7.26384 8.98868 7.26384 8.95532C7.27723 8.50302 7.46533 8.07377 7.78821 7.75872C8.11108 7.44366 8.54336 7.26748 8.99325 7.26765C10.749 7.28554 11.3649 9.58678 9.88914 10.4942H9.88239ZM6.58794 3.08119C6.86784 3.08139 7.14347 3.14989 7.39125 3.28084C7.63898 3.41178 7.85143 3.60126 8.01039 3.83298C8.12104 3.9903 8.26796 4.11835 8.43851 4.20617C8.60906 4.29401 8.79823 4.33903 8.98988 4.33738C9.18501 4.33729 9.37721 4.2896 9.55001 4.19837C9.72276 4.10716 9.87098 3.97514 9.98184 3.81365C10.8677 2.52509 13.0784 3.01162 13.1221 4.82053C13.1221 5.11783 13.0462 5.41015 12.9017 5.66959C12.7574 5.92896 12.5493 6.14687 12.2973 6.30235C11.5023 6.80578 10.4718 6.52892 9.97222 5.811C9.86113 5.65317 9.71387 5.52464 9.54287 5.43632C9.37181 5.348 9.18214 5.3025 8.98988 5.30368C8.79896 5.30205 8.61053 5.34701 8.44065 5.4347C8.27083 5.52238 8.12469 5.65018 8.01467 5.80712C7.42714 6.66522 6.12051 6.85315 5.34134 6.02503C4.29315 4.94132 5.07041 3.07684 6.58794 3.08119ZM8.24816 13.6718C7.9263 14.8347 6.49283 15.3174 5.53445 14.5695C4.87152 14.0675 4.68707 13.1481 5.02958 12.4306C5.10884 12.2627 5.14627 12.0778 5.13866 11.892C5.13105 11.7063 5.0786 11.5252 4.98586 11.3643L4.95174 11.3054C4.85772 11.1447 4.72643 11.0092 4.56909 10.9106C4.41174 10.812 4.233 10.7532 4.04814 10.7391C3.49378 10.6908 2.96295 10.3715 2.68817 9.87428C1.92532 8.55381 3.14358 6.94399 4.60011 7.31693C5.70499 7.58608 6.19644 8.81475 5.74678 9.7588C5.66691 9.93149 5.63001 10.1212 5.63929 10.3114C5.64862 10.5016 5.70381 10.6867 5.80011 10.8507L5.81017 10.8681C5.90569 11.0337 6.03956 11.1736 6.20038 11.2759C6.36126 11.3782 6.54429 11.4398 6.73397 11.4556C6.99024 11.4775 7.23853 11.5564 7.46083 11.6866C8.13381 12.0644 8.47586 12.9355 8.24912 13.6718H8.24816ZM15.2916 9.87428C15.1513 10.1186 14.9539 10.3248 14.7167 10.4754C14.4794 10.6258 14.2093 10.716 13.9297 10.7381C13.7469 10.7505 13.57 10.8076 13.4141 10.9042C13.2581 11.0009 13.1279 11.1342 13.0347 11.2928L12.99 11.3706C12.8968 11.5299 12.8441 11.7098 12.8367 11.8946C12.8293 12.0792 12.8675 12.2629 12.9478 12.4292C13.6559 13.8515 12.1201 15.5696 10.5271 14.6951C9.37755 14.0308 9.38379 12.347 10.5189 11.6866C10.7464 11.5538 11.0008 11.4745 11.263 11.4546C11.4474 11.44 11.6255 11.3804 11.7818 11.281C11.9382 11.1815 12.0682 11.0453 12.1604 10.8841L12.1979 10.8188C12.2889 10.6564 12.3396 10.4742 12.3452 10.2878C12.3509 10.1014 12.3116 9.91641 12.2305 9.74867C11.8659 8.96741 12.1253 7.96678 12.9132 7.50638C13.0588 7.4202 13.2161 7.35591 13.3801 7.31552C14.8559 6.95074 16.0516 8.54852 15.2925 9.87428H15.2916Z"
        fill="url(#paint0_linear_1795_30940)"
      />
    </mask>
    <g mask="url(#mask1_1795_30940)">
      <path
        d="M-20.3607 4.60958L16.8058 -17.6493L26.578 -1.33227L-10.5886 20.9266L-20.3607 4.60958Z"
        fill="#FF707A"
      />
      <path
        d="M-20.3607 4.60958L16.8058 -17.6493L26.578 -1.33227L-10.5886 20.9266L-20.3607 4.60958Z"
        fill="#FF707A"
      />
      <path
        d="M-12.2593 21.8684L24.9072 -0.390442L34.6794 15.9266L-2.4871 38.1855L-12.2593 21.8684Z"
        fill="#FF707A"
      />
      <path
        d="M-12.2593 21.8684L24.9072 -0.390442L34.6794 15.9266L-2.4871 38.1855L-12.2593 21.8684Z"
        fill="#00B4F0"
      />
    </g>
  </g>
  <defs>
    <linearGradient
      id="paint0_linear_1795_30940"
      x1="18.2954"
      y1="12.9077"
      x2="-3.45376"
      y2="-0.300254"
      gradientUnits="userSpaceOnUse"
    >
      <stop stop-color="#FF707A" />
      <stop offset="0.467045" stop-color="#5748FF" />
      <stop offset="1" stop-color="#00B4F0" />
    </linearGradient>
  </defs>
</svg>`,
  horizontalBottom: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 15V7.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9 15V3"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M13.5 15V10.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  horizontalCenter: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 12.75V5.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9 15V3"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M13.5 11.25V6.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  horizontalRule: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M3 9.75V8.25H15V9.75H3Z" fill="currentColor"/>
  </svg>`,
  horizontalTop: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 10.5V3"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9 15V3"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M13.5 7.5V3"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  imageIndentLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 6.9375H11.25M15.75 3H2.25M15.75 11.0625H11.25M15.75 15H2.25M3.45 12H7.05C7.47004 12 7.68008 12 7.8405 11.9182C7.98165 11.8463 8.09632 11.7317 8.16825 11.5905C8.25 11.4301 8.25 11.2201 8.25 10.8V7.2C8.25 6.77996 8.25 6.56994 8.16825 6.40951C8.09632 6.26839 7.98165 6.15365 7.8405 6.08174C7.68008 6 7.47004 6 7.05 6H3.45C3.02996 6 2.81994 6 2.65951 6.08174C2.51839 6.15365 2.40365 6.26839 2.33174 6.40951C2.25 6.56994 2.25 6.77996 2.25 7.2V10.8C2.25 11.2201 2.25 11.4301 2.33174 11.5905C2.40365 11.7317 2.51839 11.8463 2.65951 11.9182C2.81994 12 3.02996 12 3.45 12Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  image: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.15 15.75H5.19853C4.74416 15.75 4.51699 15.75 4.41179 15.6601C4.32051 15.5822 4.27207 15.4652 4.28149 15.3456C4.29234 15.2077 4.45298 15.047 4.77427 14.7257L11.1514 8.34855C11.4484 8.05155 11.597 7.90297 11.7682 7.8474C11.9188 7.79842 12.0812 7.79842 12.2318 7.8474C12.403 7.90297 12.5515 8.05155 12.8485 8.34855L15.75 11.25V12.15M12.15 15.75C13.4102 15.75 14.0401 15.75 14.5215 15.5048C14.9449 15.2891 15.2891 14.9449 15.5048 14.5215C15.75 14.0401 15.75 13.4102 15.75 12.15M12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15M7.875 6.375C7.875 7.20343 7.20343 7.875 6.375 7.875C5.54657 7.875 4.875 7.20343 4.875 6.375C4.875 5.54657 5.54657 4.875 6.375 4.875C7.20343 4.875 7.875 5.54657 7.875 6.375Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  info: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 12V9M9 6H9.0075M16.5 9C16.5 13.1421 13.1421 16.5 9 16.5C4.85786 16.5 1.5 13.1421 1.5 9C1.5 4.85786 4.85786 1.5 9 1.5C13.1421 1.5 16.5 4.85786 16.5 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  inbox: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.875 9H4.41148C4.92538 9 5.39518 9.29032 5.625 9.75C5.85482 10.2097 6.32462 10.5 6.83852 10.5H11.1615C11.6754 10.5 12.1452 10.2097 12.375 9.75C12.6048 9.29032 13.0746 9 13.5885 9H16.125M6.72492 3H11.275C12.0827 3 12.4865 3 12.8431 3.12297C13.1584 3.23172 13.4456 3.4092 13.6838 3.64256C13.9532 3.90645 14.1338 4.26765 14.495 4.99003L16.1199 8.23987C16.2617 8.52337 16.3325 8.66513 16.3825 8.81363C16.4269 8.94563 16.459 9.08138 16.4783 9.21923C16.5 9.3744 16.5 9.53287 16.5 9.84982V11.4C16.5 12.6601 16.5 13.2901 16.2548 13.7715C16.0391 14.1949 15.6949 14.5391 15.2715 14.7548C14.7901 15 14.1602 15 12.9 15H5.1C3.83988 15 3.20982 15 2.72852 14.7548C2.30516 14.5391 1.96095 14.1949 1.74524 13.7715C1.5 13.2901 1.5 12.6601 1.5 11.4V9.84982C1.5 9.53287 1.5 9.3744 1.52173 9.21923C1.54103 9.08138 1.57308 8.94563 1.61747 8.81363C1.66745 8.66513 1.73832 8.52337 1.88006 8.23987L3.50498 4.99003C3.86617 4.26764 4.04678 3.90645 4.31621 3.64256C4.55447 3.4092 4.84163 3.23172 5.15692 3.12297C5.51344 3 5.91727 3 6.72492 3Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
  `,
  justifyCenter: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.25 16.5V1.5H9.75V16.5H8.25ZM11.25 12.75V5.25H13.5V12.75H11.25ZM4.5 12.75V5.25H6.75V12.75H4.5Z"
    fill="currentColor"
  />
</svg>`,
  justifyEnd: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15 16.5V1.5H16.5V16.5H15ZM10.5 12.75V5.25H12.75V12.75H10.5ZM6 12.75V5.25H8.25V12.75H6Z"
    fill="currentColor"
  />
</svg>`,
  justifyStart: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M1.5 16.5V1.5H3V16.5H1.5ZM9.75 12.75V5.25H12V12.75H9.75ZM5.25 12.75V5.25H7.5V12.75H5.25Z"
    fill="currentColor"
  />
</svg>`,
  key: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 6.74995C12.75 6.36609 12.6035 5.98223 12.3106 5.68934C12.0178 5.39645 11.6338 5.25 11.25 5.25M11.25 11.25C13.7353 11.25 15.75 9.23527 15.75 6.75C15.75 4.26472 13.7353 2.25 11.25 2.25C8.76473 2.25 6.75 4.26472 6.75 6.75C6.75 6.95526 6.76374 7.15731 6.79036 7.35528C6.83414 7.6809 6.85602 7.84373 6.84129 7.9467C6.82594 8.05403 6.8064 8.11178 6.75352 8.20643C6.70275 8.29725 6.61328 8.38673 6.43435 8.56568L2.60147 12.3986C2.47176 12.5282 2.4069 12.5931 2.36052 12.6688C2.3194 12.7359 2.2891 12.809 2.27072 12.8856C2.25 12.9719 2.25 13.0637 2.25 13.247V14.55C2.25 14.9701 2.25 15.1801 2.33174 15.3405C2.40365 15.4817 2.51839 15.5963 2.65951 15.6683C2.81994 15.75 3.02996 15.75 3.45 15.75H5.25V14.25H6.75V12.75H8.25L9.43432 11.5657C9.61327 11.3867 9.70275 11.2973 9.79357 11.2465C9.88822 11.1936 9.94597 11.174 10.0533 11.1587C10.1563 11.1439 10.3191 11.1659 10.6447 11.2097C10.8427 11.2363 11.0447 11.25 11.25 11.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  keyboard: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 7.5H4.5075M6 10.5H6.0075M7.5 7.5H7.5075M9 10.5H9.0075M10.5 7.5H10.5075M12 10.5H12.0075M13.5 7.5H13.5075M3.9 13.5H14.1C14.9401 13.5 15.3602 13.5 15.681 13.3365C15.9632 13.1927 16.1927 12.9632 16.3365 12.681C16.5 12.3602 16.5 11.9401 16.5 11.1V6.9C16.5 6.05992 16.5 5.63988 16.3365 5.31902C16.1927 5.03677 15.9632 4.8073 15.681 4.66349C15.3602 4.5 14.9401 4.5 14.1 4.5H3.9C3.05992 4.5 2.63988 4.5 2.31902 4.66349C2.03677 4.8073 1.8073 5.03677 1.66349 5.31902C1.5 5.63988 1.5 6.05992 1.5 6.9V11.1C1.5 11.9401 1.5 12.3602 1.66349 12.681C1.8073 12.9632 2.03677 13.1927 2.31902 13.3365C2.63988 13.5 3.05992 13.5 3.9 13.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  kubernetes: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_2008_20966)">
    <path
      d="M8.94031 0.511507C8.78559 0.519301 8.63399 0.557663 8.49442 0.624342L2.40987 3.5316C2.25239 3.60681 2.11402 3.71624 2.00503 3.85177C1.89604 3.9873 1.81924 4.14544 1.78033 4.31444L0.279232 10.8449C0.24457 10.9953 0.24069 11.1512 0.267824 11.3032C0.294958 11.4551 0.352553 11.6002 0.437202 11.7297C0.457727 11.7613 0.479801 11.792 0.503346 11.8215L4.71483 17.0578C4.82384 17.1933 4.96223 17.3027 5.11971 17.3779C5.2772 17.4531 5.44974 17.4921 5.62451 17.4921L12.3783 17.4905C12.553 17.4906 12.7255 17.4517 12.883 17.3767C13.0405 17.3017 13.1789 17.1924 13.288 17.0571L17.4979 11.8199C17.607 11.6844 17.6838 11.5262 17.7228 11.3571C17.7617 11.188 17.7617 11.0124 17.7228 10.8433L16.2194 4.31289C16.1804 4.14388 16.1036 3.98574 15.9947 3.85021C15.8857 3.71469 15.7473 3.60525 15.5898 3.53005L9.50449 0.624342C9.32893 0.540465 9.13493 0.501666 8.94031 0.511507Z"
      fill="#326CE5"
    />
    <path
      d="M9.00071 2.73389C8.79959 2.73391 8.63651 2.91507 8.63653 3.13854C8.63653 3.14197 8.63723 3.14524 8.63731 3.14865C8.63701 3.17902 8.63554 3.2156 8.63653 3.24203C8.64133 3.37093 8.66942 3.46957 8.68633 3.58832C8.71697 3.84248 8.74264 4.05317 8.7268 4.24899C8.71139 4.32284 8.657 4.39037 8.60851 4.43731L8.59995 4.59139C8.3814 4.6095 8.16138 4.64265 7.94162 4.69255C6.99599 4.90726 6.18182 5.39435 5.56196 6.05202C5.52174 6.02458 5.45137 5.9741 5.43045 5.95864C5.36543 5.96742 5.29971 5.98748 5.21412 5.93763C5.05114 5.82792 4.9027 5.67649 4.72309 5.49407C4.64079 5.40681 4.58119 5.32372 4.48341 5.23961C4.46121 5.22051 4.42732 5.19467 4.40248 5.17502C4.32604 5.11407 4.23587 5.08229 4.1488 5.0793C4.03684 5.07547 3.92907 5.11924 3.85854 5.2077C3.73315 5.36497 3.7733 5.60533 3.94803 5.74464C3.9498 5.74606 3.95169 5.74715 3.95347 5.74853C3.97748 5.768 4.00689 5.79294 4.02896 5.80923C4.13272 5.88584 4.2275 5.92506 4.33089 5.98588C4.5487 6.12039 4.72927 6.23193 4.8725 6.3664C4.92843 6.42602 4.9382 6.53108 4.94565 6.57651L5.06237 6.68079C4.43751 7.62116 4.14831 8.78272 4.31922 9.96624L4.16669 10.0106C4.1265 10.0625 4.06969 10.1442 4.01028 10.1686C3.82289 10.2276 3.612 10.2493 3.35739 10.276C3.23786 10.2859 3.13472 10.28 3.00799 10.304C2.9801 10.3093 2.94124 10.3194 2.91072 10.3265C2.90966 10.3268 2.90867 10.3271 2.90761 10.3273C2.90594 10.3277 2.90376 10.3285 2.90216 10.3289C2.68751 10.3807 2.54961 10.578 2.594 10.7724C2.63841 10.9669 2.84808 11.0851 3.06402 11.0386C3.06558 11.0382 3.06784 11.0381 3.06947 11.0378C3.07191 11.0372 3.07405 11.036 3.07647 11.0355C3.10657 11.0288 3.1443 11.0215 3.17063 11.0144C3.29522 10.9811 3.38545 10.9321 3.49746 10.8892C3.73843 10.8027 3.93802 10.7305 4.13245 10.7024C4.21366 10.696 4.29922 10.7525 4.34178 10.7763L4.50053 10.7491C4.86584 11.8817 5.63141 12.7971 6.60082 13.3715L6.53468 13.5303C6.55852 13.5919 6.58482 13.6753 6.56706 13.7362C6.49637 13.9195 6.37529 14.113 6.23742 14.3287C6.17066 14.4283 6.10234 14.5057 6.04209 14.6197C6.02768 14.647 6.00932 14.6889 5.9954 14.7178C5.9018 14.918 5.97046 15.1487 6.15026 15.2353C6.33119 15.3224 6.55577 15.2305 6.65296 15.0298C6.65311 15.0295 6.6536 15.0293 6.65374 15.029C6.65384 15.0288 6.65364 15.0285 6.65374 15.0283C6.66758 14.9998 6.68719 14.9624 6.69887 14.9357C6.75047 14.8175 6.76764 14.7162 6.80393 14.6018C6.90028 14.3598 6.95323 14.1058 7.08588 13.9476C7.1222 13.9042 7.18142 13.8876 7.24282 13.8711L7.3253 13.7217C8.17042 14.0461 9.11639 14.1331 10.0614 13.9186C10.2769 13.8696 10.485 13.8063 10.6862 13.7303C10.7094 13.7714 10.7525 13.8504 10.7641 13.8703C10.8264 13.8906 10.8945 13.9011 10.95 13.9832C11.0493 14.1527 11.1172 14.3533 11.1998 14.5956C11.2361 14.7099 11.2541 14.8112 11.3057 14.9294C11.3174 14.9564 11.3369 14.9943 11.3508 15.0228C11.4478 15.2241 11.6731 15.3163 11.8543 15.229C12.0341 15.1424 12.1028 14.9118 12.0091 14.7115C11.9952 14.6827 11.9761 14.6408 11.9617 14.6135C11.9014 14.4995 11.8331 14.4229 11.7663 14.3232C11.6285 14.1075 11.5141 13.9284 11.4434 13.7451C11.4138 13.6505 11.4484 13.5917 11.4714 13.5303C11.4576 13.5145 11.4281 13.4252 11.4107 13.3832C12.4182 12.7884 13.1613 11.8388 13.5102 10.7421C13.5574 10.7495 13.6393 10.764 13.6659 10.7693C13.7206 10.7332 13.771 10.6861 13.8697 10.6938C14.0642 10.722 14.2638 10.7942 14.5047 10.8806C14.6168 10.9235 14.707 10.9733 14.8316 11.0067C14.8579 11.0137 14.8956 11.0203 14.9257 11.0269C14.9282 11.0275 14.9303 11.0287 14.9327 11.0292C14.9344 11.0296 14.9366 11.0296 14.9382 11.03C15.1541 11.0765 15.3638 10.9583 15.4082 10.7639C15.4525 10.5695 15.3147 10.3721 15.1 10.3203C15.0688 10.3132 15.0245 10.3012 14.9942 10.2954C14.8675 10.2714 14.7643 10.2773 14.6448 10.2674C14.3902 10.2407 14.1793 10.219 13.9919 10.16C13.9155 10.1304 13.8612 10.0395 13.8347 10.002L13.6877 9.95924C13.7639 9.40756 13.7433 8.8334 13.6114 8.25893C13.4782 7.6791 13.2428 7.14879 12.9289 6.68157C12.9667 6.64727 13.0379 6.58418 13.0581 6.56562C13.064 6.50027 13.0589 6.43176 13.1266 6.3594C13.2698 6.22492 13.4504 6.1134 13.6682 5.97887C13.7716 5.91805 13.8672 5.87885 13.9709 5.80223C13.9944 5.7849 14.0264 5.75747 14.0511 5.73764C14.2258 5.59828 14.266 5.35793 14.1406 5.2007C14.0151 5.04347 13.7721 5.02866 13.5974 5.16802C13.5725 5.18771 13.5388 5.2134 13.5165 5.23261C13.4187 5.31672 13.3583 5.3998 13.276 5.48707C13.0964 5.6695 12.9479 5.82169 12.785 5.93141C12.7144 5.97252 12.6109 5.95829 12.564 5.95553L12.4255 6.05436C11.6356 5.22612 10.5602 4.69659 9.40225 4.59372C9.39901 4.5452 9.39477 4.45748 9.39369 4.43108C9.34629 4.38572 9.28902 4.347 9.27463 4.24899C9.25879 4.05317 9.28524 3.84248 9.31588 3.58832C9.33279 3.46957 9.36088 3.37093 9.36568 3.24203C9.36677 3.21273 9.36502 3.17022 9.3649 3.13854C9.36488 2.91507 9.20184 2.73387 9.00071 2.73389ZM8.5447 5.55866L8.43654 7.46908L8.42876 7.47297C8.4215 7.64388 8.28084 7.78035 8.10815 7.78035C8.03741 7.78035 7.97211 7.75763 7.91905 7.71887L7.91594 7.72043L6.34947 6.60997C6.83091 6.13657 7.44671 5.78672 8.1564 5.62558C8.28603 5.59615 8.41561 5.57431 8.5447 5.55866ZM9.4575 5.55866C10.2861 5.66056 11.0523 6.03574 11.6395 6.61075L10.0832 7.7142L10.0777 7.71187C9.93957 7.81276 9.74494 7.78773 9.63726 7.65273C9.59315 7.59742 9.57001 7.53239 9.56723 7.46674L9.56567 7.46597L9.4575 5.55866ZM5.78141 7.32356L7.21169 8.60288L7.21013 8.61066C7.33923 8.72289 7.35827 8.91764 7.2506 9.05266C7.20649 9.10797 7.14746 9.14507 7.08407 9.16239L7.08251 9.16861L5.24914 9.69777C5.15582 8.84451 5.35692 8.01508 5.78141 7.32356ZM12.2099 7.32434C12.4224 7.66879 12.5833 8.05351 12.6791 8.47059C12.7738 8.88267 12.7976 9.29401 12.7585 9.69154L10.9158 9.16083L10.9142 9.15305C10.7492 9.10795 10.6478 8.9401 10.6862 8.77174C10.702 8.70277 10.7386 8.64443 10.7882 8.60132L10.7874 8.59743L12.2099 7.32434ZM8.70734 8.7017H9.29331L9.65749 9.15694L9.52676 9.725L9.00071 9.97791L8.47311 9.72423L8.34238 9.15616L8.70734 8.7017ZM10.5859 10.2596C10.6108 10.2584 10.6355 10.2606 10.6598 10.2651L10.6629 10.2612L12.5593 10.5818C12.2818 11.3615 11.7507 12.037 11.0411 12.4891L10.3049 10.711L10.3073 10.7078C10.2396 10.5507 10.3073 10.3664 10.4629 10.2915C10.5027 10.2723 10.5444 10.2617 10.5859 10.2596ZM7.40079 10.2674C7.54551 10.2694 7.67532 10.3699 7.70894 10.5172C7.72469 10.5862 7.71703 10.6545 7.69105 10.7148L7.69649 10.7218L6.96812 12.4821C6.28714 12.0451 5.74473 11.3908 5.45457 10.588L7.33464 10.2689L7.33776 10.2728C7.35879 10.269 7.38011 10.2671 7.40079 10.2674ZM8.98904 11.0386C9.03945 11.0367 9.09061 11.0471 9.13923 11.0705C9.20297 11.1012 9.2522 11.1495 9.28319 11.2074H9.2902L10.217 12.8821C10.0967 12.9224 9.97306 12.9568 9.84659 12.9856C9.13778 13.1465 8.43122 13.0977 7.79143 12.8797L8.7159 11.2082H8.71746C8.77293 11.1045 8.87814 11.0426 8.98904 11.0386Z"
      fill="white"
      stroke="white"
      stroke-width="0.25"
    />
  </g>
  <defs>
    <clipPath id="clip0_2008_20966">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  layoutBottom: t`
  <svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 11.25H15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  layoutLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  layoutRight: t`
  <svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M11.25 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  layoutTop: t`
  <svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 6.75H15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  layout: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 6.75H15.75M6.75 6.75V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  letterSpacing: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 9.75H11.25M5.25 12.75L8.45377 5.70169C8.62732 5.31992 8.7141 5.12904 8.83433 5.06982C8.9388 5.01836 9.0612 5.01836 9.16567 5.06982C9.2859 5.12904 9.37268 5.31992 9.54623 5.70169L12.75 12.75M15.75 2.25V15.75M2.25 2.25V15.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  lightning: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9.75003 1.5L3.07011 9.51592C2.8085 9.8298 2.6777 9.98678 2.6757 10.1194C2.67396 10.2346 2.72532 10.3442 2.81496 10.4167C2.91808 10.5 3.1224 10.5 3.53105 10.5H9.00003L8.25003 16.5L14.9299 8.48408C15.1915 8.1702 15.3223 8.01322 15.3243 7.88062C15.3261 7.76542 15.2748 7.65578 15.1851 7.58333C15.0819 7.5 14.8776 7.5 14.469 7.5H9.00003L9.75003 1.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  lineChart: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.75 15.75H3.45C3.02996 15.75 2.81994 15.75 2.65951 15.6683C2.51839 15.5963 2.40365 15.4817 2.33174 15.3405C2.25 15.1801 2.25 14.9701 2.25 14.55V2.25M15 6L12.0608 9.13703C11.9495 9.2559 11.8938 9.3153 11.8266 9.34605C11.7673 9.3732 11.7019 9.38437 11.637 9.37852C11.5634 9.37185 11.4911 9.33435 11.3465 9.25928L8.90347 7.99072C8.75887 7.91565 8.68658 7.87815 8.613 7.87148C8.54805 7.86563 8.48273 7.8768 8.4234 7.90395C8.3562 7.9347 8.30055 7.9941 8.18917 8.11297L5.25 11.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  lineHeight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 9.75H11.25M5.25 12.75L8.45377 5.70168C8.62732 5.31992 8.7141 5.12904 8.83433 5.06982C8.9388 5.01836 9.0612 5.01836 9.16567 5.06982C9.2859 5.12904 9.37268 5.31992 9.54623 5.70168L12.75 12.75M15.75 15.75H2.25M15.75 2.25H2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  link: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.75 12.75H5.25C3.17893 12.75 1.5 11.071 1.5 9C1.5 6.92893 3.17893 5.25 5.25 5.25H6.75M11.25 12.75H12.75C14.821 12.75 16.5 11.071 16.5 9C16.5 6.92893 14.821 5.25 12.75 5.25H11.25M5.25 9H12.75" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>

  `,
  list: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 9H6.75M15.75 4.5H6.75M15.75 13.5H6.75M3.75 9C3.75 9.41423 3.41421 9.75 3 9.75C2.58579 9.75 2.25 9.41423 2.25 9C2.25 8.58578 2.58579 8.25 3 8.25C3.41421 8.25 3.75 8.58578 3.75 9ZM3.75 4.5C3.75 4.91421 3.41421 5.25 3 5.25C2.58579 5.25 2.25 4.91421 2.25 4.5C2.25 4.08579 2.58579 3.75 3 3.75C3.41421 3.75 3.75 4.08579 3.75 4.5ZM3.75 13.5C3.75 13.9142 3.41421 14.25 3 14.25C2.58579 14.25 2.25 13.9142 2.25 13.5C2.25 13.0858 2.58579 12.75 3 12.75C3.41421 12.75 3.75 13.0858 3.75 13.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  loading: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 1.6875V3.5625M9 13.5V16.5M4.3125 9H1.6875M15.9375 9H14.8125M13.8428 13.8428L13.3125 13.3125M13.9982 4.06184L12.9375 5.1225M3.69118 14.3088L5.8125 12.1875M3.84651 3.90651L5.4375 5.4975"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  lock: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 8.25V6C12.75 3.92893 11.071 2.25 9 2.25C6.92893 2.25 5.25 3.92893 5.25 6V8.25M6.6 15.75H11.4C12.6601 15.75 13.2901 15.75 13.7715 15.5048C14.1949 15.2891 14.539 14.9449 14.7547 14.5215C15 14.0401 15 13.4102 15 12.15V11.85C15 10.5899 15 9.95985 14.7547 9.4785C14.539 9.05512 14.1949 8.71095 13.7715 8.49525C13.2901 8.25 12.6601 8.25 11.4 8.25H6.6C5.33988 8.25 4.70982 8.25 4.22852 8.49525C3.80515 8.71095 3.46095 9.05512 3.24524 9.4785C3 9.95985 3 10.5899 3 11.85V12.15C3 13.4102 3 14.0401 3.24524 14.5215C3.46095 14.9449 3.80515 15.2891 4.22852 15.5048C4.70982 15.75 5.33988 15.75 6.6 15.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  logIn: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 12.75C4.5 13.0134 4.5 13.1451 4.51175 13.2597C4.60931 14.2105 5.29695 14.9959 6.22655 15.2183C6.33851 15.2451 6.46912 15.2625 6.73026 15.2973L11.6742 15.9565C13.0815 16.1442 13.7852 16.238 14.3313 16.0208C14.8109 15.8301 15.2102 15.4805 15.4626 15.0304C15.75 14.5177 15.75 13.8078 15.75 12.3881V5.6118C15.75 4.19202 15.75 3.48213 15.4626 2.96948C15.2102 2.51939 14.8109 2.16972 14.3313 1.97907C13.7852 1.76191 13.0815 1.85573 11.6742 2.04338L6.73026 2.70257C6.46909 2.73739 6.33851 2.7548 6.22655 2.78159C5.29695 3.00396 4.60931 3.78937 4.51175 4.74019C4.5 4.85473 4.5 4.98646 4.5 5.24994M9 5.99994L12 8.99997M12 8.99997L9 12M12 8.99997H2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  lowPriority: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 8.60625C3 9.49375 3.29688 10.2563 3.89062 10.8938C4.48438 11.5313 5.225 11.8875 6.1125 11.9625L4.95 10.8L6 9.75L9 12.75L6 15.75L4.95 14.7L6.15 13.5C4.8375 13.425 3.73438 12.9188 2.84063 11.9813C1.94688 11.0438 1.5 9.925 1.5 8.625C1.5 7.2625 1.97188 6.10938 2.91563 5.16563C3.85938 4.22188 5.0125 3.75 6.375 3.75H9V5.25H6.375C5.4375 5.25 4.64063 5.575 3.98438 6.225C3.32813 6.875 3 7.66875 3 8.60625ZM10.5 13.5V12H16.5V13.5H10.5ZM10.5 9.375V7.875H16.5V9.375H10.5ZM10.5 5.25V3.75H16.5V5.25H10.5Z"
    fill="currentColor"
  />
</svg>`,
  magic: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9.75002 10.5L7.50002 8.25M11.2577 2.625V1.5M14.2123 3.79549L15.0077 3M14.2123 9.75L15.0077 10.5455M8.25774 3.79549L7.46228 3M15.3827 6.75H16.5077M4.59854 15.6515L11.5265 8.72355C11.8235 8.42655 11.972 8.27798 12.0276 8.10675C12.0766 7.95615 12.0766 7.79385 12.0276 7.64325C11.972 7.47199 11.8235 7.32349 11.5265 7.02647L10.9736 6.47353C10.6765 6.17651 10.528 6.02801 10.3568 5.97237C10.2062 5.92343 10.0439 5.92343 9.89327 5.97237C9.72197 6.02801 9.57347 6.17651 9.27647 6.47353L2.34854 13.4015C2.05153 13.6985 1.90302 13.847 1.84738 14.0182C1.79843 14.1688 1.79843 14.3312 1.84738 14.4818C1.90302 14.653 2.05153 14.8015 2.34854 15.0985L2.90148 15.6515C3.1985 15.9485 3.347 16.097 3.51825 16.1526C3.66888 16.2016 3.83114 16.2016 3.98177 16.1526C4.15302 16.097 4.30153 15.9485 4.59854 15.6515Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  map: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_881_4213)">
    <path
      d="M6.75 13.5L1.5 16.5V4.5L6.75 1.5M6.75 13.5L12 16.5M6.75 13.5V1.5M6.75 1.5L12 4.5M12 16.5L16.5 13.5V1.5L12 4.5M12 16.5V4.5"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_881_4213">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  markerPin: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 9.75C10.2427 9.75 11.25 8.74268 11.25 7.5C11.25 6.25736 10.2427 5.25 9 5.25C7.75732 5.25 6.75 6.25736 6.75 7.5C6.75 8.74268 7.75732 9.75 9 9.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M9 16.5C12 13.5 15 10.8137 15 7.5C15 4.18629 12.3137 1.5 9 1.5C5.68629 1.5 3 4.18629 3 7.5C3 10.8137 6 13.5 9 16.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  menuAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 9H15.75M2.25 4.5H15.75M2.25 13.5H11.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  messageChat: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_881_3859)">
    <path
      d="M7.5 11.25L5.19355 13.5853C4.87184 13.911 4.71098 14.0739 4.57271 14.0854C4.45276 14.0954 4.33532 14.0471 4.25697 13.9557C4.16667 13.8504 4.16667 13.6215 4.16667 13.1636V11.9937C4.16667 11.583 3.8303 11.2858 3.4239 11.2262C2.4403 11.0821 1.66784 10.3097 1.52376 9.3261C1.5 9.16395 1.5 8.97037 1.5 8.5833V5.1C1.5 3.83988 1.5 3.20982 1.74524 2.72852C1.96095 2.30516 2.30516 1.96095 2.72852 1.74524C3.20982 1.5 3.83988 1.5 5.1 1.5H10.65C11.9101 1.5 12.5401 1.5 13.0215 1.74524C13.4449 1.96095 13.7891 2.30516 14.0048 2.72852C14.25 3.20982 14.25 3.83988 14.25 5.1V8.25M14.25 16.5L12.6177 15.3652C12.3883 15.2057 12.2735 15.1258 12.1487 15.0693C12.0378 15.0191 11.9213 14.9826 11.8017 14.9605C11.6669 14.9357 11.5271 14.9357 11.2477 14.9357H9.9C9.05992 14.9357 8.63985 14.9357 8.319 14.7722C8.03678 14.6285 7.80728 14.3989 7.6635 14.1167C7.5 13.7958 7.5 13.3758 7.5 12.5357V10.65C7.5 9.80992 7.5 9.38985 7.6635 9.069C7.80728 8.78678 8.03678 8.55728 8.319 8.4135C8.63985 8.25 9.05992 8.25 9.9 8.25H14.1C14.9401 8.25 15.3602 8.25 15.681 8.4135C15.9632 8.55728 16.1927 8.78678 16.3365 9.069C16.5 9.38985 16.5 9.80992 16.5 10.65V12.6857C16.5 13.3847 16.5 13.7341 16.3858 14.0098C16.2336 14.3773 15.9415 14.6693 15.574 14.8215C15.2983 14.9357 14.9489 14.9357 14.25 14.9357V16.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_881_3859">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  message: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V9.9C15.75 11.1601 15.75 11.7901 15.5048 12.2715C15.2891 12.6949 14.9449 13.0391 14.5215 13.2548C14.0401 13.5 13.4102 13.5 12.15 13.5H10.2628C9.79477 13.5 9.56077 13.5 9.3369 13.546C9.1383 13.5867 8.94615 13.6541 8.76562 13.7464C8.56215 13.8503 8.37937 13.9965 8.0139 14.2888L6.22482 15.7201C5.91275 15.9698 5.75672 16.0946 5.6254 16.0948C5.5112 16.0949 5.40317 16.043 5.33192 15.9537C5.25 15.8511 5.25 15.6513 5.25 15.2516V13.5C4.55252 13.5 4.20378 13.5 3.91765 13.4234C3.1412 13.2153 2.53472 12.6088 2.32667 11.8324C2.25 11.5462 2.25 11.1975 2.25 10.5V5.85Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  minus: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3.75 9H14.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  mouse: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 16.5C7.55 16.5 6.3125 15.9875 5.2875 14.9625C4.2625 13.9375 3.75 12.7 3.75 11.25V6.75C3.75 5.3 4.2625 4.0625 5.2875 3.0375C6.3125 2.0125 7.55 1.5 9 1.5C10.45 1.5 11.6875 2.0125 12.7125 3.0375C13.7375 4.0625 14.25 5.3 14.25 6.75V11.25C14.25 12.7 13.7375 13.9375 12.7125 14.9625C11.6875 15.9875 10.45 16.5 9 16.5ZM9.75 6.75H12.75C12.75 5.85 12.4656 5.05625 11.8969 4.36875C11.3281 3.68125 10.6125 3.25 9.75 3.075V6.75ZM5.25 6.75H8.25V3.075C7.3875 3.25 6.67188 3.68125 6.10313 4.36875C5.53438 5.05625 5.25 5.85 5.25 6.75ZM9 15C10.0375 15 10.9219 14.6344 11.6531 13.9031C12.3844 13.1719 12.75 12.2875 12.75 11.25V8.25H5.25V11.25C5.25 12.2875 5.61563 13.1719 6.34688 13.9031C7.07813 14.6344 7.9625 15 9 15Z"
    fill="currentColor"
  />
</svg>`,
  notes: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 9H15.75M2.25 4.5H15.75M2.25 13.5H11.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  paddingBottom: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 15.75H4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
</svg>`,
  paddingHorizontal: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
  <path
    d="M15.75 13.5V4.5M2.25 13.5V4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  paddingLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
  <path
    d="M2.25 13.5V4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  paddingRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
  <path
    d="M15.75 13.5V4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  paddingTop: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 2.25H4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
</svg>`,
  paddingVertical: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 2.25H4.5M13.5 15.75H4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
</svg>`,
  padding: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M13.5 2.25H4.5M13.5 15.75H4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <rect
    x="6.75"
    y="6.75"
    width="4.5"
    height="4.5"
    rx="1.25"
    stroke="currentColor"
    stroke-width="1.5"
  />
  <path
    d="M15.75 13.5V4.5M2.25 13.5V4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  palette: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_953_8379)">
    <path
      d="M1.5 9C1.5 13.1421 4.85786 16.5 9 16.5C10.2427 16.5 11.25 15.4927 11.25 14.25V13.875C11.25 13.5267 11.25 13.3526 11.2693 13.2063C11.4022 12.1967 12.1967 11.4022 13.2063 11.2693C13.3526 11.25 13.5267 11.25 13.875 11.25H14.25C15.4927 11.25 16.5 10.2427 16.5 9C16.5 4.85786 13.1421 1.5 9 1.5C4.85786 1.5 1.5 4.85786 1.5 9Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
    <path
      d="M5.25 9.75C5.66421 9.75 6 9.41422 6 9C6 8.58578 5.66421 8.25 5.25 8.25C4.83579 8.25 4.5 8.58578 4.5 9C4.5 9.41422 4.83579 9.75 5.25 9.75Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
    <path
      d="M12 6.75C12.4142 6.75 12.75 6.41421 12.75 6C12.75 5.58579 12.4142 5.25 12 5.25C11.5858 5.25 11.25 5.58579 11.25 6C11.25 6.41421 11.5858 6.75 12 6.75Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
    <path
      d="M7.5 6C7.91422 6 8.25 5.66421 8.25 5.25C8.25 4.83579 7.91422 4.5 7.5 4.5C7.08579 4.5 6.75 4.83579 6.75 5.25C6.75 5.66421 7.08579 6 7.5 6Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_953_8379">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  passcode: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 9H9.00375M12.75 9H12.7537M5.25 9H5.25375M3.9 5.25H14.1C14.9401 5.25 15.3602 5.25 15.681 5.41349C15.9632 5.5573 16.1927 5.78677 16.3365 6.06902C16.5 6.38988 16.5 6.80992 16.5 7.65V10.35C16.5 11.1901 16.5 11.6101 16.3365 11.931C16.1927 12.2132 15.9632 12.4427 15.681 12.5865C15.3602 12.75 14.9401 12.75 14.1 12.75H3.9C3.05992 12.75 2.63988 12.75 2.31902 12.5865C2.03677 12.4427 1.8073 12.2132 1.66349 11.931C1.5 11.6101 1.5 11.1901 1.5 10.35V7.65C1.5 6.80992 1.5 6.38988 1.66349 6.06902C1.8073 5.78677 2.03677 5.5573 2.31902 5.41349C2.63988 5.25 3.05992 5.25 3.9 5.25ZM9.1875 9C9.1875 9.10357 9.10357 9.1875 9 9.1875C8.89643 9.1875 8.8125 9.10357 8.8125 9C8.8125 8.89643 8.89643 8.8125 9 8.8125C9.10357 8.8125 9.1875 8.89643 9.1875 9ZM12.9375 9C12.9375 9.10357 12.8536 9.1875 12.75 9.1875C12.6464 9.1875 12.5625 9.10357 12.5625 9C12.5625 8.89643 12.6464 8.8125 12.75 8.8125C12.8536 8.8125 12.9375 8.89643 12.9375 9ZM5.4375 9C5.4375 9.10357 5.35355 9.1875 5.25 9.1875C5.14645 9.1875 5.0625 9.10357 5.0625 9C5.0625 8.89643 5.14645 8.8125 5.25 8.8125C5.35355 8.8125 5.4375 8.89643 5.4375 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  pentagon: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.29537 2.19902C8.54872 2.01517 8.6754 1.92324 8.81385 1.88772C8.9361 1.85636 9.06435 1.85636 9.1866 1.88772C9.32505 1.92324 9.45172 2.01517 9.70507 2.19902L15.7939 6.61797C16.0477 6.80217 16.1747 6.89426 16.2514 7.01513C16.3192 7.12184 16.3589 7.24397 16.3668 7.37013C16.3758 7.51305 16.3273 7.66215 16.2303 7.96035L13.9051 15.1087C13.8082 15.4066 13.7597 15.5555 13.6685 15.6657C13.588 15.763 13.4842 15.8384 13.3668 15.8849C13.2338 15.9375 13.0771 15.9375 12.7639 15.9375H5.23652C4.92328 15.9375 4.76665 15.9375 4.63366 15.8849C4.51623 15.8384 4.41244 15.763 4.33192 15.6657C4.24072 15.5555 4.19227 15.4066 4.09537 15.1087L1.77016 7.96035C1.67314 7.66215 1.62464 7.51305 1.63363 7.37013C1.64155 7.24397 1.68124 7.12184 1.74901 7.01513C1.82575 6.89426 1.95266 6.80217 2.20647 6.61797L8.29537 2.19902Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  phone: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.28521 6.64001C6.8072 7.72725 7.51882 8.7462 8.41995 9.6474C9.32115 10.5486 10.3402 11.2602 11.4274 11.7822C11.5209 11.8271 11.5676 11.8496 11.6268 11.8668C11.8371 11.9281 12.0952 11.884 12.2733 11.7565C12.3235 11.7206 12.3663 11.6778 12.452 11.5921C12.7142 11.3298 12.8453 11.1987 12.9772 11.113C13.4743 10.7898 14.1153 10.7898 14.6125 11.113C14.7443 11.1987 14.8754 11.3298 15.1376 11.5921L15.2837 11.7382C15.6823 12.1368 15.8816 12.3361 15.9898 12.5501C16.2052 12.9757 16.2052 13.4785 15.9898 13.9042C15.8816 14.1182 15.6823 14.3175 15.2837 14.7161L15.1655 14.8342C14.7683 15.2315 14.5697 15.4301 14.2996 15.5818C14 15.7501 13.5346 15.8711 13.191 15.8701C12.8813 15.8692 12.6696 15.8091 12.2463 15.689C9.97125 15.0432 7.82445 13.8249 6.03349 12.0339C4.24251 10.2429 3.02415 8.0961 2.37843 5.82108C2.25827 5.39774 2.19819 5.18608 2.19727 4.87637C2.19624 4.5327 2.31726 4.06733 2.48558 3.7677C2.63727 3.49768 2.83587 3.29907 3.2331 2.90185L3.35132 2.78362C3.7499 2.38504 3.9492 2.18575 4.16323 2.07749C4.5889 1.86219 5.0916 1.86219 5.51727 2.07749C5.7313 2.18575 5.9306 2.38504 6.32918 2.78362L6.47533 2.92978C6.73753 3.19198 6.86864 3.32309 6.95435 3.45491C7.2776 3.95209 7.2776 4.59302 6.95435 5.09019C6.86864 5.22202 6.73753 5.35313 6.47533 5.61533C6.3896 5.70107 6.34673 5.74393 6.31085 5.79403C6.18334 5.97211 6.13932 6.2303 6.20061 6.44057C6.21786 6.49974 6.2403 6.54649 6.28521 6.64001Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
  `,
  pieChart: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_2290_25908)">
<path d="M15.9078 11.9174C15.4307 13.0458 14.6844 14.0401 13.7342 14.8134C12.7841 15.5867 11.6589 16.1155 10.4571 16.3535C9.25538 16.5915 8.0136 16.5315 6.84041 16.1787C5.6672 15.826 4.59827 15.1912 3.72707 14.3299C2.85587 13.4686 2.20892 12.407 1.84278 11.2379C1.47665 10.0688 1.40247 8.82777 1.62675 7.62342C1.85103 6.41902 2.36693 5.2879 3.12934 4.32895C3.89175 3.37 4.87747 2.61242 6.0003 2.12243M15.9294 6.1298C16.2296 6.85465 16.4138 7.62095 16.4763 8.40057C16.4918 8.59317 16.4995 8.68947 16.4612 8.77625C16.4293 8.8487 16.366 8.91725 16.2963 8.9549C16.2129 8.9999 16.1087 8.9999 15.9003 8.9999H9.6003C9.3903 8.9999 9.2853 8.9999 9.20505 8.9591C9.13448 8.9231 9.0771 8.86572 9.04118 8.79515C9.0003 8.71497 9.0003 8.60997 9.0003 8.39989V2.09993C9.0003 1.89153 9.0003 1.78733 9.04538 1.70392C9.08303 1.63424 9.15158 1.57095 9.22403 1.539C9.3108 1.50076 9.4071 1.50847 9.5997 1.52392C10.3793 1.58642 11.1456 1.77059 11.8704 2.07083C12.7804 2.44774 13.6072 3.00019 14.3036 3.69663C15.0001 4.39307 15.5525 5.21986 15.9294 6.1298Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</g>
<defs>
<clipPath id="clip0_2290_25908">
<rect width="18" height="18" fill="white"/>
</clipPath>
</defs>
</svg>`,
  pinAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.28255 11.7123L2.03992 15.9549M8.77083 4.98139L7.60015 6.15205C7.50468 6.24755 7.45692 6.2953 7.40252 6.33323C7.35424 6.36691 7.30215 6.39478 7.24735 6.41628C7.18561 6.4405 7.1194 6.45374 6.98697 6.48022L4.23862 7.02989C3.52439 7.17274 3.16728 7.24416 3.00021 7.43245C2.85466 7.59648 2.78819 7.816 2.81831 8.0332C2.85288 8.28258 3.11039 8.54005 3.62543 9.05515L8.93973 14.3694C9.45475 14.8845 9.7123 15.142 9.9616 15.1766C10.1789 15.2067 10.3984 15.1402 10.5624 14.9946C10.7507 14.8276 10.8221 14.4705 10.965 13.7562L11.5146 11.0079C11.5411 10.8755 11.5544 10.8093 11.5786 10.7475C11.6001 10.6927 11.628 10.6407 11.6616 10.5924C11.6996 10.5379 11.7473 10.4902 11.8428 10.3947L13.0134 9.22405C13.0745 9.163 13.1051 9.13248 13.1386 9.10578C13.1684 9.08215 13.2 9.06078 13.233 9.04188C13.2702 9.02058 13.3099 9.00363 13.3893 8.96958L15.2601 8.16783C15.8058 7.9339 16.0788 7.81698 16.2027 7.62798C16.3111 7.46272 16.3499 7.26134 16.3106 7.06764C16.2657 6.84613 16.0557 6.63619 15.6359 6.21632L11.7786 2.35897C11.3586 1.9391 11.1487 1.72917 10.9272 1.68427C10.7335 1.645 10.5321 1.68378 10.3669 1.79218C10.1779 1.91614 10.0609 2.18902 9.82705 2.7348L9.0253 4.60556C8.99125 4.68493 8.97423 4.72461 8.953 4.76182C8.9341 4.79488 8.91273 4.82644 8.88903 4.85625C8.8624 4.88981 8.83188 4.92034 8.77083 4.98139Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  pin: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9.0003 11.25V16.5V11.25ZM6.00032 5.4811V7.07906C6.00032 7.23508 6.00032 7.31308 5.985 7.38769C5.97142 7.45389 5.94895 7.51793 5.91821 7.57815C5.88355 7.64595 5.83482 7.70685 5.73736 7.82872L4.56003 9.30037C4.06072 9.92453 3.81107 10.2365 3.81079 10.4992C3.81054 10.7276 3.91439 10.9437 4.0929 11.0861C4.29816 11.25 4.69779 11.25 5.49707 11.25H12.5035C13.3028 11.25 13.7025 11.25 13.9078 11.0861C14.0863 10.9437 14.1901 10.7276 14.1898 10.4992C14.1895 10.2365 13.9399 9.92453 13.4406 9.30037L12.2632 7.82872C12.1658 7.70685 12.1171 7.64595 12.0824 7.57815C12.0517 7.51793 12.0292 7.45389 12.0156 7.38769C12.0003 7.31308 12.0003 7.23508 12.0003 7.07906V5.4811C12.0003 5.39476 12.0003 5.35158 12.0052 5.30901C12.0095 5.27119 12.0167 5.23375 12.0268 5.19703C12.038 5.15568 12.0541 5.1156 12.0862 5.03543L12.842 3.14567C13.0626 2.59436 13.1728 2.31869 13.1269 2.09741C13.0867 1.9039 12.9717 1.73408 12.8069 1.62488C12.6185 1.5 12.3217 1.5 11.7279 1.5H6.27276C5.67897 1.5 5.38208 1.5 5.1937 1.62488C5.02896 1.73408 4.91399 1.9039 4.87378 2.09741C4.8278 2.31869 4.93806 2.59436 5.15859 3.14567L5.91449 5.03543C5.94656 5.1156 5.96259 5.15568 5.97387 5.19703C5.98389 5.23375 5.9911 5.27119 5.99544 5.30901C6.00032 5.35158 6.00032 5.39476 6.00032 5.4811Z"
    fill="currentColor"
  />
  <path
    d="M9.0003 11.25V16.5M6.00032 5.4811V7.07906C6.00032 7.23508 6.00032 7.31308 5.985 7.38769C5.97142 7.45389 5.94895 7.51793 5.91821 7.57815C5.88355 7.64595 5.83482 7.70685 5.73736 7.82873L4.56003 9.30038C4.06072 9.92453 3.81107 10.2365 3.81079 10.4992C3.81054 10.7276 3.91439 10.9437 4.0929 11.0861C4.29816 11.25 4.69779 11.25 5.49707 11.25H12.5035C13.3028 11.25 13.7025 11.25 13.9078 11.0861C14.0863 10.9437 14.1901 10.7276 14.1898 10.4992C14.1895 10.2365 13.9399 9.92453 13.4406 9.30038L12.2632 7.82873C12.1658 7.70685 12.1171 7.64595 12.0824 7.57815C12.0517 7.51793 12.0292 7.45389 12.0156 7.38769C12.0003 7.31308 12.0003 7.23508 12.0003 7.07906V5.4811C12.0003 5.39476 12.0003 5.35158 12.0052 5.30901C12.0095 5.27119 12.0167 5.23375 12.0268 5.19703C12.038 5.15568 12.0541 5.1156 12.0862 5.03543L12.842 3.14567C13.0626 2.59436 13.1728 2.31869 13.1269 2.09741C13.0867 1.9039 12.9717 1.73408 12.8069 1.62488C12.6185 1.5 12.3217 1.5 11.7279 1.5H6.27276C5.67897 1.5 5.38208 1.5 5.1937 1.62488C5.02896 1.73408 4.91399 1.9039 4.87378 2.09741C4.8278 2.31869 4.93806 2.59436 5.15859 3.14567L5.91449 5.03543C5.94656 5.1156 5.96259 5.15568 5.97387 5.19703C5.98389 5.23375 5.9911 5.27119 5.99544 5.30901C6.00032 5.35158 6.00032 5.39476 6.00032 5.4811Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  play: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3.75 3.74213C3.75 3.01376 3.75 2.64958 3.90187 2.44882C4.03417 2.27393 4.23639 2.16571 4.4553 2.15263C4.70658 2.13763 5.0096 2.33965 5.61564 2.74367L13.5023 8.00145C14.0031 8.33527 14.2534 8.50222 14.3407 8.7126C14.417 8.89657 14.417 9.10327 14.3407 9.28725C14.2534 9.49762 14.0031 9.6645 13.5023 9.9984L5.61564 15.2561C5.0096 15.6601 4.70658 15.8622 4.4553 15.8472C4.23639 15.8342 4.03417 15.7259 3.90187 15.551C3.75 15.3502 3.75 14.986 3.75 14.2577V3.74213Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  plus: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 3.75V14.25M3.75 9H14.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  progressBar: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.6 13.5H13.15C14.4101 13.5 15.0401 13.5 15.5215 13.2548C15.9449 13.0391 16.2891 12.6949 16.5048 12.2715C16.75 11.7901 16.75 11.1601 16.75 9.9V8.1C16.75 6.83988 16.75 6.20982 16.5048 5.72852C16.2891 5.30516 15.9449 4.96095 15.5215 4.74524C15.0401 4.5 14.4101 4.5 13.15 4.5H5.6C4.33988 4.5 3.70982 4.5 3.22852 4.74524C2.80516 4.96095 2.46095 5.30516 2.24524 5.72852C2 6.20982 2 6.83988 2 8.1V9.9C2 11.1601 2 11.7901 2.24524 12.2715C2.46095 12.6949 2.80516 13.0391 3.22852 13.2548C3.70982 13.5 4.33988 13.5 5.6 13.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M3.5 7C3.5 6.44772 3.94772 6 4.5 6H9.5C10.0523 6 10.5 6.44772 10.5 7V11C10.5 11.5523 10.0523 12 9.5 12H4.5C3.94772 12 3.5 11.5523 3.5 11V7Z"
    fill="currentColor"
  />
</svg>`,
  refreshAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M16.5 7.5C16.5 7.5 14.9963 5.45116 13.7747 4.22868C12.553 3.0062 10.8648 2.25 9 2.25C5.27208 2.25 2.25 5.27208 2.25 9C2.25 12.728 5.27208 15.75 9 15.75C12.0773 15.75 14.6737 13.6907 15.4862 10.875M16.5 7.5V3M16.5 7.5H12"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  refresh: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M1.5 7.5C1.5 7.5 3.00374 5.45116 4.22538 4.22868C5.44702 3.0062 7.1352 2.25 9 2.25C12.728 2.25 15.75 5.27208 15.75 9C15.75 12.728 12.728 15.75 9 15.75C5.92268 15.75 3.32633 13.6907 2.51383 10.875M1.5 7.5V3M1.5 7.5H6"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  repeat: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 1.5L15.75 4.5M15.75 4.5L12.75 7.5M15.75 4.5H5.85C4.58988 4.5 3.95982 4.5 3.47852 4.74524C3.05516 4.96095 2.71095 5.30516 2.49524 5.72852C2.25 6.20982 2.25 6.83988 2.25 8.1V8.25M2.25 13.5H12.15C13.4102 13.5 14.0401 13.5 14.5215 13.2548C14.9449 13.0391 15.2891 12.6949 15.5048 12.2715C15.75 11.7901 15.75 11.1601 15.75 9.9V9.75M2.25 13.5L5.25 16.5M2.25 13.5L5.25 10.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  rocket: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 11.2498L6.75 8.99985M9 11.2498C10.0476 10.8514 11.0527 10.3489 12 9.74985M9 11.2498V14.9998C9 14.9998 11.2725 14.5873 12 13.4998C12.81 12.2848 12 9.74985 12 9.74985M6.75 8.99985C7.14911 7.9644 7.65165 6.97186 8.25 6.03732C9.1239 4.64006 10.3407 3.48961 11.7848 2.69539C13.2288 1.90117 14.852 1.4896 16.5 1.49982C16.5 3.53982 15.915 7.12482 12 9.74985M6.75 8.99985H3C3 8.99985 3.4125 6.72732 4.5 5.99982C5.715 5.18982 8.25 5.99982 8.25 5.99982M3.375 12.3748C2.25 13.3198 1.875 16.1248 1.875 16.1248C1.875 16.1248 4.68 15.7498 5.625 14.6248C6.1575 13.9948 6.15 13.0273 5.5575 12.4423C5.26598 12.1641 4.88197 12.0033 4.47917 11.9908C4.07637 11.9784 3.68316 12.1151 3.375 12.3748Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  rotatingSpinner: t`
<svg 
  width="24" 
  height="24" 
  viewBox="0 0 24 24" 
  xmlns="http://www.w3.org/2000/svg"
>
  <path d="M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,19a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z" opacity=".25" fill="currentColor"/>
    <path fill="currentColor" d="M10.14,1.16a11,11,0,0,0-9,8.92A1.59,1.59,0,0,0,2.46,12,1.52,1.52,0,0,0,4.11,10.7a8,8,0,0,1,6.66-6.61A1.42,1.42,0,0,0,12,2.69h0A1.57,1.57,0,0,0,10.14,1.16Z">
    <animateTransform attributeName="transform" type="rotate" dur="0.75s" values="0 12 12;360 12 12" repeatCount="indefinite"/>
  </path>
 </svg>`,
  save: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 2.25V4.8C5.25 5.22004 5.25 5.43006 5.33174 5.59049C5.40365 5.73161 5.51839 5.84635 5.65951 5.91826C5.81994 6 6.02996 6 6.45 6H11.55C11.9701 6 12.1801 6 12.3405 5.91826C12.4817 5.84635 12.5963 5.73161 12.6683 5.59049C12.75 5.43006 12.75 5.22004 12.75 4.8V3M12.75 15.75V10.95C12.75 10.5299 12.75 10.3199 12.6683 10.1595C12.5963 10.0183 12.4817 9.90368 12.3405 9.83175C12.1801 9.75 11.9701 9.75 11.55 9.75H6.45C6.02996 9.75 5.81994 9.75 5.65951 9.83175C5.51839 9.90368 5.40365 10.0183 5.33174 10.1595C5.25 10.3199 5.25 10.5299 5.25 10.95V15.75M15.75 6.99411V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25H11.0059C11.3728 2.25 11.5562 2.25 11.7289 2.29144C11.8819 2.32819 12.0282 2.38879 12.1625 2.47104C12.3138 2.5638 12.4435 2.69351 12.703 2.95294L15.047 5.29705C15.3065 5.55649 15.4362 5.6862 15.529 5.83757C15.6112 5.97178 15.6718 6.11809 15.7085 6.27115C15.75 6.44378 15.75 6.62723 15.75 6.99411Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  scatterPlot: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.75 15.75C11.925 15.75 11.2188 15.4563 10.6313 14.8688C10.0438 14.2813 9.75 13.575 9.75 12.75C9.75 11.925 10.0438 11.2188 10.6313 10.6313C11.2188 10.0438 11.925 9.75 12.75 9.75C13.575 9.75 14.2813 10.0438 14.8688 10.6313C15.4563 11.2188 15.75 11.925 15.75 12.75C15.75 13.575 15.4563 14.2813 14.8688 14.8688C14.2813 15.4563 13.575 15.75 12.75 15.75ZM12.75 14.25C13.1625 14.25 13.5156 14.1031 13.8094 13.8094C14.1031 13.5156 14.25 13.1625 14.25 12.75C14.25 12.3375 14.1031 11.9844 13.8094 11.6906C13.5156 11.3969 13.1625 11.25 12.75 11.25C12.3375 11.25 11.9844 11.3969 11.6906 11.6906C11.3969 11.9844 11.25 12.3375 11.25 12.75C11.25 13.1625 11.3969 13.5156 11.6906 13.8094C11.9844 14.1031 12.3375 14.25 12.75 14.25ZM5.25 13.5C4.425 13.5 3.71875 13.2063 3.13125 12.6188C2.54375 12.0313 2.25 11.325 2.25 10.5C2.25 9.675 2.54375 8.96875 3.13125 8.38125C3.71875 7.79375 4.425 7.5 5.25 7.5C6.075 7.5 6.78125 7.79375 7.36875 8.38125C7.95625 8.96875 8.25 9.675 8.25 10.5C8.25 11.325 7.95625 12.0313 7.36875 12.6188C6.78125 13.2063 6.075 13.5 5.25 13.5ZM5.25 12C5.6625 12 6.01563 11.8531 6.30938 11.5594C6.60313 11.2656 6.75 10.9125 6.75 10.5C6.75 10.0875 6.60313 9.73438 6.30938 9.44063C6.01563 9.14688 5.6625 9 5.25 9C4.8375 9 4.48438 9.14688 4.19063 9.44063C3.89688 9.73438 3.75 10.0875 3.75 10.5C3.75 10.9125 3.89688 11.2656 4.19063 11.5594C4.48438 11.8531 4.8375 12 5.25 12ZM8.25 7.5C7.425 7.5 6.71875 7.20625 6.13125 6.61875C5.54375 6.03125 5.25 5.325 5.25 4.5C5.25 3.675 5.54375 2.96875 6.13125 2.38125C6.71875 1.79375 7.425 1.5 8.25 1.5C9.075 1.5 9.78125 1.79375 10.3688 2.38125C10.9563 2.96875 11.25 3.675 11.25 4.5C11.25 5.325 10.9563 6.03125 10.3688 6.61875C9.78125 7.20625 9.075 7.5 8.25 7.5ZM8.25 6C8.6625 6 9.01563 5.85313 9.30938 5.55938C9.60313 5.26563 9.75 4.9125 9.75 4.5C9.75 4.0875 9.60313 3.73438 9.30938 3.44063C9.01563 3.14688 8.6625 3 8.25 3C7.8375 3 7.48438 3.14688 7.19063 3.44063C6.89688 3.73438 6.75 4.0875 6.75 4.5C6.75 4.9125 6.89688 5.26563 7.19063 5.55938C7.48438 5.85313 7.8375 6 8.25 6Z" fill="currentColor"/>
</svg>`,
  search: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 15.75L11.2501 11.25M12.75 7.5C12.75 10.3995 10.3995 12.75 7.5 12.75C4.60051 12.75 2.25 10.3995 2.25 7.5C2.25 4.60051 4.60051 2.25 7.5 2.25C10.3995 2.25 12.75 4.60051 12.75 7.5Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  send: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M7.87462 10.1251L15.7496 2.25007M7.97032 10.3711L9.9414 15.4396C10.115 15.8862 10.2019 16.1094 10.327 16.1745C10.4354 16.2311 10.5646 16.2312 10.6731 16.1748C10.7983 16.1097 10.8854 15.8866 11.0596 15.4403L16.0023 2.77447C16.1596 2.37158 16.2382 2.17014 16.1951 2.04142C16.1578 1.92963 16.0701 1.8419 15.9583 1.80456C15.8296 1.76156 15.6281 1.84017 15.2252 1.99739L2.55943 6.94015C2.11312 7.11432 1.88998 7.2014 1.82494 7.32658C1.76857 7.43509 1.76864 7.5643 1.82515 7.67275C1.89032 7.79785 2.11358 7.88463 2.56009 8.05833L7.62862 10.0294C7.71922 10.0647 7.76452 10.0823 7.8027 10.1095C7.83652 10.1336 7.86607 10.1632 7.89022 10.197C7.91745 10.2351 7.93507 10.2805 7.97032 10.3711Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  settings: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_881_4245)">
    <path
      d="M9 11.25C10.2427 11.25 11.25 10.2427 11.25 9C11.25 7.75732 10.2427 6.75 9 6.75C7.75732 6.75 6.75 7.75732 6.75 9C6.75 10.2427 7.75732 11.25 9 11.25Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
    <path
      d="M14.0455 11.0455C13.9547 11.2511 13.9277 11.4792 13.9677 11.7004C14.0078 11.9216 14.1133 12.1257 14.2705 12.2863L14.3114 12.3273C14.4382 12.4539 14.5387 12.6043 14.6074 12.7699C14.676 12.9354 14.7113 13.1129 14.7113 13.292C14.7113 13.4713 14.676 13.6487 14.6074 13.8143C14.5387 13.9798 14.4382 14.1301 14.3114 14.2568C14.1848 14.3836 14.0343 14.4841 13.8688 14.5528C13.7032 14.6214 13.5258 14.6567 13.3466 14.6567C13.1674 14.6567 12.9899 14.6214 12.8244 14.5528C12.6589 14.4841 12.5085 14.3836 12.3818 14.2568L12.3409 14.2159C12.1802 14.0588 11.9761 13.9533 11.755 13.9132C11.5338 13.873 11.3057 13.9001 11.1 13.9909C10.8983 14.0773 10.7263 14.2208 10.6052 14.4037C10.4841 14.5867 10.4191 14.801 10.4182 15.0205V15.1364C10.4182 15.498 10.2746 15.8449 10.0188 16.1006C9.76305 16.3563 9.41617 16.5 9.05452 16.5C8.69287 16.5 8.34607 16.3563 8.09032 16.1006C7.83457 15.8449 7.69088 15.498 7.69088 15.1364V15.075C7.68563 14.8493 7.61257 14.6305 7.48126 14.4469C7.34993 14.2632 7.16641 14.1234 6.95455 14.0455C6.7489 13.9547 6.52078 13.9277 6.2996 13.9677C6.07842 14.0078 5.87433 14.1133 5.71363 14.2705L5.67273 14.3114C5.54609 14.4382 5.39569 14.5387 5.23015 14.6074C5.0646 14.676 4.88716 14.7113 4.70795 14.7113C4.52875 14.7113 4.3513 14.676 4.18576 14.6074C4.02022 14.5387 3.86983 14.4382 3.74318 14.3114C3.6164 14.1848 3.51581 14.0343 3.4472 13.8688C3.37857 13.7032 3.34325 13.5258 3.34325 13.3466C3.34325 13.1674 3.37857 12.9899 3.4472 12.8244C3.51581 12.6589 3.6164 12.5085 3.74318 12.3818L3.78409 12.3409C3.94127 12.1802 4.04672 11.9761 4.08683 11.755C4.12693 11.5338 4.09985 11.3057 4.00909 11.1C3.92266 10.8983 3.77915 10.7263 3.59623 10.6052C3.4133 10.4841 3.19894 10.4191 2.97955 10.4182H2.86364C2.50198 10.4182 2.15513 10.2746 1.8994 10.0188C1.64367 9.76305 1.5 9.41617 1.5 9.05452C1.5 8.69287 1.64367 8.34607 1.8994 8.09032C2.15513 7.83457 2.50198 7.69088 2.86364 7.69088H2.925C3.15068 7.68563 3.36955 7.61257 3.55315 7.48126C3.73677 7.34993 3.87662 7.16641 3.95455 6.95455C4.0453 6.7489 4.07238 6.52078 4.03228 6.2996C3.99217 6.07842 3.88673 5.87433 3.72955 5.71363L3.68863 5.67273C3.56185 5.54609 3.46127 5.39569 3.39265 5.23015C3.32402 5.0646 3.2887 4.88716 3.2887 4.70795C3.2887 4.52875 3.32402 4.3513 3.39265 4.18576C3.46127 4.02022 3.56185 3.86983 3.68863 3.74318C3.81528 3.6164 3.96568 3.51581 4.13122 3.4472C4.29676 3.37857 4.47421 3.34325 4.65341 3.34325C4.83261 3.34325 5.01006 3.37857 5.1756 3.4472C5.34114 3.51581 5.49154 3.6164 5.61818 3.74318L5.65909 3.78409C5.81978 3.94127 6.02387 4.04672 6.24506 4.08683C6.46623 4.12693 6.69435 4.09985 6.9 4.00909H6.95455C7.15621 3.92266 7.3282 3.77915 7.44934 3.59623C7.5705 3.4133 7.63552 3.19894 7.63635 2.97955V2.86364C7.63635 2.50198 7.78005 2.15513 8.0358 1.8994C8.29148 1.64367 8.63835 1.5 9 1.5C9.36165 1.5 9.70852 1.64367 9.9642 1.8994C10.2199 2.15513 10.3637 2.50198 10.3637 2.86364V2.925C10.3645 3.1444 10.4295 3.35875 10.5507 3.54168C10.6718 3.7246 10.8438 3.86812 11.0455 3.95455C11.2511 4.0453 11.4792 4.07238 11.7004 4.03228C11.9216 3.99217 12.1257 3.88673 12.2863 3.72955L12.3273 3.68863C12.4539 3.56185 12.6043 3.46127 12.7699 3.39265C12.9354 3.32402 13.1129 3.2887 13.292 3.2887C13.4713 3.2887 13.6487 3.32402 13.8143 3.39265C13.9798 3.46127 14.1301 3.56185 14.2568 3.68863C14.3836 3.81528 14.4841 3.96568 14.5528 4.13122C14.6214 4.29676 14.6567 4.47421 14.6567 4.65341C14.6567 4.83261 14.6214 5.01006 14.5528 5.1756C14.4841 5.34114 14.3836 5.49154 14.2568 5.61818L14.2159 5.65909C14.0588 5.81978 13.9533 6.02387 13.9132 6.24506C13.873 6.46623 13.9001 6.69435 13.9909 6.9V6.95455C14.0773 7.15621 14.2208 7.3282 14.4037 7.44934C14.5867 7.5705 14.801 7.63552 15.0205 7.63635H15.1364C15.498 7.63635 15.8449 7.78005 16.1006 8.0358C16.3563 8.29148 16.5 8.63835 16.5 9C16.5 9.36165 16.3563 9.70852 16.1006 9.9642C15.8449 10.2199 15.498 10.3637 15.1364 10.3637H15.075C14.8556 10.3645 14.6413 10.4295 14.4583 10.5507C14.2754 10.6718 14.1319 10.8438 14.0455 11.0455Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_881_4245">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  share: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15.75 6.75001V2.25001M15.75 2.25001H11.25M15.75 2.25001L9 9M7.5 2.25H5.85C4.58988 2.25 3.95982 2.25 3.47852 2.49524C3.05516 2.71095 2.71095 3.05516 2.49524 3.47852C2.25 3.95982 2.25 4.58988 2.25 5.85V12.15C2.25 13.4102 2.25 14.0401 2.49524 14.5215C2.71095 14.9449 3.05516 15.2891 3.47852 15.5048C3.95982 15.75 4.58988 15.75 5.85 15.75H12.15C13.4102 15.75 14.0401 15.75 14.5215 15.5048C14.9449 15.2891 15.2891 14.9449 15.5048 14.5215C15.75 14.0401 15.75 13.4102 15.75 12.15V10.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  shieldTick: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 8.62493L8.25 10.1249L11.625 6.74991M15 8.99993C15 12.6812 10.9845 15.3587 9.5235 16.211C9.35745 16.3079 9.27442 16.3564 9.15727 16.3815C9.0663 16.401 8.9337 16.401 8.84273 16.3815C8.72558 16.3564 8.64255 16.3079 8.4765 16.211C7.01547 15.3587 3 12.6812 3 8.99993V5.41311C3 4.81347 3 4.51365 3.09807 4.25593C3.1847 4.02826 3.32548 3.82512 3.50824 3.66405C3.71513 3.48174 3.99585 3.37647 4.5573 3.16592L8.57865 1.65791C8.73457 1.59944 8.8125 1.5702 8.89275 1.55862C8.96385 1.54833 9.03615 1.54833 9.10725 1.55862C9.1875 1.5702 9.26543 1.59944 9.42135 1.65791L13.4427 3.16592C14.0041 3.37647 14.2849 3.48174 14.4917 3.66405C14.6745 3.82512 14.8153 4.02826 14.9019 4.25593C15 4.51365 15 4.81347 15 5.41311V8.99993Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  shoppingCart: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1795_16059)">
    <path
      d="M3.75011 10.5H13.6019C14.3615 10.5 14.7413 10.5 15.0437 10.3584C15.3101 10.2336 15.5338 10.0333 15.6872 9.7824C15.8614 9.49747 15.9033 9.12 15.9872 8.36505L16.426 4.41626C16.4516 4.18566 16.4644 4.07036 16.4273 3.98112C16.3948 3.90274 16.3366 3.83773 16.2623 3.79671C16.1777 3.75 16.0616 3.75 15.8296 3.75H3.37511M1.5 1.5H2.43633C2.6348 1.5 2.73403 1.5 2.81167 1.53774C2.88001 1.57097 2.93666 1.62418 2.97408 1.69032C3.01659 1.76546 3.02278 1.86449 3.03516 2.06257L3.71484 12.9374C3.72722 13.1355 3.73341 13.2346 3.77592 13.3096C3.81335 13.3758 3.86999 13.429 3.93833 13.4623C4.01597 13.5 4.11521 13.5 4.31367 13.5H14.25M5.625 16.125H5.6325M12.375 16.125H12.3825M6 16.125C6 16.3321 5.83211 16.5 5.625 16.5C5.41789 16.5 5.25 16.3321 5.25 16.125C5.25 15.9179 5.41789 15.75 5.625 15.75C5.83211 15.75 6 15.9179 6 16.125ZM12.75 16.125C12.75 16.3321 12.5821 16.5 12.375 16.5C12.1679 16.5 12 16.3321 12 16.125C12 15.9179 12.1679 15.75 12.375 15.75C12.5821 15.75 12.75 15.9179 12.75 16.125Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1795_16059">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  slidersAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3.75 15.75V11.25M3.75 11.25C4.57843 11.25 5.25 10.5784 5.25 9.75C5.25 8.92155 4.57843 8.25 3.75 8.25C2.92157 8.25 2.25 8.92155 2.25 9.75C2.25 10.5784 2.92157 11.25 3.75 11.25ZM3.75 5.25V2.25M9 15.75V11.25M9 5.25V2.25M9 5.25C8.17155 5.25 7.5 5.92157 7.5 6.75C7.5 7.57845 8.17155 8.25 9 8.25C9.82845 8.25 10.5 7.57845 10.5 6.75C10.5 5.92157 9.82845 5.25 9 5.25ZM14.25 15.75V12.75M14.25 12.75C15.0784 12.75 15.75 12.0784 15.75 11.25C15.75 10.4216 15.0784 9.75 14.25 9.75C13.4216 9.75 12.75 10.4216 12.75 11.25C12.75 12.0784 13.4216 12.75 14.25 12.75ZM14.25 6.75V2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  sliders: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3.75 15.75V10.5M3.75 7.5V2.25M9 15.75V9M9 6V2.25M14.25 15.75V12M14.25 9V2.25M1.5 10.5H6M6.75 6H11.25M12 12H16.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  spacingHeight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 13.5V4.5M9 13.5L6.75 12M9 13.5L11.25 12M9 4.5L6.75 6M9 4.5L11.25 6M15.75 2.25H2.25M15.75 15.75H2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  spacingWidth: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 9H13.5M4.5 9L6 6.75M4.5 9L6 11.25M13.5 9L12 6.75M13.5 9L12 11.25M15.75 15.75V2.25M2.25 15.75V2.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  speed: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.8375 11.625C8.1375 11.925 8.525 12.0719 9 12.0656C9.475 12.0594 9.825 11.8875 10.05 11.55L14.25 5.25L7.95 9.45C7.6125 9.675 7.43438 10.0188 7.41563 10.4813C7.39688 10.9438 7.5375 11.325 7.8375 11.625ZM9 3C9.7375 3 10.4469 3.10313 11.1281 3.30938C11.8094 3.51563 12.45 3.825 13.05 4.2375L11.625 5.1375C11.2125 4.925 10.7844 4.76563 10.3406 4.65938C9.89688 4.55313 9.45 4.5 9 4.5C7.3375 4.5 5.92188 5.08438 4.75313 6.25313C3.58438 7.42188 3 8.8375 3 10.5C3 11.025 3.07188 11.5438 3.21563 12.0563C3.35938 12.5688 3.5625 13.05 3.825 13.5H14.175C14.4625 13.025 14.6719 12.5313 14.8031 12.0188C14.9344 11.5063 15 10.975 15 10.425C15 9.975 14.9469 9.5375 14.8406 9.1125C14.7344 8.6875 14.575 8.275 14.3625 7.875L15.2625 6.45C15.6375 7.0375 15.9344 7.6625 16.1531 8.325C16.3719 8.9875 16.4875 9.675 16.5 10.3875C16.5125 11.1 16.4313 11.7813 16.2563 12.4313C16.0813 13.0813 15.825 13.7 15.4875 14.2875C15.35 14.5125 15.1625 14.6875 14.925 14.8125C14.6875 14.9375 14.4375 15 14.175 15H3.825C3.5625 15 3.3125 14.9375 3.075 14.8125C2.8375 14.6875 2.65 14.5125 2.5125 14.2875C2.1875 13.725 1.9375 13.1281 1.7625 12.4969C1.5875 11.8656 1.5 11.2 1.5 10.5C1.5 9.4625 1.69688 8.49063 2.09063 7.58438C2.48438 6.67813 3.02188 5.88438 3.70313 5.20313C4.38438 4.52188 5.18125 3.98438 6.09375 3.59063C7.00625 3.19688 7.975 3 9 3Z" fill="currentColor"/>
</svg>`,
  square45: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3.16846 11.1685C2.40943 10.4094 2.02991 10.0299 1.88772 9.59228C1.76264 9.20733 1.76264 8.79267 1.88772 8.40772C2.02991 7.97009 2.40943 7.59057 3.16846 6.83154L6.96327 3.03673C7.72232 2.27768 8.1018 1.8982 8.53946 1.75598C8.92441 1.63089 9.33906 1.63091 9.724 1.756C10.1616 1.89818 10.5412 2.2777 11.3002 3.03673L15.095 6.83154C15.854 7.59059 16.2335 7.97007 16.3757 8.40774C16.5008 8.79269 16.5008 9.20731 16.3757 9.59226C16.2335 10.0299 15.854 10.4094 15.095 11.1685L11.3002 14.9633C10.5412 15.7223 10.1616 16.1018 9.724 16.244C9.33906 16.3691 8.92441 16.3691 8.53946 16.244C8.1018 16.1018 7.72232 15.7223 6.96327 14.9633L3.16846 11.1685Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  square: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  star: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.46202 2.58999C8.63482 2.23979 8.7213 2.06469 8.8386 2.00874C8.94067 1.96006 9.05932 1.96006 9.1614 2.00874C9.27877 2.06469 9.36517 2.23979 9.53805 2.58999L11.1781 5.91246C11.2291 6.01585 11.2546 6.06755 11.2918 6.10769C11.3249 6.14322 11.3645 6.17202 11.4085 6.19247C11.4582 6.21557 11.5152 6.22391 11.6293 6.24058L15.2977 6.77679C15.6841 6.83325 15.8772 6.86148 15.9666 6.95583C16.0444 7.03792 16.0809 7.15073 16.0661 7.26283C16.0491 7.39169 15.9093 7.5279 15.6296 7.8003L12.976 10.3848C12.8934 10.4654 12.852 10.5057 12.8253 10.5536C12.8017 10.596 12.7865 10.6427 12.7807 10.6909C12.7741 10.7453 12.7838 10.8023 12.8033 10.916L13.4295 14.5666C13.4955 14.9516 13.5285 15.1442 13.4665 15.2584C13.4125 15.3578 13.3165 15.4275 13.2053 15.4481C13.0774 15.4718 12.9046 15.3809 12.5588 15.1991L9.2793 13.4744C9.17707 13.4207 9.126 13.3938 9.07215 13.3832C9.02452 13.3739 8.97547 13.3739 8.92785 13.3832C8.874 13.3938 8.82292 13.4207 8.72077 13.4744L5.44119 15.1991C5.09544 15.3809 4.92256 15.4718 4.79473 15.4481C4.68351 15.4275 4.58754 15.3578 4.53355 15.2584C4.4715 15.1442 4.50452 14.9516 4.57055 14.5666L5.19667 10.916C5.21618 10.8023 5.22594 10.7453 5.21934 10.6909C5.21349 10.6427 5.19833 10.596 5.17471 10.5536C5.14801 10.5057 5.10666 10.4654 5.02394 10.3848L2.37042 7.8003C2.09074 7.5279 1.9509 7.39169 1.93389 7.26283C1.91909 7.15073 1.95566 7.03792 2.03343 6.95583C2.12283 6.86148 2.31597 6.83325 2.70228 6.77679L6.37073 6.24058C6.48481 6.22391 6.54186 6.21557 6.59154 6.19247C6.63552 6.17202 6.67512 6.14322 6.70814 6.10769C6.74543 6.06755 6.77095 6.01585 6.82198 5.91246L8.46202 2.58999Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  starsAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1575_27482)">
    <path
      d="M3.375 16.5V12.75M3.375 5.25V1.5M1.5 3.375H5.25M1.5 14.625H5.25M9.75 2.25L8.44935 5.63165C8.23785 6.18157 8.1321 6.45653 7.96762 6.68782C7.8219 6.8928 7.6428 7.07189 7.43782 7.21765C7.20653 7.3821 6.93157 7.48786 6.38164 7.69935L3 9L6.38164 10.3006C6.93157 10.5121 7.20653 10.6179 7.43782 10.7824C7.6428 10.9281 7.8219 11.1072 7.96762 11.3122C8.1321 11.5435 8.23785 11.8184 8.44935 12.3683L9.75 15.75L11.0506 12.3683C11.2621 11.8184 11.3679 11.5435 11.5324 11.3122C11.6781 11.1072 11.8572 10.9281 12.0622 10.7824C12.2935 10.6179 12.5684 10.5121 13.1183 10.3006L16.5 9L13.1183 7.69935C12.5684 7.48786 12.2935 7.3821 12.0622 7.21765C11.8572 7.07189 11.6781 6.8928 11.5324 6.68782C11.3679 6.45653 11.2621 6.18157 11.0506 5.63165L9.75 2.25Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1575_27482">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  stars: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_1575_27478)">
    <path
      d="M4.875 9.75L5.46335 10.9267C5.66246 11.3249 5.76202 11.524 5.89502 11.6965C6.01304 11.8497 6.15031 11.9869 6.30341 12.105C6.47596 12.238 6.67507 12.3376 7.07331 12.5366L8.25 13.125L7.07331 13.7134C6.67507 13.9124 6.47596 14.012 6.30341 14.145C6.15031 14.2631 6.01304 14.4003 5.89502 14.5535C5.76202 14.726 5.66246 14.9251 5.46335 15.3233L4.875 16.5L4.28665 15.3233C4.08754 14.9251 3.98798 14.726 3.85498 14.5535C3.73696 14.4003 3.59969 14.2631 3.44659 14.145C3.27403 14.012 3.07492 13.9124 2.67669 13.7134L1.5 13.125L2.67669 12.5366C3.07492 12.3376 3.27403 12.238 3.44659 12.105C3.59969 11.9869 3.73696 11.8497 3.85498 11.6965C3.98798 11.524 4.08754 11.3249 4.28665 10.9267L4.875 9.75Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
    <path
      d="M11.25 1.5L12.134 3.79832C12.3455 4.34824 12.4512 4.6232 12.6157 4.85448C12.7615 5.05946 12.9405 5.23856 13.1455 5.38432C13.3768 5.54877 13.6518 5.65453 14.2017 5.86604L16.5 6.75L14.2017 7.63395C13.6518 7.84545 13.3768 7.9512 13.1455 8.11567C12.9405 8.26147 12.7615 8.4405 12.6157 8.64555C12.4512 8.87678 12.3455 9.1518 12.134 9.7017L11.25 12L10.366 9.7017C10.1545 9.1518 10.0488 8.87678 9.88433 8.64555C9.73853 8.4405 9.5595 8.26147 9.35445 8.11567C9.12322 7.9512 8.8482 7.84545 8.2983 7.63395L6 6.75L8.2983 5.86604C8.8482 5.65453 9.12322 5.54877 9.35445 5.38432C9.5595 5.23856 9.73853 5.05946 9.88433 4.85448C10.0488 4.6232 10.1545 4.34824 10.366 3.79832L11.25 1.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
  </g>
  <defs>
    <clipPath id="clip0_1575_27478">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  stepper: t`<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.75 11.25C3.125 11.25 2.59375 11.0313 2.15625 10.5938C1.71875 10.1563 1.5 9.625 1.5 9C1.5 8.375 1.71875 7.84375 2.15625 7.40625C2.59375 6.96875 3.125 6.75 3.75 6.75C4.375 6.75 4.90625 6.96875 5.34375 7.40625C5.78125 7.84375 6 8.375 6 9C6 9.625 5.78125 10.1563 5.34375 10.5938C4.90625 11.0313 4.375 11.25 3.75 11.25ZM3.75 9.75C3.9625 9.75 4.14063 9.67813 4.28438 9.53438C4.42813 9.39063 4.5 9.2125 4.5 9C4.5 8.7875 4.42813 8.60938 4.28438 8.46563C4.14063 8.32188 3.9625 8.25 3.75 8.25C3.5375 8.25 3.35938 8.32188 3.21563 8.46563C3.07188 8.60938 3 8.7875 3 9C3 9.2125 3.07188 9.39063 3.21563 9.53438C3.35938 9.67813 3.5375 9.75 3.75 9.75ZM9 11.25C8.375 11.25 7.84375 11.0313 7.40625 10.5938C6.96875 10.1563 6.75 9.625 6.75 9C6.75 8.375 6.96875 7.84375 7.40625 7.40625C7.84375 6.96875 8.375 6.75 9 6.75C9.625 6.75 10.1563 6.96875 10.5938 7.40625C11.0313 7.84375 11.25 8.375 11.25 9C11.25 9.625 11.0313 10.1563 10.5938 10.5938C10.1563 11.0313 9.625 11.25 9 11.25ZM9 9.75C9.2125 9.75 9.39063 9.67813 9.53438 9.53438C9.67813 9.39063 9.75 9.2125 9.75 9C9.75 8.7875 9.67813 8.60938 9.53438 8.46563C9.39063 8.32188 9.2125 8.25 9 8.25C8.7875 8.25 8.60938 8.32188 8.46563 8.46563C8.32188 8.60938 8.25 8.7875 8.25 9C8.25 9.2125 8.32188 9.39063 8.46563 9.53438C8.60938 9.67813 8.7875 9.75 9 9.75ZM14.25 11.25C13.625 11.25 13.0938 11.0313 12.6563 10.5938C12.2188 10.1563 12 9.625 12 9C12 8.375 12.2188 7.84375 12.6563 7.40625C13.0938 6.96875 13.625 6.75 14.25 6.75C14.875 6.75 15.4063 6.96875 15.8438 7.40625C16.2813 7.84375 16.5 8.375 16.5 9C16.5 9.625 16.2813 10.1563 15.8438 10.5938C15.4063 11.0313 14.875 11.25 14.25 11.25Z" fill="currentColor"/>
</svg>`,
  stopCircle: t`<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <g clip-path="url(#clip0_2225_10319)">
    <path
      d="M9 16.5C13.1421 16.5 16.5 13.1421 16.5 9C16.5 4.85786 13.1421 1.5 9 1.5C4.85786 1.5 1.5 4.85786 1.5 9C1.5 13.1421 4.85786 16.5 9 16.5Z"
      stroke="currentColor"
      stroke-width="1.5"
      stroke-linecap="round"
      stroke-linejoin="round"
    />
    <rect
      x="5.25"
      y="5.25"
      width="7.5"
      height="7.5"
      rx="1.5"
      fill="currentColor"
    />
  </g>
  <defs>
    <clipPath id="clip0_2225_10319">
      <rect width="18" height="18" fill="white" />
    </clipPath>
  </defs>
</svg>`,
  switchOff: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M1.5 9C1.5 6.51472 3.51472 4.5 6 4.5H12C14.4853 4.5 16.5 6.51472 16.5 9C16.5 11.4853 14.4853 13.5 12 13.5H6C3.51472 13.5 1.5 11.4853 1.5 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M6 11.5C7.38071 11.5 8.5 10.3807 8.5 9C8.5 7.6193 7.38071 6.5 6 6.5C4.61929 6.5 3.5 7.6193 3.5 9C3.5 10.3807 4.61929 11.5 6 11.5Z"
    fill="currentColor"
  />
</svg>`,
  switchOn: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M1.5 9C1.5 6.51472 3.51472 4.5 6 4.5H12C14.4853 4.5 16.5 6.51472 16.5 9C16.5 11.4853 14.4853 13.5 12 13.5H6C3.51472 13.5 1.5 11.4853 1.5 9Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M12 11.5C13.3807 11.5 14.5 10.3807 14.5 9C14.5 7.6193 13.3807 6.5 12 6.5C10.6193 6.5 9.5 7.6193 9.5 9C9.5 10.3807 10.6193 11.5 12 11.5Z"
    fill="currentColor"
  />
</svg>`,
  tab: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 13.5H15V7.5H9.75V4.5H3V13.5ZM3 15C2.5875 15 2.23438 14.8531 1.94063 14.5594C1.64687 14.2656 1.5 13.9125 1.5 13.5V4.5C1.5 4.0875 1.64687 3.73438 1.94063 3.44063C2.23438 3.14687 2.5875 3 3 3H15C15.4125 3 15.7656 3.14687 16.0594 3.44063C16.3531 3.73438 16.5 4.0875 16.5 4.5V13.5C16.5 13.9125 16.3531 14.2656 16.0594 14.5594C15.7656 14.8531 15.4125 15 15 15H3Z"
    fill="currentColor"
  />
</svg>`,
  table: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 6.75H15.75M6.75 2.25V15.75M5.85 2.25H12.15C13.4102 2.25 14.0401 2.25 14.5215 2.49524C14.9449 2.71095 15.2891 3.05516 15.5048 3.47852C15.75 3.95982 15.75 4.58988 15.75 5.85V12.15C15.75 13.4102 15.75 14.0401 15.5048 14.5215C15.2891 14.9449 14.9449 15.2891 14.5215 15.5048C14.0401 15.75 13.4102 15.75 12.15 15.75H5.85C4.58988 15.75 3.95982 15.75 3.47852 15.5048C3.05516 15.2891 2.71095 14.9449 2.49524 14.5215C2.25 14.0401 2.25 13.4102 2.25 12.15V5.85C2.25 4.58988 2.25 3.95982 2.49524 3.47852C2.71095 3.05516 3.05516 2.71095 3.47852 2.49524C3.95982 2.25 4.58988 2.25 5.85 2.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  tag: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_2290_25895)">
<path d="M6 6H6.0075M1.5 3.9V7.25588C1.5 7.62278 1.5 7.80623 1.54144 7.97888C1.57819 8.13188 1.63879 8.2782 1.72104 8.41245C1.8138 8.5638 1.94351 8.69355 2.20294 8.95297L7.95442 14.7044C8.84542 15.5954 9.291 16.041 9.80467 16.2079C10.2566 16.3547 10.7434 16.3547 11.1953 16.2079C11.709 16.041 12.1546 15.5954 13.0456 14.7044L14.7044 13.0456C15.5954 12.1546 16.041 11.709 16.2079 11.1953C16.3547 10.7434 16.3547 10.2566 16.2079 9.80467C16.041 9.291 15.5954 8.84542 14.7044 7.95442L8.95297 2.20294C8.69355 1.94351 8.5638 1.8138 8.41245 1.72104C8.2782 1.63879 8.13188 1.57819 7.97888 1.54144C7.80623 1.5 7.62277 1.5 7.25589 1.5H3.9C3.05992 1.5 2.63988 1.5 2.31902 1.66349C2.03678 1.8073 1.8073 2.03677 1.66349 2.31902C1.5 2.63988 1.5 3.05992 1.5 3.9ZM6.375 6C6.375 6.20711 6.20711 6.375 6 6.375C5.79289 6.375 5.625 6.20711 5.625 6C5.625 5.79289 5.79289 5.625 6 5.625C6.20711 5.625 6.375 5.79289 6.375 6Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</g>
<defs>
<clipPath id="clip0_2290_25895">
<rect width="18" height="18" fill="white"/>
</clipPath>
</defs>
</svg>

  `,
  terminal: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 12.75L7.5 8.25L3 3.75M9 14.25H15"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  textInput: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9.75 5.25H3.9C3.05992 5.25 2.63988 5.25 2.31902 5.41349C2.03677 5.5573 1.8073 5.78677 1.66349 6.06902C1.5 6.38988 1.5 6.80992 1.5 7.65V10.35C1.5 11.1901 1.5 11.6101 1.66349 11.931C1.8073 12.2132 2.03677 12.4427 2.31902 12.5865C2.63988 12.75 3.05992 12.75 3.9 12.75H9.75M12.75 5.25H14.1C14.9401 5.25 15.3602 5.25 15.681 5.41349C15.9632 5.5573 16.1927 5.78677 16.3365 6.06902C16.5 6.38988 16.5 6.80992 16.5 7.65V10.35C16.5 11.1901 16.5 11.6101 16.3365 11.931C16.1927 12.2132 15.9632 12.4427 15.681 12.5865C15.3602 12.75 14.9401 12.75 14.1 12.75H12.75M12.75 15.75V2.25M14.625 2.25001L10.875 2.25M14.625 15.75H10.875"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  thumbsDownAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.7501 1.5V9.75V1.5ZM16.5001 7.35V3.9C16.5001 3.05992 16.5001 2.63988 16.3366 2.31901C16.1927 2.03677 15.9633 1.8073 15.681 1.66349C15.3602 1.5 14.9402 1.5 14.1001 1.5H6.08855C4.99244 1.5 4.44438 1.5 4.00172 1.70057C3.61159 1.87736 3.28001 2.16181 3.04597 2.52054C2.78042 2.92754 2.69708 3.46923 2.53041 4.55259L2.1381 7.10259C1.91828 8.53147 1.80836 9.24592 2.0204 9.80182C2.20649 10.2898 2.55653 10.6978 3.01049 10.9559C3.52769 11.25 4.25054 11.25 5.69624 11.25H6.30004C6.72008 11.25 6.9301 11.25 7.09053 11.3317C7.23166 11.4037 7.34639 11.5183 7.4183 11.6595C7.50008 11.8199 7.50008 12.0299 7.50008 12.45V14.6506C7.50008 15.672 8.328 16.5 9.34943 16.5C9.59303 16.5 9.81383 16.3565 9.91275 16.1339L12.4334 10.4626C12.548 10.2046 12.6053 10.0757 12.6959 9.98115C12.776 9.89752 12.8744 9.83362 12.9833 9.7944C13.1065 9.75 13.2476 9.75 13.5299 9.75H14.1001C14.9402 9.75 15.3602 9.75 15.681 9.5865C15.9633 9.44272 16.1927 9.21322 16.3366 8.931C16.5001 8.61015 16.5001 8.19007 16.5001 7.35Z"
    fill="currentColor"
  />
  <path
    d="M12.7501 1.5V9.75M16.5001 7.35V3.9C16.5001 3.05992 16.5001 2.63988 16.3366 2.31901C16.1927 2.03677 15.9633 1.8073 15.681 1.66349C15.3602 1.5 14.9402 1.5 14.1001 1.5H6.08855C4.99244 1.5 4.44438 1.5 4.00172 1.70057C3.61159 1.87736 3.28001 2.16181 3.04597 2.52054C2.78042 2.92754 2.69708 3.46923 2.53041 4.55259L2.1381 7.10259C1.91828 8.53147 1.80836 9.24592 2.0204 9.80182C2.20649 10.2898 2.55653 10.6978 3.01049 10.9559C3.52769 11.25 4.25054 11.25 5.69624 11.25H6.30004C6.72008 11.25 6.9301 11.25 7.09053 11.3317C7.23166 11.4037 7.34639 11.5183 7.4183 11.6595C7.50008 11.8199 7.50008 12.0299 7.50008 12.45V14.6506C7.50008 15.672 8.328 16.5 9.34943 16.5C9.59303 16.5 9.81383 16.3565 9.91275 16.1339L12.4334 10.4626C12.548 10.2046 12.6053 10.0757 12.6959 9.98115C12.776 9.89752 12.8744 9.83362 12.9833 9.7944C13.1065 9.75 13.2476 9.75 13.5299 9.75H14.1001C14.9402 9.75 15.3602 9.75 15.681 9.5865C15.9633 9.44272 16.1927 9.21322 16.3366 8.931C16.5001 8.61015 16.5001 8.19007 16.5001 7.35Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  thumbsDown: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.7501 1.5V9.75M16.5001 7.35V3.9C16.5001 3.05992 16.5001 2.63988 16.3366 2.31901C16.1927 2.03677 15.9633 1.8073 15.681 1.66349C15.3602 1.5 14.9402 1.5 14.1001 1.5H6.08855C4.99244 1.5 4.44438 1.5 4.00172 1.70057C3.61159 1.87736 3.28001 2.16181 3.04597 2.52054C2.78042 2.92754 2.69708 3.46923 2.53041 4.55259L2.1381 7.10259C1.91828 8.53147 1.80836 9.24592 2.0204 9.80182C2.20649 10.2898 2.55653 10.6978 3.01049 10.9559C3.52769 11.25 4.25054 11.25 5.69624 11.25H6.30004C6.72008 11.25 6.9301 11.25 7.09053 11.3317C7.23166 11.4037 7.34639 11.5183 7.4183 11.6595C7.50008 11.8199 7.50008 12.0299 7.50008 12.45V14.6506C7.50008 15.672 8.328 16.5 9.34943 16.5C9.59303 16.5 9.81383 16.3565 9.91275 16.1339L12.4334 10.4626C12.548 10.2046 12.6053 10.0757 12.6959 9.98115C12.776 9.89752 12.8744 9.83362 12.9833 9.7944C13.1065 9.75 13.2476 9.75 13.5299 9.75H14.1001C14.9402 9.75 15.3602 9.75 15.681 9.5865C15.9633 9.44272 16.1927 9.21322 16.3366 8.931C16.5001 8.61015 16.5001 8.19007 16.5001 7.35Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  thumbsUpAlt: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 16.5V8.25V16.5ZM1.5 9.75V15C1.5 15.8284 2.17157 16.5 3 16.5H13.0697C14.1803 16.5 15.1247 15.6898 15.2935 14.5921L16.1012 9.34215C16.3109 7.97917 15.2564 6.75 13.8774 6.75H11.25C10.8358 6.75 10.5 6.41421 10.5 6V3.34938C10.5 2.32799 9.672 1.5 8.65065 1.5C8.40697 1.5 8.18625 1.64348 8.08733 1.86609L5.44795 7.80457C5.32758 8.07547 5.05899 8.25 4.7626 8.25H3C2.17157 8.25 1.5 8.92155 1.5 9.75Z"
    fill="currentColor"
  />
  <path
    d="M5.25 16.5V8.25M1.5 9.75V15C1.5 15.8284 2.17157 16.5 3 16.5H13.0697C14.1803 16.5 15.1246 15.6898 15.2935 14.5921L16.1012 9.34215C16.3109 7.97917 15.2564 6.75 13.8774 6.75H11.25C10.8358 6.75 10.5 6.41421 10.5 6V3.34938C10.5 2.32799 9.672 1.5 8.65065 1.5C8.40697 1.5 8.18625 1.64348 8.08733 1.86609L5.44795 7.80457C5.32758 8.07547 5.05899 8.25 4.7626 8.25H3C2.17157 8.25 1.5 8.92155 1.5 9.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  thumbsUp: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 16.5V8.25M1.5 9.75V15C1.5 15.8284 2.17157 16.5 3 16.5H13.0697C14.1803 16.5 15.1246 15.6898 15.2935 14.5921L16.1012 9.34215C16.3109 7.97917 15.2564 6.75 13.8774 6.75H11.25C10.8358 6.75 10.5 6.41421 10.5 6V3.34938C10.5 2.32799 9.672 1.5 8.65065 1.5C8.40697 1.5 8.18625 1.64348 8.08733 1.86609L5.44795 7.80457C5.32758 8.07547 5.05899 8.25 4.7626 8.25H3C2.17157 8.25 1.5 8.92155 1.5 9.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  tool: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M4.5 4.5L7.875 7.875M4.5 4.5H2.25L1.5 2.25L2.25 1.5L4.5 2.25V4.5ZM14.4443 2.05576L12.4735 4.02647C12.1765 4.32349 12.028 4.47199 11.9724 4.64323C11.9234 4.79387 11.9234 4.95613 11.9724 5.10677C12.028 5.27801 12.1765 5.42651 12.4735 5.72353L12.6515 5.90147C12.9485 6.19849 13.097 6.34699 13.2682 6.40263C13.4188 6.45158 13.5812 6.45158 13.7318 6.40263C13.903 6.34699 14.0515 6.19849 14.3485 5.90147L16.192 4.05804C16.3905 4.54116 16.5 5.07029 16.5 5.625C16.5 7.9032 14.6532 9.75 12.375 9.75C12.1003 9.75 11.8319 9.72315 11.5724 9.67192C11.2077 9.60007 11.0254 9.56407 10.9149 9.5751C10.7974 9.5868 10.7395 9.60443 10.6354 9.66015C10.5374 9.71258 10.4392 9.81075 10.2427 10.0073L4.875 15.375C4.25368 15.9963 3.24632 15.9963 2.625 15.375C2.00368 14.7537 2.00368 13.7463 2.625 13.125L7.99275 7.75725C8.18925 7.56075 8.28742 7.46254 8.33985 7.36462C8.39557 7.26051 8.4132 7.2026 8.4249 7.08511C8.43593 6.97459 8.39993 6.79229 8.32808 6.42768C8.27685 6.16805 8.25 5.89966 8.25 5.625C8.25 3.34682 10.0968 1.5 12.375 1.5C13.1291 1.5 13.836 1.70236 14.4443 2.05576ZM9.00008 11.2499L13.125 15.3749C13.7463 15.9962 14.7537 15.9962 15.375 15.3749C15.9963 14.7536 15.9963 13.7462 15.375 13.1249L11.9815 9.73147C11.7412 9.70875 11.507 9.6654 11.2806 9.60323C10.9888 9.52313 10.6687 9.58132 10.4548 9.79522L9.00008 11.2499Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  topPanelOpen: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M9 12.375L12 9.375H6L9 12.375ZM3.75 15.75C3.3375 15.75 2.98438 15.6031 2.69063 15.3094C2.39687 15.0156 2.25 14.6625 2.25 14.25V3.75C2.25 3.3375 2.39687 2.98438 2.69063 2.69063C2.98438 2.39687 3.3375 2.25 3.75 2.25H14.25C14.6625 2.25 15.0156 2.39687 15.3094 2.69063C15.6031 2.98438 15.75 3.3375 15.75 3.75V14.25C15.75 14.6625 15.6031 15.0156 15.3094 15.3094C15.0156 15.6031 14.6625 15.75 14.25 15.75H3.75ZM14.25 6V3.75H3.75V6H14.25ZM3.75 7.5V14.25H14.25V7.5H3.75Z"
    fill="currentColor"
  />
</svg>`,
  touchApp: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M7.85623 16.5C7.50623 16.5 7.1781 16.425 6.87185 16.275C6.5656 16.125 6.30623 15.9125 6.09373 15.6375L2.00623 10.4438L2.36248 10.0688C2.61248 9.80625 2.91248 9.65 3.26248 9.6C3.61248 9.55 3.93748 9.61875 4.23748 9.80625L5.62498 10.65V4.5C5.62498 4.2875 5.69685 4.10938 5.8406 3.96563C5.98435 3.82188 6.16248 3.75 6.37498 3.75C6.58748 3.75 6.76873 3.82188 6.91873 3.96563C7.06873 4.10938 7.14373 4.2875 7.14373 4.5V13.35L5.32498 12.225L7.27498 14.7188C7.34998 14.8063 7.43748 14.875 7.53748 14.925C7.63748 14.975 7.74373 15 7.85623 15H12C12.4125 15 12.7656 14.8531 13.0594 14.5594C13.3531 14.2656 13.5 13.9125 13.5 13.5V10.5C13.5 10.2875 13.4281 10.1094 13.2844 9.96563C13.1406 9.82188 12.9625 9.75 12.75 9.75H8.64373V8.25H12.75C13.375 8.25 13.9062 8.46875 14.3437 8.90625C14.7812 9.34375 15 9.875 15 10.5V13.5C15 14.325 14.7062 15.0313 14.1187 15.6188C13.5312 16.2063 12.825 16.5 12 16.5H7.85623ZM3.13123 6.375C2.96873 6.1 2.84373 5.80313 2.75623 5.48438C2.66873 5.16563 2.62498 4.8375 2.62498 4.5C2.62498 3.4625 2.9906 2.57813 3.72185 1.84688C4.4531 1.11563 5.33748 0.75 6.37498 0.75C7.41248 0.75 8.29685 1.11563 9.0281 1.84688C9.75935 2.57813 10.125 3.4625 10.125 4.5C10.125 4.8375 10.0812 5.16563 9.99373 5.48438C9.90623 5.80313 9.78123 6.1 9.61873 6.375L8.32498 5.625C8.42498 5.45 8.49998 5.27188 8.54998 5.09063C8.59998 4.90938 8.62498 4.7125 8.62498 4.5C8.62498 3.875 8.40623 3.34375 7.96873 2.90625C7.53123 2.46875 6.99998 2.25 6.37498 2.25C5.74998 2.25 5.21873 2.46875 4.78123 2.90625C4.34373 3.34375 4.12498 3.875 4.12498 4.5C4.12498 4.7125 4.14998 4.90938 4.19998 5.09063C4.24998 5.27188 4.32498 5.45 4.42498 5.625L3.13123 6.375Z"
    fill="currentColor"
  />
</svg>`,
  trash: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M6.75 2.25H11.25M2.25 4.5H15.75M14.25 4.5L13.724 12.3895C13.6451 13.5731 13.6057 14.165 13.35 14.6138C13.1249 15.0089 12.7854 15.3265 12.3763 15.5248C11.9115 15.75 11.3183 15.75 10.132 15.75H7.86802C6.68168 15.75 6.08852 15.75 5.62376 15.5248C5.21457 15.3265 4.87507 15.0089 4.64998 14.6138C4.39433 14.165 4.35488 13.5731 4.27597 12.3895L3.75 4.5M7.5 7.875V11.625M10.5 7.875V11.625"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  trendUp: t`
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16.5 5.25L10.5986 11.1514C10.3016 11.4484 10.153 11.597 9.98175 11.6526C9.83115 11.7016 9.66885 11.7016 9.51825 11.6526C9.34702 11.597 9.19845 11.4484 8.90145 11.1514L6.84853 9.09855C6.55151 8.80155 6.40301 8.65297 6.23177 8.5974C6.08113 8.54842 5.91887 8.54842 5.76823 8.5974C5.59699 8.65297 5.44849 8.80155 5.15147 9.09855L1.5 12.75M16.5 5.25H11.25M16.5 5.25V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  triangle: t`
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.79264 13.5737L7.96133 2.91872C8.3022 2.32985 8.47268 2.03541 8.69513 1.93652C8.88908 1.85026 9.11055 1.85026 9.30458 1.93652C9.52695 2.03541 9.69743 2.32984 10.0383 2.91872L16.207 13.5737C16.5491 14.1647 16.7202 14.4602 16.6949 14.7027C16.6729 14.9142 16.562 15.1064 16.3901 15.2315C16.1928 15.3749 15.8514 15.3749 15.1685 15.3749H2.83115C2.14826 15.3749 1.80681 15.3749 1.6096 15.2315C1.43758 15.1064 1.32675 14.9142 1.30469 14.7027C1.27941 14.4602 1.45049 14.1647 1.79264 13.5737Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>`,
  type: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M3 5.25C3 4.55109 3 4.20164 3.11418 3.92597C3.26642 3.55844 3.55844 3.26642 3.92597 3.11418C4.20164 3 4.55109 3 5.25 3H12.75C13.4489 3 13.7984 3 14.0741 3.11418C14.4416 3.26642 14.7336 3.55844 14.8859 3.92597C15 4.20164 15 4.55109 15 5.25M6.75 15H11.25M9 3V15"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  unlock: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M5.25 8.25V6C5.25 3.92893 6.92894 2.25 9 2.25C10.8143 2.25 12.3275 3.53832 12.675 5.25M6.6 15.75H11.4C12.6602 15.75 13.2902 15.75 13.7715 15.5048C14.1949 15.2891 14.5391 14.9449 14.7548 14.5215C15 14.0401 15 13.4102 15 12.15V11.85C15 10.5899 15 9.95985 14.7548 9.4785C14.5391 9.05512 14.1949 8.71095 13.7715 8.49525C13.2902 8.25 12.6602 8.25 11.4 8.25H6.6C5.33988 8.25 4.70982 8.25 4.22852 8.49525C3.80516 8.71095 3.46095 9.05512 3.24524 9.4785C3 9.95985 3 10.5899 3 11.85V12.15C3 13.4102 3 14.0401 3.24524 14.5215C3.46095 14.9449 3.80516 15.2891 4.22852 15.5048C4.70982 15.75 5.33988 15.75 6.6 15.75Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  userLeft: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M14.25 15.75L12 13.5M12 13.5L14.25 11.25M12 13.5H16.5M9 11.625H5.625C4.57833 11.625 4.05499 11.625 3.62915 11.7542C2.67034 12.045 1.92003 12.7954 1.62918 13.7542C1.5 14.18 1.5 14.7033 1.5 15.75M10.875 5.625C10.875 7.48896 9.36398 9 7.5 9C5.63604 9 4.125 7.48896 4.125 5.625C4.125 3.76104 5.63604 2.25 7.5 2.25C9.36398 2.25 10.875 3.76104 10.875 5.625Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  userRight: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M14.25 15.75L16.5 13.5M16.5 13.5L14.25 11.25M16.5 13.5H12M9 11.625H5.625C4.57833 11.625 4.05499 11.625 3.62915 11.7542C2.67034 12.045 1.92003 12.7954 1.62918 13.7542C1.5 14.18 1.5 14.7033 1.5 15.75M10.875 5.625C10.875 7.48896 9.36398 9 7.5 9C5.63604 9 4.125 7.48896 4.125 5.625C4.125 3.76104 5.63604 2.25 7.5 2.25C9.36398 2.25 10.875 3.76104 10.875 5.625Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  userUp: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12 13.5L14.25 11.25M14.25 11.25L16.5 13.5M14.25 11.25V15.75M9 11.625H5.625C4.57833 11.625 4.05499 11.625 3.62915 11.7542C2.67034 12.045 1.92003 12.7954 1.62918 13.7542C1.5 14.18 1.5 14.7033 1.5 15.75M10.875 5.625C10.875 7.48896 9.36398 9 7.5 9C5.63604 9 4.125 7.48896 4.125 5.625C4.125 3.76104 5.63604 2.25 7.5 2.25C9.36398 2.25 10.875 3.76104 10.875 5.625Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  user: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15 15.75C15 14.7033 15 14.18 14.8708 13.7542C14.58 12.7954 13.8296 12.045 12.8708 11.7542C12.445 11.625 11.9217 11.625 10.875 11.625H7.125C6.07833 11.625 5.55499 11.625 5.12914 11.7542C4.17034 12.045 3.42003 12.7954 3.12918 13.7542C3 14.18 3 14.7033 3 15.75M12.375 5.625C12.375 7.48896 10.864 9 9 9C7.13604 9 5.625 7.48896 5.625 5.625C5.625 3.76104 7.13604 2.25 9 2.25C10.864 2.25 12.375 3.76104 12.375 5.625Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  users: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M16.5 15.75V14.25C16.5 12.8521 15.5439 11.6776 14.25 11.3445M11.625 2.46807C12.7244 2.91311 13.5 3.99098 13.5 5.25C13.5 6.50902 12.7244 7.58692 11.625 8.0319M12.75 15.75C12.75 14.3521 12.75 13.6533 12.5216 13.102C12.2171 12.3669 11.6331 11.7829 10.898 11.4784C10.3467 11.25 9.64785 11.25 8.25 11.25H6C4.60217 11.25 3.90326 11.25 3.35195 11.4784C2.61686 11.7829 2.03285 12.3669 1.72836 13.102C1.5 13.6533 1.5 14.3521 1.5 15.75M10.125 5.25C10.125 6.90686 8.78182 8.25 7.125 8.25C5.46814 8.25 4.125 6.90686 4.125 5.25C4.125 3.59314 5.46814 2.25 7.125 2.25C8.78182 2.25 10.125 3.59314 10.125 5.25Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  vaadinLogo: t`
<svg 
  width="18" 
  height="18" 
  viewBox="0 0 24 24" 
  fill="none" 
  xmlns="http://www.w3.org/2000/svg"
>
  <path 
    d="M3 3C2.55 3 2.25 3.3 2.25 3.75V5.625C2.25 7.05 3.45 8.25 4.875 8.25H10.1997C10.7997 8.25 11.25 8.70029 11.25 9.30029V9.75C11.25 10.2 11.55 10.5 12 10.5C12.45 10.5 12.75 10.2 12.75 9.75V9.30029C12.75 8.70029 13.2003 8.25 13.8003 8.25H19.125C20.55 8.25 21.75 7.05 21.75 5.625V3.75C21.75 3.3 21.45 3 21 3C20.55 3 20.25 3.3 20.25 3.75V4.19971C20.25 4.79971 19.7997 5.25 19.1997 5.25H14.25C12.975 5.25 12 6.225 12 7.5C12 6.225 11.025 5.25 9.75 5.25H4.80029C4.20029 5.25 3.75 4.79971 3.75 4.19971V3.75C3.75 3.3 3.45 3 3 3ZM7.76367 11.2705C7.62187 11.2834 7.48184 11.3244 7.35059 11.3994C6.82559 11.6994 6.59941 12.3744 6.89941 12.8994L11.0244 20.3994C11.1744 20.7744 11.625 21 12 21C12.375 21 12.8256 20.7744 12.9756 20.3994L17.1006 12.8994C17.4006 12.3744 17.1744 11.6994 16.6494 11.3994C16.1244 11.0994 15.4494 11.3256 15.1494 11.8506L12 17.5503L8.85059 11.8506C8.62559 11.4568 8.18906 11.2318 7.76367 11.2705Z" 
    fill="currentColor"
  />
</svg>`,
  verticalCenter: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 4.5L5.25 4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M3 9L15 9"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M6.75 13.5H11.25"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  verticalEnd: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M15 4.5L7.5 4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M3 9L15 9"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M10.5 13.5H15"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  verticalStart: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M10.5 4.5L3 4.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M3 9L15 9"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
  <path
    d="M3 13.5H7.5"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  viewDay: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M2.25 15V13.5H15.75V15H2.25ZM2.25 4.5V3H15.75V4.5H2.25ZM3.75 12C3.3375 12 2.98438 11.8531 2.69063 11.5594C2.39687 11.2656 2.25 10.9125 2.25 10.5V7.5C2.25 7.0875 2.39687 6.73438 2.69063 6.44063C2.98438 6.14688 3.3375 6 3.75 6H14.25C14.6625 6 15.0156 6.14688 15.3094 6.44063C15.6031 6.73438 15.75 7.0875 15.75 7.5V10.5C15.75 10.9125 15.6031 11.2656 15.3094 11.5594C15.0156 11.8531 14.6625 12 14.25 12H3.75ZM3.75 10.5H14.25V7.5H3.75V10.5Z"
    fill="currentColor"
  />
</svg>`,
  warning: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M8.99985 6.75005V9.75006M8.99985 12.7501H9.00735M7.96133 2.91884L1.79264 13.5738C1.45049 14.1648 1.27941 14.4603 1.30469 14.7028C1.32675 14.9143 1.43758 15.1066 1.6096 15.2317C1.80681 15.3751 2.14826 15.3751 2.83115 15.3751H15.1685C15.8514 15.3751 16.1928 15.3751 16.3901 15.2317C16.562 15.1066 16.6729 14.9143 16.6949 14.7028C16.7202 14.4603 16.5491 14.1648 16.207 13.5738L10.0383 2.91884C9.69743 2.32996 9.52695 2.03553 9.30458 1.93664C9.11055 1.85038 8.88908 1.85038 8.69513 1.93664C8.47268 2.03553 8.3022 2.32997 7.96133 2.91884Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  x: t`
<svg
  width="18"
  height="18"
  viewBox="0 0 18 18"
  fill="none"
  xmlns="http://www.w3.org/2000/svg"
>
  <path
    d="M12.75 5.25L5.25 12.75M5.25 5.25L12.75 12.75"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`,
  zap: t`
<svg 
  width="18" 
  height="18" 
  viewBox="0 0 24 24" 
  fill="none" 
  xmlns="http://www.w3.org/2000/svg"
>
  <path 
    d="M9 17.5H3.5M6.5 12H2M9 6.5H4M17 3L10.4036 12.235C10.1116 12.6438 9.96562 12.8481 9.97194 13.0185C9.97744 13.1669 10.0486 13.3051 10.1661 13.3958C10.3011 13.5 10.5522 13.5 11.0546 13.5H16L15 21L21.5964 11.765C21.8884 11.3562 22.0344 11.1519 22.0281 10.9815C22.0226 10.8331 21.9514 10.6949 21.8339 10.6042C21.6989 10.5 21.4478 10.5 20.9454 10.5H16L17 3Z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"
  />
</svg>`
};
export {
  C as i
};
