/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.ApplicationInitializer;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.HotswapDownloadHandler;
import com.vaadin.copilot.JavaParserHandler;
import com.vaadin.copilot.JavaRewriteHandler;
import com.vaadin.copilot.MachineConfigurationHandler;
import com.vaadin.copilot.PreviewHandler;
import com.vaadin.copilot.ProjectFileHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.RouteHandler;
import com.vaadin.copilot.UiServiceHandler;
import com.vaadin.copilot.UserInfoHandler;
import com.vaadin.copilot.ai.AICommandHandler;
import com.vaadin.copilot.analytics.AnalyticsClient;
import com.vaadin.copilot.analytics.AnalyticsInterceptor;
import com.vaadin.copilot.feedback.FeedbackHandler;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IdeHandler;
import com.vaadin.copilot.ide.IdePluginCommandHandler;
import com.vaadin.copilot.ide.OpenComponentInIDE;
import com.vaadin.copilot.javarewriter.SourceSyncChecker;
import com.vaadin.copilot.plugins.accessibilitychecker.AccessibilityCheckerMessageHandler;
import com.vaadin.copilot.plugins.devsetup.DevSetupHandler;
import com.vaadin.copilot.plugins.docs.DocsHandler;
import com.vaadin.copilot.plugins.i18n.I18nHandler;
import com.vaadin.copilot.plugins.info.InfoHandler;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorMessageHandler;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class CopilotSession {
    ProjectManager projectManager;
    private List<CopilotCommand> commands;
    private AnalyticsClient analyticsClient;
    private CopilotIDEPlugin idePlugin;
    private SourceSyncChecker sourceSyncChecker;
    private final VaadinSession vaadinSession;

    public CopilotSession(VaadinSession vaadinSession, DevToolsInterface devToolsInterface) throws IOException {
        boolean analyticsEnabled;
        this.vaadinSession = vaadinSession;
        VaadinServletContext context = Copilot.getContext(vaadinSession);
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)context);
        Path projectRoot = applicationConfiguration.getProjectFolder().toPath();
        CopilotIDEPlugin.setProjectRoot(projectRoot);
        CopilotIDEPlugin.setDevToolsInterface(devToolsInterface);
        this.projectManager = new ProjectManager(applicationConfiguration, vaadinSession);
        this.idePlugin = CopilotIDEPlugin.getInstance();
        boolean bl = analyticsEnabled = !Copilot.isDevelopmentMode() && this.isUsageStatisticsEnabled();
        if (analyticsEnabled) {
            this.analyticsClient = new AnalyticsClient();
        }
        Optional<DevModeHandlerManager> devModeHandlerManagerOptional = this.getDevModeHandlerManager((VaadinContext)context);
        if (!applicationConfiguration.isProductionMode() && this.sourceSyncChecker == null && devModeHandlerManagerOptional.isPresent()) {
            this.sourceSyncChecker = new SourceSyncChecker(applicationConfiguration, devModeHandlerManagerOptional.get());
        }
        this.setupCommands(applicationConfiguration, context, analyticsEnabled);
    }

    public void handleConnect(DevToolsInterface devToolsInterface) {
        devToolsInterface.send("copilot-init", null);
        for (CopilotCommand copilotCommand : this.commands) {
            copilotCommand.handleConnect(devToolsInterface);
        }
    }

    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command == null) {
            throw new NullPointerException("command is null");
        }
        boolean canBeParallel = false;
        canBeParallel = this.commands.stream().anyMatch(c -> c.canBeParallelCommand(command));
        if (canBeParallel) {
            return this.handleMessageAsync(command, data, devToolsInterface);
        }
        return this.handleMessageSync(command, data, devToolsInterface);
    }

    private boolean handleMessageAsync(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        CompletableFuture[] futures = (CompletableFuture[])this.commands.stream().map(copilotCommand -> CompletableFuture.runAsync(() -> copilotCommand.handleMessage(command, data, devToolsInterface))).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).thenRunAsync(() -> {
            boolean handled = Stream.of(futures).map(CompletableFuture::join).anyMatch(Boolean::booleanValue);
            if (!handled) {
                JsonObject respData = Json.createObject();
                if (data.hasKey("reqId")) {
                    respData.put("reqId", data.getString("reqId"));
                }
                data.put("error", "Unknown command " + command);
                devToolsInterface.send("unknown-command", data);
            }
        });
        return true;
    }

    private boolean handleMessageSync(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        for (CopilotCommand copilotCommand : this.commands) {
            if (!copilotCommand.handleMessage(command, data, devToolsInterface)) continue;
            return true;
        }
        JsonObject respData = Json.createObject();
        if (data.hasKey("reqId")) {
            respData.put("reqId", data.getString("reqId"));
        }
        data.put("error", "Unknown command " + command);
        devToolsInterface.send("unknown-command", data);
        return true;
    }

    private boolean isUsageStatisticsEnabled() {
        return ApplicationConfiguration.get((VaadinContext)this.vaadinSession.getService().getContext()).isUsageStatisticsEnabled();
    }

    private void setupCommands(ApplicationConfiguration applicationConfiguration, VaadinServletContext context, boolean analyticsEnabled) {
        this.commands = List.of(new AnalyticsInterceptor(this.analyticsClient), new IdeHandler(this.idePlugin), new ErrorHandler(analyticsEnabled), new OpenComponentInIDE(this.projectManager), new ProjectFileHandler(this.projectManager), new AICommandHandler(this.projectManager), new UserInfoHandler((VaadinContext)context), new I18nHandler(this.projectManager), new IdePluginCommandHandler(this.projectManager), new ApplicationInitializer(this.projectManager, context), new MachineConfigurationHandler(), new ThemeEditorMessageHandler(this.projectManager), new RouteHandler(this.projectManager, context), new UiServiceHandler(this.projectManager, context), new AccessibilityCheckerMessageHandler(this.projectManager), new InfoHandler(applicationConfiguration), new FeedbackHandler(), new JavaRewriteHandler(this.projectManager, this.sourceSyncChecker), new PreviewHandler(), new JavaParserHandler(), new DocsHandler(), new DevSetupHandler(this.idePlugin), new HotswapDownloadHandler(this.projectManager));
    }

    private Optional<DevModeHandlerManager> getDevModeHandlerManager(VaadinContext context) {
        return Optional.ofNullable(context).map(ctx -> (Lookup)ctx.getAttribute(Lookup.class)).map(lu -> (DevModeHandlerManager)lu.lookup(DevModeHandlerManager.class));
    }
}

