/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaParserHandler
implements CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("parse-properties")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                String content = data.getString("source");
                List<PropertyData> propertyData = JavaParserHandler.handleParseProperties(content);
                respData.put("properties", (JsonValue)JsonUtils.listToJson(propertyData));
                devToolsInterface.send(command + "-response", respData);
                return true;
            }
            catch (Exception e) {
                this.getLogger().debug("Failed to parse properties for input {}", (Object)data.toJson(), (Object)e);
                ErrorHandler.sendErrorResponse(devToolsInterface, command, respData, "Failed to parse properties", e);
            }
        }
        return false;
    }

    static List<PropertyData> handleParseProperties(String source) {
        CompilationUnit compilationUnit = new JavaRewriter(source).getCompilationUnit();
        List fieldDeclarations = compilationUnit.findAll(FieldDeclaration.class);
        if (!fieldDeclarations.isEmpty()) {
            return JavaParserHandler.parseFields(fieldDeclarations);
        }
        List records = compilationUnit.findAll(RecordDeclaration.class);
        if (!records.isEmpty()) {
            return JavaParserHandler.parseRecord((RecordDeclaration)records.get(0));
        }
        return Collections.emptyList();
    }

    private static List<PropertyData> parseFields(List<FieldDeclaration> fieldDeclarations) {
        return fieldDeclarations.stream().map(fieldDeclaration -> {
            VariableDeclarator variable = fieldDeclaration.getVariable(0);
            return JavaParserHandler.parse(variable, fieldDeclaration);
        }).toList();
    }

    private static <T extends NodeWithSimpleName<?> & NodeWithType<?, ?>> PropertyData parse(T node) {
        return JavaParserHandler.parse(node, (NodeWithAnnotations)node);
    }

    private static <T extends NodeWithSimpleName<?> & NodeWithType<?, ?>> PropertyData parse(T node, NodeWithAnnotations<?> nodeWithAnnotations) {
        String name = node.getNameAsString();
        String humanFriendlyName = SharedUtil.camelCaseToHumanFriendly((String)name);
        ResolvedType type = ((NodeWithType<?, ?>)node).getType().resolve();
        String typeName = type.isReferenceType() ? type.asReferenceType().getQualifiedName() : type.describe();
        List<AnnotationData> annotationData = nodeWithAnnotations.getAnnotations().stream().map(JavaParserHandler::parseAnnotation).toList();
        return new PropertyData(name, humanFriendlyName, typeName, annotationData);
    }

    private static List<PropertyData> parseRecord(RecordDeclaration recordDeclaration) {
        return recordDeclaration.getParameters().stream().map(JavaParserHandler::parse).toList();
    }

    private static AnnotationData parseAnnotation(AnnotationExpr annotationExpr) {
        if (annotationExpr.isNormalAnnotationExpr()) {
            return new AnnotationData(annotationExpr.getNameAsString(), annotationExpr.asNormalAnnotationExpr().getPairs().stream().collect(Collectors.toMap(pair -> pair.getNameAsString(), pair -> JavaParserHandler.getValue(pair.getValue()))));
        }
        if (annotationExpr.isSingleMemberAnnotationExpr()) {
            return new AnnotationData(annotationExpr.getNameAsString(), Map.of("value", JavaParserHandler.getValue(annotationExpr.asSingleMemberAnnotationExpr().getMemberValue())));
        }
        return new AnnotationData(annotationExpr.getNameAsString(), Map.of());
    }

    private static Object getValue(Expression value) {
        try {
            return JavaRewriterUtil.fromExpression(value, null);
        }
        catch (IllegalArgumentException e) {
            return value.toString();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public record PropertyData(String name, String humanFriendlyName, String type, List<AnnotationData> annotations) {
    }

    public record AnnotationData(String name, Map<String, Object> parameters) {
    }
}

