/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.copilot.ApplicationInitializer;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotStatus;
import com.vaadin.copilot.JavaRewriteHandler;
import com.vaadin.copilot.MachineConfigurationHandler;
import com.vaadin.copilot.PreviewHandler;
import com.vaadin.copilot.ProjectFileHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.RouteHandler;
import com.vaadin.copilot.UserInfoHandler;
import com.vaadin.copilot.ai.AICommandHandler;
import com.vaadin.copilot.analytics.AnalyticsClient;
import com.vaadin.copilot.feedback.FeedbackHandler;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IdeHandler;
import com.vaadin.copilot.ide.IdePluginCommandHandler;
import com.vaadin.copilot.ide.OpenComponentInIDE;
import com.vaadin.copilot.plugins.accessibilitychecker.AccessibilityCheckerMessageHandler;
import com.vaadin.copilot.plugins.i18n.I18nHandler;
import com.vaadin.copilot.plugins.info.InfoHandler;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorMessageHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Copilot
implements DevToolsMessageHandler {
    public static final String PREFIX = "copilot-";
    static final String VALUE = "value";
    static final String CONTEXT = "context";
    private Boolean enable = null;
    ProjectManager projectManager;
    private List<CopilotCommand> commands;
    private AnalyticsClient analyticsClient;
    private CopilotIDEPlugin idePlugin;

    public void handleConnect(DevToolsInterface devToolsInterface) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            VaadinServletContext context = this.getContext();
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)context);
            Path projectRoot = applicationConfiguration.getProjectFolder().toPath();
            CopilotIDEPlugin.setProjectRoot(projectRoot);
            this.projectManager = new ProjectManager(applicationConfiguration);
            this.idePlugin = CopilotIDEPlugin.getInstance();
            if (!Copilot.isDevelopmentMode() && this.isUsageStatisticsEnabled()) {
                this.analyticsClient = new AnalyticsClient();
            }
            this.setupCommands(applicationConfiguration, context);
            devToolsInterface.send("copilot-init", null);
            for (CopilotCommand copilotCommand : this.commands) {
                copilotCommand.handleConnect(devToolsInterface);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create project manager", e);
        }
    }

    private void setupCommands(ApplicationConfiguration applicationConfiguration, VaadinServletContext context) {
        this.commands = List.of(new IdeHandler(this.idePlugin), new OpenComponentInIDE(applicationConfiguration, this.projectManager), new ProjectFileHandler(this.projectManager), new AICommandHandler(this.projectManager), new UserInfoHandler((VaadinContext)context), new I18nHandler(applicationConfiguration, this.projectManager), new IdePluginCommandHandler(this.projectManager), new ApplicationInitializer(this.projectManager, context), new MachineConfigurationHandler(), new ThemeEditorMessageHandler(this.projectManager), new RouteHandler(this.projectManager, context), new AccessibilityCheckerMessageHandler(this.projectManager), new InfoHandler(applicationConfiguration), new FeedbackHandler(), new JavaRewriteHandler(this.projectManager), new PreviewHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!command.startsWith(PREFIX)) {
            return false;
        }
        Map<String, String> context = this.getContextMap(data);
        data.remove(CONTEXT);
        if (command.equals("copilot-track-event")) {
            String event = PREFIX + data.getString("event");
            if (data.hasKey(VALUE)) {
                this.track(event, Map.of(VALUE, data.getString(VALUE)), context);
            } else {
                this.track(event, null, context);
            }
            return true;
        }
        try {
            command = command.substring(PREFIX.length());
            for (CopilotCommand copilotCommand : this.commands) {
                if (!copilotCommand.handleMessage(command, data, devToolsInterface)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.track("copilot-command-" + command, null, context);
        }
        JsonObject respData = Json.createObject();
        if (data.hasKey("reqId")) {
            respData.put("reqId", data.getString("reqId"));
        }
        data.put("error", "Unknown command " + command);
        devToolsInterface.send("unknown-command", data);
        return true;
    }

    private void track(String event, Map<String, String> properties, Map<String, String> context) {
        if (this.analyticsClient != null) {
            this.analyticsClient.track(event, properties, context);
        }
    }

    private boolean isUsageStatisticsEnabled() {
        return ApplicationConfiguration.get((VaadinContext)VaadinService.getCurrent().getContext()).isUsageStatisticsEnabled();
    }

    public static boolean isDevelopmentMode() {
        return Boolean.getBoolean("copilot.development");
    }

    private Map<String, String> getContextMap(JsonObject data) {
        JsonObject context = data.getObject(CONTEXT);
        HashMap<String, String> contextMap = new HashMap<String, String>();
        for (String key : context.keys()) {
            contextMap.put(key, context.getString(key));
        }
        return contextMap;
    }

    private boolean isEnabled() {
        if (this.enable == null) {
            this.enable = CopilotStatus.isEnabled(this.getContext());
        }
        return this.enable;
    }

    private VaadinServletContext getContext() {
        return (VaadinServletContext)VaadinService.getCurrent().getContext();
    }
}

