/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.types.ResolvedType;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.shared.util.SharedUtil;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriterUtil {
    private static final Set<String> javaKeywords = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
    private static final int MAX_VARIABLE_NAME_LENGTH = 20;
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_MAP = new HashMap(16);

    private JavaRewriterUtil() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JavaRewriterUtil.class);
    }

    static boolean addAfterLastFunctionCall(List<MethodCallExpr> functionCalls, String function, Expression ... parameterExpressions) {
        ArrayList<MethodCallExpr> reversedFunctionCalls = new ArrayList<MethodCallExpr>(functionCalls);
        Collections.reverse(reversedFunctionCalls);
        Optional<MethodCallExpr> maybeLastCall = reversedFunctionCalls.stream().filter(call -> JavaRewriterUtil.hasAncestor((Node)call, Statement.class) && JavaRewriterUtil.hasAncestor((Node)call, BlockStmt.class)).findFirst();
        if (maybeLastCall.isEmpty()) {
            return false;
        }
        MethodCallExpr lastCall = maybeLastCall.get();
        Optional maybeScope = lastCall.getScope();
        Expression scope = maybeScope.orElse(null);
        Statement statement = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, Statement.class);
        BlockStmt block = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, BlockStmt.class);
        MethodCallExpr newCall = new MethodCallExpr(scope, function);
        for (Expression parameterExpression : parameterExpressions) {
            newCall.addArgument(parameterExpression);
        }
        block.addStatement(block.getStatements().indexOf((Object)statement) + 1, (Statement)new ExpressionStmt((Expression)newCall));
        return true;
    }

    static List<MethodCallExpr> findMethodCallStatementsInClass(Expression expressionInsideClass, String fieldName) {
        return JavaRewriterUtil.findUsageInClass(expressionInsideClass, body -> JavaRewriterUtil.findMethodCallStatements(fieldName, body).stream());
    }

    static List<MethodCallExpr> findMethodCallNonStatementsInClass(Expression expressionInsideClass, String fieldName) {
        return JavaRewriterUtil.findUsageInClass(expressionInsideClass, body -> JavaRewriterUtil.findMethodCallNonStatements(fieldName, body).stream());
    }

    static List<Expression> findUsageInClass(Expression expressionInsideClass, Function<BlockStmt, Stream<? extends Expression>> statementFinder) {
        ClassOrInterfaceDeclaration classDeclaration = JavaRewriterUtil.findAncestor((Node)expressionInsideClass, ClassOrInterfaceDeclaration.class);
        if (classDeclaration == null) {
            return Collections.emptyList();
        }
        List blocks = classDeclaration.findAll(BlockStmt.class);
        return blocks.stream().flatMap(statementFinder).toList();
    }

    static VariableDeclarator findLocalVariableDeclarator(String variableName, BlockStmt block) {
        return block.findFirst(VariableDeclarator.class, v -> v.getNameAsString().equals(variableName)).orElse(null);
    }

    static NodeList<Expression> toExpressionList(Object parameter) {
        if (parameter instanceof List) {
            List list = (List)parameter;
            return new NodeList(list.stream().map(JavaRewriterUtil::toExpression).toList());
        }
        return new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression(parameter)});
    }

    static Expression toExpression(Object parameter) {
        if (parameter == null) {
            return new NullLiteralExpr();
        }
        if (parameter instanceof Expression) {
            Expression e = (Expression)parameter;
            return e;
        }
        if (parameter instanceof String) {
            String s = (String)parameter;
            StringLiteralExpr expr = new StringLiteralExpr();
            expr.setString(s);
            return expr;
        }
        if (parameter instanceof Long) {
            Long l = (Long)parameter;
            return new LongLiteralExpr(String.valueOf(l));
        }
        if (parameter instanceof Double) {
            Double d = (Double)parameter;
            return new DoubleLiteralExpr(d.doubleValue());
        }
        if (parameter instanceof Boolean) {
            Boolean b = (Boolean)parameter;
            return new BooleanLiteralExpr(b.booleanValue());
        }
        if (parameter instanceof Integer) {
            Integer d = (Integer)parameter;
            return new IntegerLiteralExpr("" + d);
        }
        if (parameter instanceof JavaRewriter.Code) {
            JavaRewriter.Code code = (JavaRewriter.Code)parameter;
            return StaticJavaParser.parseExpression((String)code.code());
        }
        throw new IllegalArgumentException("Unknown type: " + parameter.getClass().getName());
    }

    static boolean equalsByNameAsString(Expression e1, Expression e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null) {
            return false;
        }
        if (e2 == null) {
            return false;
        }
        if (e1.isNullLiteralExpr() && e2.isNullLiteralExpr()) {
            return true;
        }
        if (e1.isStringLiteralExpr() && e2.isStringLiteralExpr()) {
            return e1.asStringLiteralExpr().toString().equals(e2.asStringLiteralExpr().toString());
        }
        if (e1.isFieldAccessExpr() && e2.isFieldAccessExpr()) {
            return e1.toString().equals(e2.toString());
        }
        if (e1 instanceof NodeWithSimpleName && e2 instanceof NodeWithSimpleName) {
            return ((NodeWithSimpleName)e1).getNameAsString().equals(((NodeWithSimpleName)e2).getNameAsString());
        }
        return false;
    }

    public static Object fromExpression(Expression arg, ResolvedType expectedType) {
        if (arg instanceof StringLiteralExpr) {
            StringLiteralExpr literalExpression = (StringLiteralExpr)arg;
            return literalExpression.asString();
        }
        if (arg instanceof IntegerLiteralExpr) {
            IntegerLiteralExpr integerLiteralExpr = (IntegerLiteralExpr)arg;
            return integerLiteralExpr.asNumber();
        }
        if (arg instanceof DoubleLiteralExpr) {
            DoubleLiteralExpr doubleLiteralExpr = (DoubleLiteralExpr)arg;
            if (expectedType != null && expectedType.isPrimitive() && expectedType.asPrimitive().getBoxTypeClass() == Float.class) {
                return Float.valueOf((float)doubleLiteralExpr.asDouble());
            }
            return doubleLiteralExpr.asDouble();
        }
        if (arg instanceof BooleanLiteralExpr) {
            BooleanLiteralExpr booleanLiteralExpr = (BooleanLiteralExpr)arg;
            return booleanLiteralExpr.getValue();
        }
        if (arg instanceof NullLiteralExpr) {
            return arg;
        }
        if (arg instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)arg;
            return methodCallExpr;
        }
        throw new IllegalArgumentException("Unknown expression type: " + arg.getClass().getName());
    }

    static List<MethodCallExpr> findMethodCallStatements(String variableName, BlockStmt scope) {
        return JavaRewriterUtil.findMethodCalls(variableName, scope).filter(n -> JavaRewriterUtil.isParentNode((Node)n, ExpressionStmt.class)).toList();
    }

    static List<MethodCallExpr> findMethodCallNonStatements(String variableName, BlockStmt scope) {
        return JavaRewriterUtil.findMethodCalls(variableName, scope).filter(n -> !JavaRewriterUtil.isParentNode((Node)n, ExpressionStmt.class)).toList();
    }

    private static Stream<MethodCallExpr> findMethodCalls(String variableName, BlockStmt scope) {
        if (scope == null) {
            return Stream.empty();
        }
        return scope.findAll(MethodCallExpr.class, m -> JavaRewriterUtil.scopeIs(m, variableName)).stream();
    }

    private static Stream<Expression> findNameReferences(String variableName, BlockStmt scope) {
        if (scope == null) {
            return Stream.empty();
        }
        return scope.findAll(Expression.class, n -> (n.isNameExpr() || n.isFieldAccessExpr()) && JavaRewriterUtil.nameMatches(n, variableName)).stream();
    }

    public static List<MethodCallExpr> findMethodCallStatements(JavaRewriter.ComponentInfo componentDefinition) {
        if (componentDefinition.fieldName() != null) {
            return JavaRewriterUtil.findMethodCallStatementsInClass((Expression)componentDefinition.objectCreationExpr(), componentDefinition.fieldName());
        }
        if (componentDefinition.routeConstructor() != null) {
            return JavaRewriterUtil.findMethodCallStatements(null, componentDefinition.routeConstructor().getBody());
        }
        if (componentDefinition.localVariableName() != null) {
            ArrayList<MethodCallExpr> functionCalls = new ArrayList<MethodCallExpr>();
            functionCalls.addAll(JavaRewriterUtil.findMethodCallStatements(componentDefinition.localVariableName(), componentDefinition.componentCreateScope()));
            if (componentDefinition.componentCreateScope() != componentDefinition.componentAttachScope()) {
                functionCalls.addAll(JavaRewriterUtil.findMethodCallStatements(componentDefinition.localVariableName(), componentDefinition.componentAttachScope()));
            }
            return functionCalls;
        }
        return Collections.emptyList();
    }

    public static List<MethodCallExpr> findMethodCallNonStatements(JavaRewriter.ComponentInfo componentDefinition) {
        if (componentDefinition.fieldName() != null) {
            return JavaRewriterUtil.findMethodCallNonStatementsInClass((Expression)componentDefinition.objectCreationExpr(), componentDefinition.fieldName());
        }
        ArrayList<MethodCallExpr> usage = new ArrayList<MethodCallExpr>();
        usage.addAll(JavaRewriterUtil.findMethodCallNonStatements(componentDefinition.localVariableName(), componentDefinition.componentCreateScope()));
        if (componentDefinition.componentCreateScope() != componentDefinition.componentAttachScope()) {
            usage.addAll(JavaRewriterUtil.findMethodCallNonStatements(componentDefinition.localVariableName(), componentDefinition.componentAttachScope()));
        }
        return usage;
    }

    public static List<Expression> findParameterUsage(JavaRewriter.ComponentInfo componentDefinition) {
        List<Object> refs = componentDefinition.fieldName() != null ? JavaRewriterUtil.findUsageInClass((Expression)componentDefinition.objectCreationExpr(), body -> JavaRewriterUtil.findNameReferences(componentDefinition.fieldName(), body)) : (componentDefinition.localVariableName() != null ? JavaRewriterUtil.findNameReferences(componentDefinition.localVariableName(), componentDefinition.componentCreateScope()).toList() : Collections.emptyList());
        return refs.stream().filter(JavaRewriterUtil::isMethodCallArgument).toList();
    }

    public static JavaRewriter.ExtractInlineVariableResult extractInlineVariableToLocalVariable(JavaRewriter.ComponentInfo componentInfo) {
        ClassOrInterfaceType type = componentInfo.objectCreationExpr().getType();
        BlockStmt block = JavaRewriterUtil.findAncestorOrThrow((Node)componentInfo.objectCreationExpr(), BlockStmt.class);
        String newLocalVariable = JavaRewriterUtil.findFreeVariableName(componentInfo, block);
        int index = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.attachCall());
        if (index >= -1) {
            Optional parentNode = componentInfo.objectCreationExpr().getParentNode();
            if (parentNode.isEmpty()) {
                throw new IllegalStateException("Parent for object creation does not exist");
            }
            ((Node)parentNode.get()).replace((Node)componentInfo.objectCreationExpr(), (Node)new NameExpr(newLocalVariable));
            VariableDeclarator declarator = new VariableDeclarator((Type)type, newLocalVariable, (Expression)componentInfo.objectCreationExpr());
            block.addStatement(index, (Expression)new VariableDeclarationExpr(declarator));
            return new JavaRewriter.ExtractInlineVariableResult(block, newLocalVariable, index);
        }
        return null;
    }

    public static boolean inlineAssignment(JavaRewriter.ComponentInfo componentInfo) {
        return componentInfo.localVariableDeclarator() == null && componentInfo.assignmentExpression() == null && componentInfo.fieldDeclarationAndAssignment() == null && JavaRewriterUtil.onSameLine((Node)componentInfo.objectCreationExpr(), (Node)componentInfo.attachCall());
    }

    private static boolean isMethodCallArgument(Expression ref) {
        Expression e;
        Optional parent = ref.getParentNode();
        if (parent.isEmpty()) {
            return false;
        }
        Object t = parent.get();
        return t instanceof Expression && (e = (Expression)t).isMethodCallExpr() && e.asMethodCallExpr().getArguments().contains((Node)ref);
    }

    static boolean isParentNode(Node node, Class<?> parentType) {
        return node.getParentNode().filter(value -> parentType == value.getClass()).isPresent();
    }

    static boolean hasAncestor(Node node, Class<?> parentType) {
        return JavaRewriterUtil.findAncestor(node, parentType) != null;
    }

    static boolean scopeIs(MethodCallExpr m, String variableName) {
        Optional maybeScope = m.getScope();
        if (maybeScope.isEmpty() || ((Expression)maybeScope.get()).isThisExpr()) {
            return variableName == null;
        }
        Expression scope = (Expression)maybeScope.get();
        if (scope instanceof MethodCallExpr) {
            return JavaRewriterUtil.scopeIs((MethodCallExpr)scope, variableName);
        }
        return JavaRewriterUtil.nameMatches(scope, variableName);
    }

    private static boolean nameMatches(Expression expression, String variableName) {
        if (expression.isNameExpr()) {
            return expression.asNameExpr().getNameAsString().equals(variableName);
        }
        if (expression.isFieldAccessExpr()) {
            return expression.asFieldAccessExpr().getNameAsString().equals(variableName);
        }
        JavaRewriterUtil.getLogger().warn("Unknown type of scope expression {}: {}", (Object)expression.getClass().getName(), (Object)expression);
        return false;
    }

    static BlockStmt findBlock(Node node) {
        return JavaRewriterUtil.findAncestor(node, BlockStmt.class);
    }

    static BlockStmt findBlockOrThrow(Node node) {
        return JavaRewriterUtil.findAncestorOrThrow(node, BlockStmt.class);
    }

    static <T> T findAncestor(Node node, Class<T> type) {
        return (T)JavaRewriterUtil.findAncestor(node, (Node n) -> type.isAssignableFrom(n.getClass()));
    }

    @Nonnull
    static <T> T findAncestorOrThrow(Node node, Class<T> type) throws IllegalArgumentException {
        T ancestor = JavaRewriterUtil.findAncestor(node, type);
        if (ancestor == null) {
            throw new IllegalArgumentException("Ancestor of type " + type.getName() + " not found");
        }
        return ancestor;
    }

    static Node findAncestor(Node node, Predicate<Node> filter) {
        if (filter.test(node)) {
            return node;
        }
        return node.getParentNode().map(value -> JavaRewriterUtil.findAncestor(value, filter)).orElse(null);
    }

    static <T extends Node> Optional<T> findNodeOfType(Node node, int lineNumber, Class<T> type) {
        return JavaRewriterUtil.findNodeOfType(node, lineNumber, type, n -> true);
    }

    static <T extends Node> Optional<T> findNodeOfType(Node node, int lineNumber, Class<T> type, Predicate<T> filter) {
        return Optional.ofNullable(JavaRewriterUtil.findNode(node, lineNumber, n -> type.isAssignableFrom(n.getClass()) && filter.test(n)));
    }

    static <T extends Node> List<T> findNodesOfType(Node node, int lineNumber, Class<T> type, Predicate<T> filter) {
        return JavaRewriterUtil.findNodes(node, lineNumber, n -> type.isAssignableFrom(n.getClass()) && filter.test(n));
    }

    static Node findNode(Node startFrom, int lineNumber, Predicate<Node> filter) {
        for (Node node : startFrom.getChildNodes()) {
            Node found;
            if (!JavaRewriterUtil.coversLine(node, lineNumber) || (found = JavaRewriterUtil.findNode(node, lineNumber, filter)) == null) continue;
            return found;
        }
        if (filter.test(startFrom)) {
            return startFrom;
        }
        return null;
    }

    static List<Node> findNodes(Node startFrom, int lineNumber, Predicate<Node> filter) {
        ArrayList<Node> allFound = new ArrayList<Node>();
        for (Node node : startFrom.getChildNodes()) {
            if (!JavaRewriterUtil.coversLine(node, lineNumber)) continue;
            List<Node> found = JavaRewriterUtil.findNodes(node, lineNumber, filter);
            allFound.addAll(found);
        }
        if (filter.test(startFrom)) {
            allFound.add(startFrom);
        }
        return allFound;
    }

    static boolean coversLine(Node node, int lineNumber) {
        return node.getRange().filter(value -> value.begin.line <= lineNumber && value.end.line >= lineNumber).isPresent();
    }

    public static boolean hasSingleParameterMethod(Class<? extends Component> type, String func) {
        return Arrays.stream(type.getMethods()).anyMatch(method -> method.getName().equals(func) && method.getParameterCount() == 1);
    }

    public static int findBlockStatementIndex(Node node) {
        BlockStmt block = JavaRewriterUtil.findAncestorOrThrow(node, BlockStmt.class);
        Optional maybeParentNode;
        while (!(maybeParentNode = node.getParentNode()).isEmpty()) {
            Node parentNode = (Node)maybeParentNode.get();
            if (parentNode == block) {
                for (int i = 0; i < block.getStatements().size(); ++i) {
                    if (block.getStatement(i) != node) continue;
                    return i;
                }
            }
            node = parentNode;
        }
        return -1;
    }

    public static String findFreeVariableName(JavaRewriter.ComponentInfo componentInfo, BlockStmt block) {
        String base = componentInfo.type().getSimpleName().toLowerCase(Locale.ENGLISH);
        return JavaRewriterUtil.findFreeVariableName(base, block);
    }

    public static String findFreeVariableName(String base, BlockStmt block) {
        Set localVariables = block.findAll(VariableDeclarator.class).stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
        Set fieldDeclarations = JavaRewriterUtil.findAncestorOrThrow((Node)block, ClassOrInterfaceDeclaration.class).findAll(FieldDeclaration.class).stream().flatMap(fieldDeclaration -> fieldDeclaration.getVariables().stream()).map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
        String string = base = base.length() > 20 ? base.substring(0, 20) : base;
        if (base.isEmpty()) {
            base = "unknown";
        }
        Object name = base;
        int i = 2;
        while (localVariables.contains(name) || fieldDeclarations.contains(name)) {
            name = base.matches("[0-9]$") ? base + "_" + i : base + i;
            ++i;
        }
        return name;
    }

    public static void removeStatement(Node node) {
        JavaRewriterUtil.findAncestorOrThrow(node, Statement.class).remove();
    }

    public static boolean removeFromStringConcatenation(Node node) {
        Optional parent = node.getParentNode();
        if (parent.isEmpty()) {
            return false;
        }
        Object t = parent.get();
        if (t instanceof BinaryExpr) {
            Expression otherExpr;
            BinaryExpr binaryExpr = (BinaryExpr)t;
            Expression expression = otherExpr = binaryExpr.getLeft() == node ? binaryExpr.getRight() : binaryExpr.getLeft();
            if (otherExpr instanceof StringLiteralExpr) {
                binaryExpr.replace((Node)otherExpr);
                return true;
            }
        }
        return false;
    }

    public static Optional<Expression> findReference(NodeList<Expression> nodes, JavaRewriter.ComponentInfo componentDefinition) {
        return nodes.stream().filter(node -> {
            if (componentDefinition.localVariableName() != null) {
                return JavaRewriterUtil.isName(node, componentDefinition.localVariableName());
            }
            if (componentDefinition.fieldName() != null) {
                return JavaRewriterUtil.isName(node, componentDefinition.fieldName()) || JavaRewriterUtil.isFieldReference(node, componentDefinition.fieldName());
            }
            return node == componentDefinition.objectCreationExpr();
        }).findFirst();
    }

    private static boolean isFieldReference(Expression node, String s) {
        return node.isFieldAccessExpr() && node.asFieldAccessExpr().getNameAsString().equals(s);
    }

    private static boolean isName(Expression node, String s) {
        return node.isNameExpr() && node.asNameExpr().getNameAsString().equals(s);
    }

    public static FieldDeclaration findFieldDeclaration(Node nodeInClass, String fieldName) {
        ClassOrInterfaceDeclaration classDeclaration = JavaRewriterUtil.findAncestorOrThrow(nodeInClass, ClassOrInterfaceDeclaration.class);
        return (FieldDeclaration)classDeclaration.getFieldByName(fieldName).orElseThrow(() -> new IllegalArgumentException("No field found with anme " + fieldName));
    }

    public static boolean onSameLine(Node node1, Node node2) {
        Optional r1 = node1.getRange();
        Optional r2 = node2.getRange();
        if (r1.isEmpty() || r2.isEmpty()) {
            return false;
        }
        return ((Range)r1.get()).begin.line == ((Range)r2.get()).begin.line;
    }

    public static JavaRewriter.SetterAndValue getSetterAndValue(Class<?> componentType, String property, Object value) {
        String setterName = JavaRewriterUtil.getSetterName(property, componentType, true);
        if (FlowComponentQuirks.isInvertedBoolean(property, componentType)) {
            return new JavaRewriter.SetterAndValue(setterName, !Boolean.TRUE.equals(value));
        }
        Object propertyValue = JavaRewriterUtil.getPropertyValue(componentType, setterName, property, value);
        return new JavaRewriter.SetterAndValue(setterName, propertyValue);
    }

    public static String getSetterName(String property, Class<?> type, boolean includeReactConversions) {
        String setterName;
        if (includeReactConversions && (setterName = FlowComponentQuirks.convertReactPropertyToJavaSetter(property, type)) != null) {
            return setterName;
        }
        return "set" + SharedUtil.capitalize((String)SharedUtil.dashSeparatedToCamelCase((String)property));
    }

    public static String getFieldOrVariableName(JavaRewriter.ComponentInfo componentInfo) {
        if (componentInfo.localVariableName() != null) {
            return componentInfo.localVariableName();
        }
        if (componentInfo.fieldName() != null) {
            return componentInfo.fieldName();
        }
        if (componentInfo.routeConstructor() != null) {
            return "this";
        }
        return null;
    }

    public static void addImport(CompilationUnit compilationUnit, String qualifiedName) {
        if (compilationUnit.getImports().stream().anyMatch(i -> i.getNameAsString().equals(qualifiedName))) {
            return;
        }
        compilationUnit.addImport(qualifiedName);
    }

    public static String getJavaIdentifier(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isJavaIdentifierStart(str.charAt(i)) && (sb.length() <= 0 || !Character.isJavaIdentifierPart(str.charAt(i)))) continue;
            sb.append(str.charAt(i));
        }
        Object result = sb.toString();
        if (JavaRewriterUtil.isReservedJavaKeyword((String)result)) {
            result = (String)result + "_";
        }
        return result;
    }

    private static boolean isReservedJavaKeyword(String identifier) {
        return javaKeywords.contains(identifier);
    }

    public static boolean hasMethod(Class<?> type, String methodName) {
        return Arrays.stream(type.getMethods()).anyMatch(method -> method.getName().equals(methodName));
    }

    private static Object getPropertyValue(Class<?> componentType, String setterName, String prop, Object value) {
        if ((value = FlowComponentQuirks.componentSpecificValueMapping(componentType, prop, value)) == null) {
            return null;
        }
        if (setterName.startsWith("getElement().getThemeList()")) {
            return value;
        }
        if (setterName.equals("setStyle")) {
            return value;
        }
        if (JavaRewriterUtil.hasSetterForType(componentType, setterName, value.getClass())) {
            return value;
        }
        if (JavaRewriterUtil.hasSetterForType(componentType, setterName, Component.class) && value instanceof JavaRewriter.JavaComponent) {
            return value;
        }
        List<Method> setters = JavaRewriterUtil.findSetters(componentType, setterName);
        for (Method setter : setters) {
            Class<?> setterType = JavaRewriterUtil.getSetterType(setter);
            if (setterType != Instant.class) continue;
            Instant instant = Instant.now();
            if (value.equals("yesterday")) {
                instant = instant.minusSeconds(86400L);
            } else if (!value.equals("right now")) {
                instant = Instant.parse((String)value);
            }
            NameExpr scope = new NameExpr(Instant.class.getName());
            return new MethodCallExpr((Expression)scope, "ofEpochSecond").addArgument(JavaRewriterUtil.toExpression(instant.getEpochSecond()));
        }
        throw new IllegalArgumentException("Unable to find suitable setter for " + componentType.getName() + "." + setterName + " for value of type " + value.getClass().getName());
    }

    public static Class<?> getClass(String name) throws IllegalArgumentException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            JavaRewriterUtil.getLogger().debug("Class " + name + " not found", (Throwable)e);
            if (name.contains(".")) {
                int lastDot = name.lastIndexOf(46);
                return JavaRewriterUtil.getClass(name.substring(0, lastDot) + "$" + name.substring(lastDot + 1));
            }
            throw new IllegalArgumentException("Class " + name + " not found", e);
        }
    }

    private static boolean hasSetterForType(Class<?> componentType, String setterName, Class<?> valueType) {
        return JavaRewriterUtil.findSetters(componentType, setterName).stream().anyMatch(method -> {
            if (JavaRewriterUtil.getSetterType(method).isAssignableFrom(valueType)) {
                return true;
            }
            return WRAPPER_TYPE_MAP.containsKey(valueType) && JavaRewriterUtil.getSetterType(method).isAssignableFrom(WRAPPER_TYPE_MAP.get(valueType));
        });
    }

    private static List<Method> findSetters(Class<?> componentType, String setterName) {
        return Arrays.stream(componentType.getMethods()).filter(method -> method.getName().equals(setterName)).filter(method -> method.getParameterCount() == 1).toList();
    }

    private static Class<?> getSetterType(Method setter) {
        return setter.getParameterTypes()[0];
    }

    public static void removeArgumentCalls(List<MethodCallExpr> methods, List<? extends Expression> argumentsToRemove, boolean removeMethodIfNoArgs) {
        for (MethodCallExpr methodCall : methods) {
            JavaRewriterUtil.removeArgumentCalls(methodCall, argumentsToRemove, removeMethodIfNoArgs);
        }
    }

    public static boolean removeArgumentCalls(MethodCallExpr methodCallExpr, List<? extends Expression> argumentsToRemove, boolean removeMethodIfNoArgs) {
        ArrayList<Expression> willRemoveArg = new ArrayList<Expression>();
        block0: for (Expression argument : methodCallExpr.getArguments()) {
            for (Expression expression : argumentsToRemove) {
                if (!JavaRewriterUtil.equalsByNameAsString(argument, expression)) continue;
                willRemoveArg.add(argument);
                continue block0;
            }
        }
        for (Expression argument : willRemoveArg) {
            boolean remove = argument.remove();
            if (remove) continue;
            throw new IllegalArgumentException("Argument remove has failed for " + methodCallExpr.getNameAsString() + ", " + String.valueOf(argument));
        }
        if (removeMethodIfNoArgs && methodCallExpr.getArguments().isEmpty()) {
            JavaRewriterUtil.removeStatement((Node)methodCallExpr);
        }
        return true;
    }

    public static JavaRewriter.InsertionPoint findLocationBefore(Expression expr) {
        JavaRewriter.InsertionPoint loc = JavaRewriterUtil.findLocationAfter(expr);
        return new JavaRewriter.InsertionPoint(loc.getBlock(), loc.getIndex() - 1);
    }

    public static JavaRewriter.InsertionPoint findLocationAfter(Expression expr) {
        BlockStmt insertBlock = JavaRewriterUtil.findBlockOrThrow((Node)expr);
        int insertIndex = JavaRewriterUtil.findBlockStatementIndex((Node)expr) + 1;
        return new JavaRewriter.InsertionPoint(insertBlock, insertIndex);
    }

    public static JavaRewriter.InsertionPoint findLocationAtEnd(Statement statement) {
        BlockStmt insertBlock = JavaRewriterUtil.findBlockOrThrow((Node)statement);
        int insertIndex = insertBlock.getStatements().size();
        return new JavaRewriter.InsertionPoint(insertBlock, insertIndex);
    }

    public static void addFieldAfter(FieldDeclaration newField, FieldDeclaration reference) {
        ClassOrInterfaceDeclaration classDeclaration = JavaRewriterUtil.findAncestorOrThrow((Node)reference, ClassOrInterfaceDeclaration.class);
        NodeList members = classDeclaration.getMembers();
        int referenceIndex = members.indexOf((Object)reference);
        members.add(referenceIndex + 1, (Node)newField);
    }

    public static <T extends Node> T clone(T node) {
        Node newNode = node.clone();
        JavaRewriterUtil.clearData(newNode);
        return (T)newNode;
    }

    private static void clearData(Node node) {
        HashSet dataKeys = new HashSet(node.getDataKeys());
        dataKeys.forEach(arg_0 -> ((Node)node).removeData(arg_0));
        for (Node child : node.getChildNodes()) {
            JavaRewriterUtil.clearData(child);
        }
    }

    public static Optional<Expression> getAttachArgument(JavaRewriter.ComponentInfo component) {
        if (component.attachCall() == null) {
            return Optional.empty();
        }
        return JavaRewriterUtil.findReference((NodeList<Expression>)component.attachCall().getArguments(), component);
    }

    public static Expression getAttachArgumentOrThrow(JavaRewriter.ComponentInfo component) {
        return JavaRewriterUtil.getAttachArgument(component).orElseThrow(() -> new IllegalArgumentException("No attach argument found for the component"));
    }

    public static boolean setNameExprScope(MethodCallExpr newCall, NameExpr nameExpr) {
        Optional scope = newCall.getScope();
        if (scope.isEmpty()) {
            return false;
        }
        if (((Expression)scope.get()).isMethodCallExpr()) {
            return JavaRewriterUtil.setNameExprScope(((Expression)scope.get()).asMethodCallExpr(), nameExpr);
        }
        newCall.setScope((Expression)nameExpr);
        return true;
    }

    static {
        WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
    }
}

