/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IdeIntegration;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenComponentInIDE
implements CopilotCommand {
    IdeIntegration ideIntegration;
    private final ProjectManager projectManager;
    CopilotIDEPlugin idePlugin;

    public OpenComponentInIDE(ApplicationConfiguration applicationConfiguration, ProjectManager projectManager) {
        this.ideIntegration = new IdeIntegration(applicationConfiguration);
        this.projectManager = projectManager;
        this.idePlugin = CopilotIDEPlugin.getInstance();
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("show-in-ide")) {
            if (data.hasKey("nodeId")) {
                this.showFlowComponent((int)data.getNumber("uiId"), (int)data.getNumber("nodeId"));
            } else {
                this.showFile(data.getString("fileName"), (int)data.getNumber("lineNumber"));
            }
            return true;
        }
        return false;
    }

    public void showFlowComponent(int uiId, int nodeId) {
        VaadinSession session = VaadinSession.getCurrent();
        session.access((Command & Serializable)() -> {
            Element element = session.findElement(uiId, nodeId);
            Optional c = element.getComponent();
            if (c.isPresent()) {
                this.ideIntegration.showComponentCreateInIde((Component)c.get());
            } else {
                this.getLogger().error("Only component locations are tracked. The given node id refers to an element and not a component");
            }
        });
    }

    public void showFile(String filename, int lineNumber) {
        File file = new File(filename);
        if (!file.toPath().isAbsolute()) {
            try {
                file = new File(this.projectManager.makeAbsolute(filename));
            }
            catch (IOException e) {
                this.getLogger().warn("File not found: " + filename);
                return;
            }
        }
        IdeUtils.openFile(file, lineNumber);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

