/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.info;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.plugins.info.CopilotInfo;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoHandler
implements CopilotCommand {
    private final ApplicationConfiguration applicationConfiguration;
    private ObjectMapper objectMapper = new ObjectMapper();

    public InfoHandler(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        try {
            JsonObject json = Json.createObject();
            json.put("info", this.objectMapper.writeValueAsString((Object)new CopilotInfo(this.applicationConfiguration)));
            devToolsInterface.send("copilot-info", json);
        }
        catch (JsonProcessingException e) {
            this.getLogger().error("Failed to send info message", (Throwable)e);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        return false;
    }
}

