/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.open.OSUtils;
import com.vaadin.open.Open;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdeUtils {
    private IdeUtils() {
    }

    public static Optional<IDE> findIde() {
        List<ProcessHandle.Info> processes = IdeUtils.getProcessTree();
        for (ProcessHandle.Info info : processes) {
            if (IdeUtils.isIdea(info)) {
                return Optional.of(IDE.IDEA);
            }
            if (IdeUtils.isVSCode(info)) {
                return Optional.of(IDE.VSCODE);
            }
            if (!IdeUtils.isEclipse(info)) continue;
            return Optional.of(IDE.ECLIPSE);
        }
        return Optional.empty();
    }

    public static void openFile(File file, int lineNumber) {
        CopilotIDEPlugin idePlugin = CopilotIDEPlugin.getInstance();
        if (idePlugin.isActive() && idePlugin.supports(CopilotIDEPlugin.Commands.SHOW_IN_IDE)) {
            try {
                idePlugin.showInIde(file.getAbsolutePath(), lineNumber - 1, 0);
                return;
            }
            catch (IOException ex) {
                IdeUtils.getLogger().warn("Cannot show file in IDE using Copilot IDE Plugin", (Throwable)ex);
            }
        }
        if (!IdeUtils.openFileUsingBinary(file, lineNumber)) {
            IdeUtils.getLogger().warn("Cannot open {} in IDE", (Object)file);
        }
    }

    private static boolean openFileUsingBinary(File file, int lineNumber) {
        String absolutePath = file.getAbsolutePath();
        Optional<ProcessHandle.Info> maybeIdeCommand = IdeUtils.findIdeCommandInfo();
        if (maybeIdeCommand.isEmpty()) {
            IdeUtils.getLogger().debug("Unable to detect IDE from process tree");
            IdeUtils.printProcessTree(msg -> IdeUtils.getLogger().debug(msg));
            return false;
        }
        ProcessHandle.Info processInfo = maybeIdeCommand.get();
        if (IdeUtils.isVSCode(processInfo)) {
            return Open.open((String)("vscode://file" + absolutePath + ":" + lineNumber));
        }
        if (IdeUtils.isIdea(processInfo)) {
            try {
                IdeUtils.run(IdeUtils.getBinary(processInfo), "--line", "" + lineNumber, absolutePath);
                return true;
            }
            catch (IOException e) {
                IdeUtils.getLogger().error("Unable to launch IntelliJ IDEA", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else if (IdeUtils.isEclipse(processInfo)) {
            if (OSUtils.isMac()) {
                try {
                    IdeUtils.run("open", "-a", IdeUtils.getBinary(processInfo), absolutePath);
                    return true;
                }
                catch (IOException e) {
                    IdeUtils.getLogger().error("Unable to launch Eclipse", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                try {
                    IdeUtils.run(IdeUtils.getBinary(processInfo), absolutePath + ":" + lineNumber);
                    return true;
                }
                catch (IOException e) {
                    IdeUtils.getLogger().error("Unable to launch Eclipse", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return false;
    }

    static String getBinary(ProcessHandle.Info info) {
        String cmd = info.command().orElseThrow();
        if (IdeUtils.isIdea(info)) {
            return IdeUtils.getIdeaBinary(info);
        }
        if (IdeUtils.isEclipse(info)) {
            return cmd.replaceFirst("/Contents/MacOS/eclipse$", "");
        }
        return cmd;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IdeUtils.class);
    }

    public static void main(String[] args) {
        IdeUtils.printProcessTree(System.out::println);
    }

    private static void printProcessTree(Consumer<String> printer) {
        for (ProcessHandle.Info info : IdeUtils.getProcessTree()) {
            printer.accept("Process tree:");
            info.command().ifPresent(value -> printer.accept("Command: " + value));
            info.commandLine().ifPresent(value -> printer.accept("Command line: " + value));
            info.arguments().ifPresent(values -> {
                for (int i = 0; i < ((String[])values).length; ++i) {
                    printer.accept("Arguments[" + i + "]: " + values[i]);
                }
            });
            printer.accept("");
        }
    }

    static void run(String command, String ... arguments) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(command);
        cmd.addAll(Arrays.asList(arguments));
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(cmd);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
            throw new IOException("Command " + String.valueOf(cmd) + " terminated with exit code " + exitCode + ".\nOutput:\n" + output);
        }
    }

    private static List<ProcessHandle.Info> getProcessTree() {
        return IdeUtils.getParentProcesses().stream().map(ProcessHandle::info).collect(Collectors.toList());
    }

    private static Optional<ProcessHandle.Info> findIdeCommandInfo() {
        return IdeUtils.findIdeCommand(IdeUtils.getProcessTree());
    }

    static Optional<ProcessHandle.Info> findIdeCommand(List<ProcessHandle.Info> processes) {
        for (ProcessHandle.Info info : processes) {
            if (!IdeUtils.isIdea(info) && !IdeUtils.isVSCode(info) && !IdeUtils.isEclipse(info)) continue;
            return Optional.of(info);
        }
        return Optional.empty();
    }

    private static String getCommandAndArguments(ProcessHandle.Info info) {
        return info.commandLine().orElse(null);
    }

    private static List<ProcessHandle> getParentProcesses() {
        ArrayList<ProcessHandle> proceses = new ArrayList<ProcessHandle>();
        ProcessHandle p = ProcessHandle.current();
        while (p != null) {
            proceses.add(p);
            p = p.parent().orElse(null);
        }
        return proceses;
    }

    static boolean isEclipse(ProcessHandle.Info info) {
        Optional<String> cmd = info.command();
        if (cmd.isPresent()) {
            String lowerCmd = cmd.get().toLowerCase(Locale.ENGLISH);
            return lowerCmd.endsWith("eclipse") || lowerCmd.endsWith("eclipse.exe");
        }
        return false;
    }

    static boolean isIdea(ProcessHandle.Info info) {
        return IdeUtils.getIdeaBinary(info) != null;
    }

    private static String getIdeaBinary(ProcessHandle.Info info) {
        String replaced;
        String commandAndArguments = IdeUtils.getCommandAndArguments(info);
        if (commandAndArguments != null && commandAndArguments.contains("idea_rt.jar") && !(replaced = commandAndArguments.replaceFirst(".*[:;]([^:;]*)(idea_rt.jar).*", "$1$2")).equals(commandAndArguments)) {
            File binFolder = new File(new File(replaced).getParentFile().getParentFile(), "bin");
            Optional<File> bin = Stream.of("idea", "idea.sh", "idea.bat").map(binName -> new File(binFolder, (String)binName)).filter(File::exists).findFirst();
            if (bin.isPresent()) {
                return bin.get().getAbsolutePath();
            }
        }
        return info.command().filter(cmd -> cmd.contains("idea")).orElse(null);
    }

    static boolean isVSCode(ProcessHandle.Info info) {
        String cmdLower;
        String termProgram = System.getenv("TERM_PROGRAM");
        if ("vscode".equalsIgnoreCase(termProgram)) {
            return true;
        }
        String cmd = IdeUtils.getCommandAndArguments(info);
        return cmd != null && ((cmdLower = cmd.toLowerCase(Locale.ENGLISH)).contains("vscode") || cmdLower.contains("vs code") || cmdLower.contains("code helper") || cmdLower.contains("visual studio code"));
    }

    public static enum IDE {
        IDEA(".idea", "idea"),
        VSCODE(".vscode", "vscode"),
        ECLIPSE(".eclipse", "eclipse");

        private final String metaDir;
        private final String pluginIde;

        private IDE(String metaDir, String pluginIde) {
            this.metaDir = metaDir;
            this.pluginIde = pluginIde;
        }

        public String getMetaDir() {
            return this.metaDir;
        }

        public String getPluginIde() {
            return this.pluginIde;
        }
    }
}

