/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class ProjectManager {
    private final Path projectRoot;

    public ProjectManager(Path projectRoot) throws IOException {
        this.projectRoot = projectRoot.toRealPath(new LinkOption[0]);
    }

    public String readFile(String filename) throws IOException {
        File file = new File(filename);
        if (this.isFileInsideProject(file)) {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("File " + filename + " is not inside the project at " + String.valueOf(this.projectRoot));
    }

    boolean isFileInsideProject(File file) throws IOException {
        Path path = this.getRealPath(file);
        return path.startsWith(this.projectRoot);
    }

    private Path getRealPath(File file) throws IOException {
        Path path = file.toPath();
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            return path.getParent().toRealPath(new LinkOption[0]).resolve(path.getFileName());
        }
    }

    public void writeFile(String filename, String content) throws IOException {
        File file = new File(filename);
        if (!this.isFileInsideProject(file)) {
            throw new IllegalArgumentException("File " + filename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        FileUtils.write((File)new File(filename), (CharSequence)content, (Charset)StandardCharsets.UTF_8);
    }

    public String makeAbsolute(String projectRelativeFilename) throws IOException {
        Path resolved = this.projectRoot.resolve(projectRelativeFilename).toRealPath(new LinkOption[0]);
        if (!resolved.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("File " + projectRelativeFilename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return resolved.toString();
    }

    public String makeRelative(String filename) throws IOException {
        Path absolutePath = new File(filename).toPath().toRealPath(new LinkOption[0]);
        if (!absolutePath.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("File " + filename + " is not inside the project at " + String.valueOf(this.projectRoot));
        }
        return this.projectRoot.relativize(absolutePath).toString();
    }
}

