/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.analytics;

import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.analytics.AnalyticsRequest;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsClient
extends CopilotServerClient {
    private final ProKey proKey = LocalProKey.get();
    private final String machineId = MachineId.get();
    private Boolean isVaadiner;

    public AnalyticsClient() {
        try {
            LicenseChecker.checkLicense((String)"vaadin-employee", (String)"1.0.0", (BuildType)BuildType.DEVELOPMENT);
            this.isVaadiner = Boolean.TRUE;
        }
        catch (LicenseException e) {
            this.isVaadiner = Boolean.FALSE;
        }
    }

    public void track(String event, Map<String, String> properties, Map<String, String> context) {
        properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
        properties.put("Vaadiner", this.isVaadiner.toString());
        this.sendRequest(event, properties, context);
    }

    protected void sendRequest(String event, Map<String, String> properties, Map<String, String> context) {
        URI uri = this.getQueryURI("analytics");
        AnalyticsRequest trackingRequest = new AnalyticsRequest(this.proKey != null ? this.proKey.getProKey() : null, this.machineId, event, properties, context);
        String json = this.writeAsJsonString(trackingRequest);
        HttpRequest request = this.buildRequest(uri, json);
        this.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }
}

