/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.CopilotServerRequest;
import com.vaadin.copilot.CopilotServerResponse;
import com.vaadin.copilot.CopilotServerResponseCode;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AICommandHandler
extends CopilotServerClient
implements CopilotCommand {
    private static final String MESSAGE_PROMPT_FAILED = "prompt-failed";
    private static final String MESSAGE_PROMPT_OK = "prompt-ok";
    private Map<String, String> metadata;
    private final ProjectManager projectManager;

    public AICommandHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.metadata = new HashMap<String, String>();
        ServerInfo serverInfo = new ServerInfo();
        this.metadata = serverInfo.getVersions().stream().collect(Collectors.toMap(ServerInfo.NameAndVersion::name, ServerInfo.NameAndVersion::version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("prompt-text")) {
            String prompt = data.getString("text");
            HashMap<String, String> sources = new HashMap<String, String>();
            JsonObject reactSources = data.getObject("sources");
            if (reactSources != null) {
                for (String filename : reactSources.keys()) {
                    this.getLogger().debug("Hilla file: {}", (Object)filename);
                    sources.put(filename, reactSources.getString(filename));
                }
            }
            if (data.hasKey("uiid")) {
                Map<String, String> fileSourceMapJava;
                Double uiId = data.getNumber("uiid");
                VaadinSession session = VaadinSession.getCurrent();
                try {
                    session.lock();
                    fileSourceMapJava = this.getJavaSourceMap(uiId, session);
                }
                catch (IOException e) {
                    this.getLogger().error("Error reading requested project Flow Java files", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    session.unlock();
                }
                sources.putAll(fileSourceMapJava);
            }
            String proKey = Optional.ofNullable(LocalProKey.get()).map(ProKey::getProKey).orElse(null);
            HashMap<String, String> relativeSources = new HashMap<String, String>();
            for (String filename : sources.keySet()) {
                try {
                    relativeSources.put(this.projectManager.makeRelative(filename), (String)sources.get(filename));
                }
                catch (IOException e) {
                    this.getLogger().error("Error making file relative to project", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    return true;
                }
            }
            try {
                CopilotServerRequest req = new CopilotServerRequest(prompt, relativeSources, this.metadata, proKey);
                this.queryCopilotServer(req, response -> {
                    try {
                        this.handleQueryResponse((CopilotServerResponse)response);
                        devToolsInterface.send("copilot-prompt-ok", Json.createObject());
                    }
                    catch (IOException e) {
                        this.getLogger().error("Error handling copilot server response", (Throwable)e);
                        devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    }
                });
            }
            catch (Exception e) {
                this.getLogger().error("Error querying copilot server", (Throwable)e);
                devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                return true;
            }
            return true;
        }
        return false;
    }

    private Map<String, String> getJavaSourceMap(Number uiId, VaadinSession session) throws IOException {
        UI ui = session.getUIById(uiId.intValue());
        ArrayList<Component> componentList = new ArrayList<Component>();
        HashMap<String, String> sources = new HashMap<String, String>();
        this.addComponents((Component)ui, componentList);
        HashSet<ComponentTracker.Location> locations = new HashSet<ComponentTracker.Location>();
        for (Component component : componentList) {
            ComponentTracker.Location create = ComponentTracker.findCreate((Component)component);
            ComponentTracker.Location attach = ComponentTracker.findAttach((Component)component);
            if (create == null || attach == null) continue;
            locations.add(create);
            locations.add(attach);
        }
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)session.getService().getContext());
        for (ComponentTracker.Location location : locations) {
            File javaFile = location.findJavaFile((AbstractConfiguration)applicationConfiguration);
            if (sources.containsKey(location.filename())) continue;
            ArrayList<String> javaFileNames = new ArrayList<String>();
            if (javaFile.exists()) {
                javaFileNames.add(javaFile.getName());
                sources.put(javaFile.getAbsolutePath(), this.projectManager.readFile(javaFile.getPath()));
            }
            this.getLogger().debug("Java filenames: {}", javaFileNames);
        }
        return sources;
    }

    private void addComponents(Component component, List<Component> componentList) {
        componentList.add(component);
        component.getChildren().forEach(c -> this.addComponents((Component)c, componentList));
    }

    private void queryCopilotServer(CopilotServerRequest req, Consumer<CopilotServerResponse> responseHandler) {
        URI queryUri = this.getQueryURI("query");
        String json = this.writeAsJsonString(req);
        if (AICommandHandler.isDevelopment()) {
            this.getLogger().info("Querying copilot server at {} using {}", (Object)queryUri, (Object)json);
        }
        HttpRequest request = this.buildRequest(queryUri, json);
        Consumer<String> responseParser = responseJson -> {
            this.getLogger().info("Response: {}", responseJson);
            CopilotServerResponse response = this.readValue((String)responseJson, CopilotServerResponse.class);
            responseHandler.accept(response);
        };
        ((CompletableFuture)((CompletableFuture)this.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(responseParser)).join();
    }

    private void handleQueryResponse(CopilotServerResponse response) throws IOException {
        if (response.code() == CopilotServerResponseCode.ERROR) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.ERROR_REQUEST) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.NOTHING) {
            this.getLogger().debug("Copilot server returned no changes");
            return;
        }
        if (response.code() == CopilotServerResponseCode.HILLA_REACT) {
            this.getLogger().debug("Copilot server returned Hilla/React changes");
        } else if (response.code() == CopilotServerResponseCode.FLOW) {
            this.getLogger().debug("Copilot server returned Flow changes");
        }
        for (Map.Entry<String, String> change : response.changes().entrySet()) {
            try {
                this.projectManager.writeFile(this.projectManager.makeAbsolute(change.getKey()), change.getValue());
            }
            catch (IOException e) {
                throw new IOException("Unable to write file (" + change.getKey() + ") with data from copilot server response", e);
            }
        }
    }
}

