package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;

import java.util.Arrays;

/**
 * Handles getting information about the user (pro key based) and communicating
 * with the server about feature access.
 */
public class UserInfoHandler implements CopilotCommand {

    @Override
    public boolean handleMessage(String command, JsonObject data,
            DevToolsInterface devToolsInterface) {
        if (command.equals("get-user-info")) {
            ProKey proKey = LocalProKey.get();
            String[] accessTo = {};
            if (proKey != null) {
                accessTo = queryAccessTo(proKey);
            }
            JsonObject userInfo = Json.createObject();
            if (proKey != null) {
                userInfo.put("proKey", proKey.getProKey());
            }

            JsonArray accessValues = Arrays.stream(accessTo).map(Json::create)
                    .collect(JsonUtils.asArray());
            userInfo.put("accessTo", accessValues);
            userInfo.put(KEY_REQ_ID, data.getString(KEY_REQ_ID));

            devToolsInterface.send("copilot-user-info", userInfo);
            return true;
        } else if (command.equals("log-in")) {
            ProKey proKey = LocalProKey.get();
            JsonObject response = Json.createObject();
            response.put(KEY_REQ_ID, data.getString(KEY_REQ_ID));
            if (proKey == null) {
                LicenseChecker.checkLicense("copilot",
                        CopilotVersion.getVersion(), BuildType.DEVELOPMENT,
                        loginUrl -> {
                            // This is where we always should end up as there is
                            // no pro key
                            response.put("loginUrl", loginUrl);
                            devToolsInterface.send("log-in-resp", response);
                        });
            }
            return true;
        }
        return false;
    }

    private String[] queryAccessTo(ProKey proKey) {
        // TODO actually query server
        return new String[] {};
    }
}
