/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.copilot.AICommandHandler;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.OpenComponentInIDE;
import com.vaadin.copilot.ProjectFileHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.UserInfoHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class Copilot
implements DevToolsMessageHandler {
    static final String PREFIX = "copilot-";
    ProjectManager projectManager;
    private List<CopilotCommand> commands;

    public void handleConnect(DevToolsInterface devToolsInterface) {
        try {
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)VaadinService.getCurrent().getContext());
            Path projectRoot = applicationConfiguration.getProjectFolder().toPath();
            this.projectManager = new ProjectManager(projectRoot);
            this.setupCommands(devToolsInterface, applicationConfiguration);
            devToolsInterface.send("copilot-init", null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create project manager", e);
        }
    }

    private void setupCommands(DevToolsInterface devToolsInterface, ApplicationConfiguration applicationConfiguration) {
        this.commands = List.of(new OpenComponentInIDE(applicationConfiguration), new ProjectFileHandler(this.projectManager), new AICommandHandler(this.projectManager), new UserInfoHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (!command.startsWith(PREFIX)) {
            return false;
        }
        if (command.equals("copilot-track-event")) {
            String event = PREFIX + data.getString("event");
            if (data.hasKey("value")) {
                DevModeUsageStatistics.collectEvent((String)event, (double)data.getNumber("value"));
            } else {
                DevModeUsageStatistics.collectEvent((String)event);
            }
            return true;
        }
        Instant start = Instant.now();
        try {
            command = command.substring(PREFIX.length());
            for (CopilotCommand copilotCommand : this.commands) {
                if (!copilotCommand.handleMessage(command, data, devToolsInterface)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            long time = start.until(Instant.now(), ChronoUnit.MILLIS);
            DevModeUsageStatistics.collectEvent((String)("copilot-command-" + command), (double)time);
        }
        return false;
    }
}

