package com.vaadin.copilot;

import com.vaadin.flow.server.frontend.TypeScriptBootstrapModifier;
import com.vaadin.flow.theme.ThemeDefinition;

import java.util.List;

public class CopilotLoader implements TypeScriptBootstrapModifier {

    private String themeImportFolder;

    @Override
    public void modify(List<String> bootstrapTypeScript, boolean productionMode,
            ThemeDefinition themeDefinition) {
        if (productionMode) {
            return;
        }

        if (themeDefinition != null && themeDefinition.getTheme() != null
                && themeDefinition.getTheme().getName()
                        .equals("com.vaadin.flow.theme.material")) {
            this.themeImportFolder = "material";
        } else {
            this.themeImportFolder = "lumo";
        }

        bootstrapTypeScript.addAll(0, List.of(
                "import 'Frontend/generated/jar-resources/copilot/copilot.js';",
                """
                        // @ts-ignore
                        if (import.meta.hot) {
                          // @ts-ignore
                          import.meta.hot.on('vite:afterUpdate', () => {
                            (window as any).Vaadin.copilot.eventbus.emit('vite-after-update',{});
                          });
                        }
                        """,
                // Imports for all the vaadin components used in copilot must go
                // into the application bundle to avoid loading them twice.
                // We must load the version that the application wants to use to
                // avoid theme conflicts until
                // https://github.com/vaadin/web-components/issues/7055 is
                // fixed.
                themedImport("vertical-layout"), //
                themedImport("context-menu"), //
                themedImport("text-field"), //
                themedImport("menu-bar"), //
                themedImport("grid"), //
                themedImport("grid", "vaadin-grid-tree-column.js"), //
                themedImport("details"), //
                themedImport("select"), //
                themedImport("overlay"), //
                "import '@vaadin/icons/vaadin-iconset.js';", //
                "import '@vaadin/icon/vaadin-icon.js';"));

    }

    private String themedImport(String component) {
        return themedImport(component, "vaadin-" + component + ".js");
    }

    private String themedImport(String component, String filename) {
        return "import '@vaadin/{component}/theme/{theme}/{filename}';"
                .replace("{component}", component)
                .replace("{theme}", themeImportFolder)
                .replace("{filename}", filename);
    }

}
