/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.ClassNameRequest;
import com.vaadin.copilot.plugins.themeeditor.messages.ClassNameResponse;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class ClassNameHandler
implements MessageHandler {
    private static final Pattern SUGGEST_CLASS_NAME_PATTERN = Pattern.compile("(?!^)(?=[A-Z][a-z])");
    private final HasThemeModifier hasThemeModifier;

    public ClassNameHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public MessageHandler.ExecuteAndUndo handle(JsonObject data) {
        List<String> existingClassNames = this.hasThemeModifier.getThemeModifier().getExistingClassNames();
        ClassNameRequest request = (ClassNameRequest)JsonUtils.readToObject((JsonObject)data, ClassNameRequest.class);
        return this.findExistingClassName(existingClassNames, request).orElseGet(() -> this.suggestClassName(existingClassNames, request));
    }

    private MessageHandler.ExecuteAndUndo suggestClassName(List<String> existingClassNames, ClassNameRequest request) {
        String baseName;
        String name = baseName = FilenameUtils.getBaseName((String)request.getFileName()) + "-" + request.getComponentDisplayName();
        Object selectorName = request.getComponentName() + "." + name;
        int i = 1;
        while (existingClassNames.contains(selectorName)) {
            name = baseName + "-" + i;
            selectorName = this.appendComponentTag(request.getComponentName(), name);
            ++i;
        }
        String dashedName = this.dashify(name);
        return new MessageHandler.ExecuteAndUndo(() -> new ClassNameResponse(dashedName, true), Optional.empty());
    }

    private Optional<MessageHandler.ExecuteAndUndo> findExistingClassName(List<String> existingClassNames, ClassNameRequest request) {
        for (String componentClass : request.getClassList()) {
            if (!existingClassNames.contains(this.appendComponentTag(request.getComponentName(), componentClass))) continue;
            return Optional.of(new MessageHandler.ExecuteAndUndo(() -> new ClassNameResponse(componentClass, false), Optional.empty()));
        }
        return Optional.empty();
    }

    private String dashify(String text) {
        if (text == null) {
            return null;
        }
        String subst = "-";
        Matcher matcher = SUGGEST_CLASS_NAME_PATTERN.matcher(text);
        return matcher.replaceAll("-").toLowerCase(Locale.ENGLISH).replaceAll("-+", "-");
    }

    private String appendComponentTag(String tag, String str) {
        return tag + "." + str;
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.GET_CLASS_NAME.getValue();
    }
}

