/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.EventUtil;
import com.vaadin.collaborationengine.ListChange;
import com.vaadin.collaborationengine.MapChange;
import com.vaadin.collaborationengine.PutChange;
import com.vaadin.collaborationengine.ReplaceChange;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

class Topic {
    private final CollaborationEngine collaborationEngine;
    private final Map<String, Map<String, JsonNode>> namedMapData = new HashMap<String, Map<String, JsonNode>>();
    private final List<MapChangeNotifier> mapChangeListeners = new ArrayList<MapChangeNotifier>();
    private final Map<String, List<JsonNode>> namedListData = new HashMap<String, List<JsonNode>>();
    private final List<ListChangeNotifier> listChangeListeners = new ArrayList<ListChangeNotifier>();
    final Map<String, Duration> mapExpirationTimeouts = new HashMap<String, Duration>();
    final Map<String, Duration> listExpirationTimeouts = new HashMap<String, Duration>();
    private Instant lastDisconnected;

    Topic(CollaborationEngine collaborationEngine) {
        this.collaborationEngine = collaborationEngine;
    }

    Registration subscribeToMapChange(MapChangeNotifier changeNotifier) {
        this.clearExpiredData();
        this.mapChangeListeners.add(changeNotifier);
        return Registration.combine((Registration[])new Registration[]{(Registration & Serializable)() -> this.mapChangeListeners.remove(changeNotifier), this::updateLastDisconnected});
    }

    Registration subscribeToListChange(ListChangeNotifier changeNotifier) {
        this.clearExpiredData();
        this.listChangeListeners.add(changeNotifier);
        return Registration.combine((Registration[])new Registration[]{(Registration & Serializable)() -> this.listChangeListeners.remove(changeNotifier), this::updateLastDisconnected});
    }

    private void clearExpiredData() {
        Clock clock = this.collaborationEngine.getClock();
        if (this.lastDisconnected != null) {
            Instant now = clock.instant();
            this.mapExpirationTimeouts.forEach((name, timeout) -> {
                if (now.isAfter(this.lastDisconnected.plus((TemporalAmount)timeout))) {
                    this.namedMapData.get(name).clear();
                }
            });
            this.listExpirationTimeouts.forEach((name, timeout) -> {
                if (now.isAfter(this.lastDisconnected.plus((TemporalAmount)timeout))) {
                    this.namedListData.get(name).clear();
                }
            });
        }
        this.lastDisconnected = null;
    }

    private void updateLastDisconnected() {
        if (this.mapChangeListeners.isEmpty() && this.listChangeListeners.isEmpty()) {
            this.lastDisconnected = this.collaborationEngine.getClock().instant();
        }
    }

    private void fireMapChangeEvent(MapChange change) {
        EventUtil.fireEvents(this.mapChangeListeners, listener -> listener.onEntryChange(change), true);
    }

    private void fireListChangeEvent(ListChange change) {
        EventUtil.fireEvents(this.listChangeListeners, listener -> listener.onListChange(change), true);
    }

    Stream<MapChange> getMapData(String mapName) {
        Map<String, JsonNode> mapData = this.namedMapData.get(mapName);
        if (mapData == null) {
            return Stream.empty();
        }
        return mapData.entrySet().stream().map(entry -> new MapChange(mapName, (String)entry.getKey(), null, (JsonNode)entry.getValue()));
    }

    JsonNode getMapValue(String mapName, String key) {
        Map<String, JsonNode> map = this.namedMapData.get(mapName);
        if (map == null || !map.containsKey(key)) {
            return null;
        }
        return map.get(key).deepCopy();
    }

    void applyMapChange(PutChange change) {
        this.applyMapChange(change, null);
    }

    boolean applyMapChange(PutChange change, Predicate<Object> condition) {
        NullNode newValue;
        NullNode oldValue;
        String mapName = change.getMapName();
        String key = change.getKey();
        Map map = this.namedMapData.computeIfAbsent(mapName, name -> new HashMap());
        Object object = oldValue = map.containsKey(key) ? (JsonNode)map.get(key) : NullNode.getInstance();
        if (condition != null && !condition.test(oldValue)) {
            return false;
        }
        if (Objects.equals(oldValue, change.getValue())) {
            return true;
        }
        Object object2 = newValue = change.getValue() == null ? NullNode.getInstance() : change.getValue();
        if (newValue instanceof NullNode) {
            map.remove(key);
        } else {
            map.put(key, newValue.deepCopy());
        }
        this.fireMapChangeEvent(new MapChange(mapName, key, (JsonNode)oldValue, (JsonNode)newValue));
        return true;
    }

    boolean applyMapReplace(ReplaceChange replaceChange) {
        return this.applyMapChange(new PutChange(replaceChange), oldValue -> Objects.equals(oldValue, replaceChange.getExpectedValue()));
    }

    void applyListChange(ListChange change) {
        String listName = change.getListName();
        JsonNode item = change.getAddedItem();
        this.getList(listName).add(item);
        this.fireListChangeEvent(new ListChange(listName, item));
    }

    Stream<ListChange> getListChanges(String listName) {
        return this.getListItems(listName).map(item -> new ListChange(listName, (JsonNode)item));
    }

    Stream<JsonNode> getListItems(String listName) {
        return this.getList(listName).stream();
    }

    private List<JsonNode> getList(String listName) {
        return this.namedListData.computeIfAbsent(listName, name -> new ArrayList());
    }

    @FunctionalInterface
    static interface ListChangeNotifier {
        public void onListChange(ListChange var1);
    }

    @FunctionalInterface
    static interface MapChangeNotifier {
        public void onEntryChange(MapChange var1);
    }
}

