/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.ListChange;
import java.util.EventObject;
import java.util.Optional;

public class ListChangeEvent
extends EventObject {
    private final JsonNode addedItem;

    ListChangeEvent(CollaborationList list, ListChange change) {
        super(list);
        this.addedItem = change.getAddedItem();
    }

    @Override
    public CollaborationList getSource() {
        return (CollaborationList)super.getSource();
    }

    public <T> Optional<T> getAddedItem(Class<T> type) {
        if (this.addedItem != null) {
            T item = JsonUtil.toInstance(this.addedItem, type);
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public <T> Optional<T> getAddedItem(TypeReference<T> type) {
        if (this.addedItem != null) {
            T item = JsonUtil.toInstance(this.addedItem, type);
            return Optional.of(item);
        }
        return Optional.empty();
    }
}

