/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vaadin.collaborationengine.CollaborationEngineConfiguration;
import com.vaadin.collaborationengine.LicenseHandler;
import com.vaadin.flow.internal.MessageDigestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;

class FileHandler {
    static final String DATA_DIR_CONFIG_PROPERTY = "ce.dataDir";
    static final String DATA_DIR_PUBLIC_PROPERTY = "vaadin.ce.dataDir";
    private final ObjectMapper objectMapper = FileHandler.createObjectMapper();
    private final Path statsFilePath;
    private final Path licenseFilePath;

    FileHandler(CollaborationEngineConfiguration config) {
        if (config.getDataDirPath() == null) {
            throw this.createDataDirNotConfiguredException();
        }
        if (config.getDataDirPath().toFile().exists() && !Files.isWritable(config.getDataDirPath())) {
            throw this.createDataDirNotWritableException(config.getDataDirPath());
        }
        this.statsFilePath = FileHandler.createStatsFilePath(config.getDataDirPath());
        this.licenseFilePath = FileHandler.createLicenseFilePath(config.getDataDirPath());
        if (this.statsFilePath.toFile().exists() && !Files.isWritable(this.statsFilePath)) {
            throw this.createStatsFileNotWritableException();
        }
    }

    static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NON_PRIVATE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        return objectMapper;
    }

    static Path createStatsFilePath(Path dirPath) {
        return Paths.get(dirPath.toString(), "ce-statistics.json");
    }

    static Path createLicenseFilePath(Path dirPath) {
        return Paths.get(dirPath.toString(), "ce-license.json");
    }

    void writeStats(LicenseHandler.StatisticsInfo stats) {
        try {
            String checksum = this.calculateChecksum(this.objectMapper.valueToTree((Object)stats));
            LicenseHandler.StatisticsInfoWrapper wrapper = new LicenseHandler.StatisticsInfoWrapper(stats, checksum);
            this.objectMapper.writeValue(this.statsFilePath.toFile(), (Object)wrapper);
        }
        catch (IOException e) {
            throw new IllegalStateException("Collaboration Engine wasn't able to write statistics into file at '" + this.statsFilePath + "'. Check that the file is readable by the app, and not locked.", e);
        }
    }

    LicenseHandler.LicenseInfo readLicenseFile() {
        try {
            JsonNode licenseJson = this.readFileAsJson(this.licenseFilePath).orElseThrow(this::createLicenseNotFoundException);
            LicenseHandler.LicenseInfoWrapper licenseInfoWrapper = (LicenseHandler.LicenseInfoWrapper)this.objectMapper.treeToValue((TreeNode)licenseJson, LicenseHandler.LicenseInfoWrapper.class);
            String calculatedChecksum = this.calculateChecksum(licenseJson.get("content"));
            if (licenseInfoWrapper.checksum == null || !licenseInfoWrapper.checksum.equals(calculatedChecksum)) {
                throw this.createLicenseInvalidException(null);
            }
            return licenseInfoWrapper.content;
        }
        catch (JsonProcessingException e) {
            throw this.createLicenseInvalidException(e);
        }
    }

    LicenseHandler.StatisticsInfo readStatsFile() {
        try {
            Optional<JsonNode> statsJson = this.readFileAsJson(this.statsFilePath);
            if (statsJson.isPresent()) {
                JsonNode statisticsJson = statsJson.get();
                LicenseHandler.StatisticsInfoWrapper statisticsInfoWrapper = (LicenseHandler.StatisticsInfoWrapper)this.objectMapper.treeToValue((TreeNode)statisticsJson, LicenseHandler.StatisticsInfoWrapper.class);
                String calculatedChecksum = this.calculateChecksum(statisticsJson.get("content"));
                if (statisticsInfoWrapper.checksum == null || !statisticsInfoWrapper.checksum.equals(calculatedChecksum)) {
                    throw this.createStatsInvalidException();
                }
                return statisticsInfoWrapper.content;
            }
            return new LicenseHandler.StatisticsInfo(null, Collections.emptyMap(), null, Collections.emptyMap());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Collaboration Engine failed to parse the statistics information from file '" + this.statsFilePath + "'.", e);
        }
    }

    private String calculateChecksum(JsonNode node) throws JsonProcessingException {
        return Base64.getEncoder().encodeToString(MessageDigestUtil.sha256((String)this.objectMapper.writeValueAsString((Object)node)));
    }

    private Optional<JsonNode> readFileAsJson(Path filePath) throws JsonProcessingException {
        try {
            File file = filePath.toFile();
            if (!file.exists()) {
                return Optional.empty();
            }
            return Optional.of(this.objectMapper.readTree(file));
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Collaboration Engine wasn't able to read the file at '" + filePath + "'. Check that the file is readable by the app, and not locked.", e);
        }
    }

    private RuntimeException createDataDirNotConfiguredException() {
        return new IllegalStateException("Missing required configuration property 'vaadin.ce.dataDir'. Using Collaboration Engine in production requires having a valid license file and configuring the directory where that file is stored e.g. as a system property. Instructions can be found in the Vaadin documentation.");
    }

    private RuntimeException createLicenseNotFoundException() {
        return new IllegalStateException("Collaboration Engine failed to find the license file at '" + this.licenseFilePath + ". Using Collaboration Engine in production requires a valid license file. Instructions for obtaining a license can be found in the Vaadin documentation. If you already have a license, make sure that the '" + DATA_DIR_PUBLIC_PROPERTY + "' property is pointing to the correct directory and that the directory contains the license file.");
    }

    private RuntimeException createLicenseInvalidException(Throwable cause) {
        return new IllegalStateException("Collaboration Engine failed to parse the file '" + this.licenseFilePath + "'. The content of the license file is not valid. If you have made any changes to the file, please revert those changes. If that's not possible, contact Vaadin to get a new copy of the license file.", cause);
    }

    private RuntimeException createDataDirNotWritableException(Path dataDirFilePath) {
        return new IllegalStateException("Collaboration Engine doesn't have write permissions for the data directory at '" + dataDirFilePath + "'. Collaboration Engine needs to be able to write files into the folder to function. Make sure that the the system user, running the Java environment, has write permissions to the directory.");
    }

    private RuntimeException createStatsFileNotWritableException() {
        return new IllegalStateException("Collaboration Engine doesn't have write permissions for the statistics file at '" + this.statsFilePath + "'. Collaboration Engine needs to be able to write into the file to function. Make sure that the the system user, running the Java environment, has write permissions to the file.");
    }

    private RuntimeException createStatsInvalidException() {
        return new IllegalStateException("Collaboration Engine failed to parse the file '" + this.statsFilePath + "'. The content of the statistics file is not valid. If you have made any changes to the file, please revert those changes. If that's not possible, contact Vaadin to get support.");
    }
}

