/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2.enumerations;

import java.util.HashMap;
import java.util.Map;

public enum VideoType {
    TRAILER("Trailer"),
    TEASER("Teaser"),
    CLIP("Clip"),
    FEATURETTE("Featurette"),
    OPENING_CREDITS("Opening Credits");

    private static final Map<String, VideoType> lookup;
    private final String value;

    private VideoType(String value) {
        this.value = value;
    }

    private static Map<String, VideoType> prepareLookup() {
        HashMap<String, VideoType> mtMap = new HashMap<String, VideoType>();
        for (VideoType videoType : VideoType.values()) {
            mtMap.put(videoType.value, videoType);
        }
        return mtMap;
    }

    public static VideoType get(String value) {
        return lookup.get(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        lookup = VideoType.prepareLookup();
    }
}

