/*
 * Decompiled with CFR 0.152.
 */
package com.utsman.smartmarker.location;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.google.android.gms.location.LocationRequest;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.single.PermissionListener;
import com.utsman.smartmarker.location.LocationListener;
import com.utsman.smartmarker.location.LocationUpdateListener;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import pl.charmas.android.reactivelocation2.ReactiveLocationProvider;

public class LocationWatcher {
    private Context context;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();

    public LocationWatcher(Context context) {
        this.context = context;
    }

    public void stopLocationWatcher() {
        this.compositeDisposable.dispose();
    }

    public void getLocation(final Activity activity, final LocationListener locationListener) {
        Dexter.withActivity((Activity)activity).withPermission("android.permission.ACCESS_FINE_LOCATION").withListener(new PermissionListener(){

            public void onPermissionGranted(PermissionGrantedResponse response) {
                LocationWatcher.this.getLocation(locationListener);
            }

            public void onPermissionDenied(PermissionDeniedResponse response) {
                activity.finish();
            }

            public void onPermissionRationaleShouldBeShown(PermissionRequest permission2, PermissionToken token) {
                token.continuePermissionRequest();
            }
        }).check();
    }

    public void getLocation(final LocationListener locationListener) {
        LocationRequest request = LocationRequest.create().setPriority(100).setNumUpdates(1).setInterval(100L);
        ReactiveLocationProvider locationProvider = new ReactiveLocationProvider(this.context);
        Disposable locationDisposable = locationProvider.getUpdatedLocation(request).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Location>(){

            public void accept(Location location) throws Exception {
                locationListener.location(location);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                throwable.printStackTrace();
                Log.e((String)"anjay", (String)("cannot update location --> " + throwable.getMessage()));
            }
        });
        this.compositeDisposable.add(locationDisposable);
    }

    public void getLocationUpdate(final Activity activity, final long priority, final LocationUpdateListener locationUpdateListener) {
        Dexter.withActivity((Activity)activity).withPermission("android.permission.ACCESS_FINE_LOCATION").withListener(new PermissionListener(){

            public void onPermissionGranted(PermissionGrantedResponse response) {
                LocationWatcher.this.getLocationUpdate(priority, locationUpdateListener);
            }

            public void onPermissionDenied(PermissionDeniedResponse response) {
                activity.finish();
            }

            public void onPermissionRationaleShouldBeShown(PermissionRequest permission2, PermissionToken token) {
                token.continuePermissionRequest();
            }
        }).check();
    }

    public void getLocationUpdate(long priority, final LocationUpdateListener locationUpdateListener) {
        LocationRequest request = LocationRequest.create().setPriority(100).setInterval(100L);
        ReactiveLocationProvider locationProvider = new ReactiveLocationProvider(this.context);
        Disposable locationDisposable = locationProvider.getUpdatedLocation(request).subscribeOn(Schedulers.io()).doOnNext((Consumer)new Consumer<Location>(){

            public void accept(Location location) throws Exception {
                locationUpdateListener.oldLocation(location);
            }
        }).delay(priority, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).doOnNext((Consumer)new Consumer<Location>(){

            public void accept(Location location) throws Exception {
                locationUpdateListener.newLocation(location);
            }
        }).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                locationUpdateListener.failed(throwable);
            }
        }).subscribe();
        this.compositeDisposable.add(locationDisposable);
    }

    public static class Priority {
        public static long JEDI = 3L;
        public static long VERY_HIGH = 30L;
        public static long HIGH = 50L;
        public static long MEDIUM = 300L;
        public static long LOW = 3000L;
        public static long VERY_LOW = 8000L;
    }
}

