package com.utsmannn.pocketdb

import android.util.Base64
import java.util.*
import javax.crypto.Cipher
import javax.crypto.spec.IvParameterSpec
import javax.crypto.spec.SecretKeySpec

object CredentialsAccessor {
    private const val CHARSET_NAME = "UTF-8"
    private const val CIPHER_ALGORITHM = "AES/CFB/PKCS5Padding"
    //private const val secretKey = "utsmangantenkyah"

    /**
     * Note:
     * - Cipher.getInstance should not be called without setting the encryption mode and padding
     * - Cipher#getInstance should not be called with ECB as the cipher mode or without setting the
     * cipher mode because the default mode on android is ECB, which is insecure
     */
    @Throws(Exception::class)
    fun encrypt(secretKey: String, cleartext: String): String {
        val key = secretKey.toByteArray()
        val keySpec = SecretKeySpec(key, CIPHER_ALGORITHM)
        val cipher = Cipher.getInstance(CIPHER_ALGORITHM)

        // TODO: I just use 16 first bytes from SecretKey. Replace your own 16 bytes ivSpec key here
        val iv = Arrays.copyOf(key, 16)
        val ivSpec = IvParameterSpec(iv)
        cipher.init(Cipher.ENCRYPT_MODE, keySpec, ivSpec)
        val inputByte = cleartext.toByteArray(charset(CHARSET_NAME))
        return String(Base64.encode(cipher.doFinal(inputByte), Base64.DEFAULT))
    }

    @Throws(Exception::class)
    fun decrypt(secretKey: String, encrypted: String): String {
        val key = secretKey.toByteArray()
        val keySpec = SecretKeySpec(key, CIPHER_ALGORITHM)
        val cipher = Cipher.getInstance(CIPHER_ALGORITHM)
        val iv = Arrays.copyOf(key, 16)
        val ivSpec = IvParameterSpec(iv)
        cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec)
        val inputByte = encrypted.toByteArray(charset(CHARSET_NAME))
        return String(cipher.doFinal(Base64.decode(inputByte, Base64.DEFAULT)))
    }
}