package com.utsmannn.pocketdb

import android.annotation.SuppressLint
import android.util.Base64
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.module.kotlin.KotlinModule
import java.nio.ByteBuffer
import java.nio.charset.Charset
import java.security.InvalidKeyException
import javax.crypto.BadPaddingException
import javax.crypto.Cipher
import javax.crypto.spec.SecretKeySpec

@SuppressLint("GetInstance")
fun String.decrypt(key: String): String {
    val keySpec = SecretKeySpec(key.toByteArray(charset("UTF-8")), "AES")

    val cipher = Cipher.getInstance("AES")
    cipher.init(Cipher.DECRYPT_MODE, keySpec)

    val decrypted = try {
        cipher.doFinal(Base64.decode(this, Base64.DEFAULT))
    } catch (e: BadPaddingException) {
        throw InvalidKeyException("Key is invalid with current data, check your key: $key")
    }

    return decrypted.toString(Charset.forName("UTF-8"))
        .removeSurrounding("\"", "\"")
        .replace("\"[", "[")
        .replace("]\"", "]")
        .replace("\\", "")
        .replace("\\s+", "")
}

@SuppressLint("GetInstance")
fun Any.encrypt(key: String): String {
    val objectMapper = ObjectMapper()
    objectMapper.registerModule(KotlinModule())
    val buf = ByteBuffer.wrap(objectMapper.writeValueAsString(this).toByteArray(Charsets.UTF_8))
    val keySpec = SecretKeySpec(key.toByteArray(charset("UTF-8")), "AES")
    val cipher = Cipher.getInstance("AES")

    try {
        cipher.init(Cipher.ENCRYPT_MODE, keySpec)
    } catch (e: InvalidKeyException) {
        throw InvalidKeyException("Key invalid, must be 16 digits or length is 128/192/256 bits in Pocket.init, " +
                "etc: Pocket.init(context, \"utsman_gantenkkk\"), \"utsman_gantenkkk\" is 16 digits")
    }

    val encrypted = cipher.doFinal(buf.array())
    return Base64.encodeToString(encrypted, Base64.DEFAULT)
        .replace("\\s+", "")
}