package com.utsmannn.pocketdb

import android.app.Application
import com.google.gson.Gson
import kotlinx.coroutines.flow.Flow
import org.koin.android.ext.android.inject

class PocketRow(private val name: String) : Application() {
    private val pocketDb: PocketDb by inject()
    private val gson: Gson by inject()

    fun <T> insert(key: String, data: T) = run {
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).insert(data)
    }

    fun <T> flowOf(key: String, defaultData: DefaultData<T>): Flow<T?> = run {
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).select(
            defaultData.getDefault(),
            defaultData.getType()
        )
    }

    fun <T> selectOf(key: String, defaultData: DefaultData<T>): T? = run {
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).selectSingle(
            defaultData.getDefault(),
            defaultData.getType()
        )
    }

    fun destroy(key: String = "") = run {
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).clear(key)
    }
}