package com.utsmannn.pocketdb

import com.google.gson.reflect.TypeToken
import java.lang.reflect.Type

class DefaultData<T>(private val data: T?, private val typeToken: TypeToken<T>) {
    fun getDefault() = data

    fun getType(): Type {
        return typeToken.type
    }
}

class DefaultCollection<T>(private val data: Collection<T>?, private val typeToken: TypeToken<Collection<T>>) {
    fun getDefault() = data
    fun getType(): Type = typeToken.type
}