package com.utsmannn.pocketdb

import android.app.Application
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlinx.coroutines.flow.Flow
import org.koin.android.ext.android.inject

class PocketCollection(private val name: String) : Application() {
    private val pocketDb: PocketDb by inject()
    private val gson: Gson by inject()

    fun <T> insert(key: String, data: T) = run {
        val defaultData = DefaultCollection(emptyList(), object : TypeToken<Collection<T>>() {})
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).insertCollectionItem(
            data,
            defaultData.getType()
        )
    }

    fun <T> flowOf(key: String, default: DefaultCollection<T>): Flow<Collection<T?>> = run {
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).selectCollection(
            default.getDefault(),
            default.getType()
        )
    }

    fun <T> selectOf(key: String, default : DefaultCollection<T>): Collection<T> = run {
        PocketValue(key, pocketDb.pref(name), gson, pocketDb.getKey()).selectSingleCollection(
            default.getType()
        )
    }
}