/*
 * Decompiled with CFR 0.152.
 */
package com.kucingapes.ankodrawer;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/kucingapes/ankodrawer/AnDrawerUtils;", "", "()V", "BACKGROUND", "", "FOREGROUND", "fetchResourceColor", "context", "Landroid/content/Context;", "colorAttr", "materialCard", "", "cardView", "Landroid/support/v7/widget/CardView;", "materialText", "textView", "Landroid/widget/TextView;", "rippleThis", "view", "Landroid/view/View;", "type", "setLightStatusBar", "activity", "Landroid/app/Activity;", "ankodrawer_release"})
public final class AnDrawerUtils {
    public static final int FOREGROUND = 0;
    public static final int BACKGROUND = 1;
    public static final AnDrawerUtils INSTANCE;

    public final int fetchResourceColor(@NotNull Context context, int colorAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{colorAttr});
        int color = a.getColor(0, 0);
        a.recycle();
        return color;
    }

    public final void setLightStatusBar(@NotNull View view, @NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 23) {
            int flags = view.getSystemUiVisibility();
            view.setSystemUiVisibility(flags |= 0x2000);
            Window window = activity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            window.setStatusBarColor(-1);
        }
    }

    public final void materialCard(@NotNull CardView cardView) {
        CardView cardView2;
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        CardView $receiver = cardView2 = cardView;
        $receiver.setRadius(8.0f);
    }

    public final void materialText(@NotNull TextView textView) {
        TextView textView2;
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        TextView $receiver = textView2 = textView;
        if (Build.VERSION.SDK_INT >= 21) {
            $receiver.setLetterSpacing(0.03f);
        }
    }

    public final void rippleThis(@NotNull View view, int type) {
        View view2;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        View $receiver = view2 = view;
        TypedValue rippleValue = new TypedValue();
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        context.getTheme().resolveAttribute(16843534, rippleValue, true);
        switch (type) {
            case 0: {
                if (Build.VERSION.SDK_INT < 23) break;
                $receiver.setForeground(ContextCompat.getDrawable((Context)$receiver.getContext(), (int)rippleValue.resourceId));
                break;
            }
            case 1: {
                if (Build.VERSION.SDK_INT < 16) break;
                $receiver.setBackground(ContextCompat.getDrawable((Context)$receiver.getContext(), (int)rippleValue.resourceId));
            }
        }
    }

    private AnDrawerUtils() {
    }

    static {
        AnDrawerUtils anDrawerUtils;
        INSTANCE = anDrawerUtils = new AnDrawerUtils();
    }
}

