/*
 * Decompiled with CFR 0.152.
 */
package com.urbanmania.spring.beans.factory.config.annotations;

import com.urbanmania.spring.beans.factory.config.annotations.PropertyEvent;
import com.urbanmania.spring.beans.factory.config.annotations.PropertyListener;
import com.urbanmania.spring.beans.factory.config.annotations.PropertyLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFileLoader
implements PropertyLoader {
    private static final Logger log = Logger.getLogger(PropertyFileLoader.class.getName());
    private Properties properties;
    private List<PropertyListener> listeners = new ArrayList<PropertyListener>();
    private List<Resource> resources;
    private Map<String, Long> lastModified = new HashMap<String, Long>();

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Override
    public Properties loadProperties() throws IOException {
        this.properties = new Properties();
        for (Resource resource : this.resources) {
            this.properties.load(resource.getInputStream());
        }
        for (Resource resource : this.resources) {
            this.updateLastModified(resource);
        }
        return this.properties;
    }

    @Override
    public void registerPropertyListener(PropertyListener listener) {
        this.listeners.add(listener);
    }

    public void checkResourcesForUpdates() throws IOException {
        for (Resource resource : this.resources) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("checking file=[" + resource.getFile() + ",lastModified=" + resource.getFile().lastModified() + "] for updates since=[" + this.lastModified.get(resource.getFilename()) + "]");
            }
            if (resource.getFile().lastModified() <= this.lastModified.get(resource.getFilename())) continue;
            Properties updatedProperies = new Properties();
            updatedProperies.load(resource.getInputStream());
            for (Object o : updatedProperies.keySet()) {
                String key = (String)o;
                if (updatedProperies.get(key).equals(this.properties.get(key))) continue;
                log.info("changed property=[" + key + "] in file=[" + resource.getFile() + "]: " + this.properties.get(key) + " -> " + updatedProperies.get(key));
                String value = (String)updatedProperies.get(key);
                this.properties.put(key, value);
                PropertyEvent event = new PropertyEvent(this, key, value);
                for (PropertyListener listener : this.listeners) {
                    listener.propertyChanged(event);
                }
            }
            this.updateLastModified(resource);
        }
    }

    private void updateLastModified(Resource resource) throws IOException {
        this.lastModified.put(resource.getFilename(), resource.getFile().lastModified());
    }
}

