/*
 * Decompiled with CFR 0.152.
 */
package com.urbanmania.spring.beans.factory.config.annotations;

import com.urbanmania.spring.beans.factory.config.annotations.BeanConfigurationException;
import com.urbanmania.spring.beans.factory.config.annotations.Property;
import com.urbanmania.spring.beans.factory.config.annotations.PropertyEvent;
import com.urbanmania.spring.beans.factory.config.annotations.PropertyListener;
import com.urbanmania.spring.beans.factory.config.annotations.PropertyLoader;
import com.urbanmania.spring.beans.factory.config.annotations.UpdateDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAnnotationAndPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements PropertyListener,
ApplicationContextAware,
BeanFactoryAware {
    private static final Logger log = Logger.getLogger(PropertyAnnotationAndPlaceholderConfigurer.class.getName());
    PropertyLoader[] propertyLoaders;
    String basePackage;
    ApplicationContext applicationContext;
    ConfigurableBeanFactory beanFactory;
    Map<String, List<UpdateDescriptor>> updatableProperties = new Hashtable<String, List<UpdateDescriptor>>();

    public void setPropertyLoaders(PropertyLoader[] propertyLoaders) {
        this.propertyLoaders = propertyLoaders;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    protected void loadProperties(Properties props) throws IOException {
        super.loadProperties(props);
        if (this.propertyLoaders != null) {
            for (PropertyLoader propertyLoader : this.propertyLoaders) {
                log.info("Loading propertyLoader=[" + propertyLoader + "]");
                Properties loaded = propertyLoader.loadProperties();
                props.putAll((Map<?, ?>)loaded);
                propertyLoader.registerPropertyListener(this);
            }
        }
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties properties) throws BeansException {
        super.processProperties(beanFactory, properties);
        for (String name : beanFactory.getBeanDefinitionNames()) {
            MutablePropertyValues mpv = beanFactory.getBeanDefinition(name).getPropertyValues();
            Class clazz = beanFactory.getType(name);
            if (clazz == null || clazz.getPackage() == null || this.basePackage != null && !clazz.getPackage().getName().startsWith(this.basePackage)) continue;
            log.info("Configuring properties for bean=" + name + "[" + clazz + "]");
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors((Class)clazz)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("examining property=[" + clazz.getName() + "." + property.getName() + "]");
                }
                Method setter = property.getWriteMethod();
                Method getter = property.getReadMethod();
                Property annotation = null;
                if (setter != null && setter.isAnnotationPresent(Property.class)) {
                    annotation = setter.getAnnotation(Property.class);
                } else if (setter != null && getter != null && getter.isAnnotationPresent(Property.class)) {
                    annotation = getter.getAnnotation(Property.class);
                } else if (setter == null && getter != null && getter.isAnnotationPresent(Property.class)) {
                    this.throwBeanConfigurationException(clazz, property.getName());
                }
                if (annotation == null) continue;
                this.setProperty(properties, name, mpv, clazz, property, annotation);
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("examining field=[" + clazz.getName() + "." + field.getName() + "]");
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property annotation = field.getAnnotation(Property.class);
                PropertyDescriptor property = BeanUtils.getPropertyDescriptor((Class)clazz, (String)field.getName());
                if (property == null || property.getWriteMethod() == null) {
                    this.throwBeanConfigurationException(clazz, field.getName());
                }
                this.setProperty(properties, name, mpv, clazz, property, annotation);
            }
        }
    }

    private void throwBeanConfigurationException(Class<?> clazz, String name) {
        throw new BeanConfigurationException("setter for property=[" + clazz.getName() + "." + name + "] not available.");
    }

    private void setProperty(Properties properties, String name, MutablePropertyValues mpv, Class<?> clazz, PropertyDescriptor property, Property annotation) {
        String value = this.resolvePlaceholder(annotation.key(), properties, 1);
        if (value == null) {
            value = annotation.value();
        }
        value = this.parseStringValue(value, properties, new HashSet());
        log.info("setting property=[" + clazz.getName() + "." + property.getName() + "] value=[" + annotation.key() + "=" + value + "]");
        mpv.addPropertyValue(property.getName(), (Object)value);
        if (annotation.update()) {
            this.registerBeanPropertyForUpdate(clazz, annotation, property);
        }
    }

    public void registerBeanPropertyForUpdate(Class<?> beanClass, Property annotation, PropertyDescriptor property) {
        log.info("watching updates for property=[" + property.getPropertyType().getName() + "." + property.getName() + "] key=[" + annotation.key() + "]");
        List<UpdateDescriptor> properties = this.updatableProperties.get(annotation.key());
        if (properties == null) {
            properties = new ArrayList<UpdateDescriptor>();
        }
        UpdateDescriptor descriptor = new UpdateDescriptor();
        descriptor.setPropertyDescriptor(property);
        descriptor.setBeanClass(beanClass);
        properties.add(descriptor);
        this.updatableProperties.put(annotation.key(), properties);
    }

    @Override
    public void propertyChanged(PropertyEvent event) {
        if (this.updatableProperties.get(event.getKey()) != null) {
            for (UpdateDescriptor update : this.updatableProperties.get(event.getKey())) {
                for (Object bean : this.applicationContext.getBeansOfType(update.getBeanClass()).values()) {
                    log.info("updating property=[" + bean.getClass().getName() + "." + update.getPropertyDescriptor().getName() + "] value=[" + event.getValue() + "]");
                    try {
                        update.getPropertyDescriptor().getWriteMethod().invoke(bean, this.beanFactory.getTypeConverter().convertIfNecessary((Object)event.getValue(), update.getPropertyDescriptor().getPropertyType()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new BeanConfigurationException("Error updating " + bean.getClass().getName() + "." + update.getPropertyDescriptor().getName() + "] value=[" + event.getValue() + "]", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new BeanConfigurationException("Error updating " + bean.getClass().getName() + "." + update.getPropertyDescriptor().getName() + "] value=[" + event.getValue() + "]", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new BeanConfigurationException("Error updating " + bean.getClass().getName() + "." + update.getPropertyDescriptor().getName() + "] value=[" + event.getValue() + "]", e);
                    }
                }
            }
        }
    }
}

