/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.finder;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.support.annotation.NonNull;
import com.urbandroid.sleep.captcha.finder.BaseCaptchaFinder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CachedCaptchaFinder
extends BaseCaptchaFinder {
    private final Map<Intent, Record> cache = new HashMap<Intent, Record>();
    private long lastUpdated = -1L;
    private static final long EXPIRATION = TimeUnit.MINUTES.toMillis(3L);
    private List<ApplicationInfo> cachedApps;
    private long expirationInMillis;

    public CachedCaptchaFinder(@NonNull Context context) {
        this(context, EXPIRATION);
    }

    public CachedCaptchaFinder(@NonNull Context context, long expirationInMillis) {
        super(context);
        this.expirationInMillis = expirationInMillis;
    }

    @Override
    @NonNull
    protected List<ApplicationInfo> getInstalledApps(PackageManager packageManager) {
        long now = System.currentTimeMillis();
        if (this.cachedApps == null || now - this.lastUpdated > this.expirationInMillis) {
            this.lastUpdated = now;
            this.cachedApps = super.getInstalledApps(packageManager);
        }
        return this.cachedApps;
    }

    @Override
    @NonNull
    protected List<ResolveInfo> queryIntent(PackageManager packageManager, Intent intent) {
        long now = System.currentTimeMillis();
        Record record = this.cache.get(intent);
        if (record == null || now - record.lastUpdated > this.expirationInMillis) {
            record = new Record(now, super.queryIntent(packageManager, intent));
            this.cache.put(intent, record);
        }
        return record.infos;
    }

    private class Record {
        long lastUpdated;
        List<ResolveInfo> infos;

        public Record(long lastUpdated, List<ResolveInfo> infos) {
            this.lastUpdated = lastUpdated;
            this.infos = infos;
        }
    }
}

