/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.util;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.urbandroid.sleep.captcha.domain.CaptchaChildResult;
import java.util.Set;

public class IntentUtil {
    public static StringBuilder traceBundle(StringBuilder builder, Bundle b) {
        return IntentUtil.traceBundle(builder, b, "");
    }

    public static StringBuilder traceBundle(StringBuilder builder, Bundle b, String tabs) {
        if (b == null) {
            return builder;
        }
        Set keys = b.keySet();
        for (String key : keys) {
            String stringValue;
            builder.append("\n" + tabs + "\t\t" + key).append("=");
            Object value = b.get(key);
            if (value instanceof String) {
                stringValue = (String)value;
                if (stringValue.length() <= 0) continue;
                builder.append("\"").append(stringValue).append("\" ");
                continue;
            }
            if (value instanceof Boolean) {
                builder.append(value);
                continue;
            }
            if (value instanceof Number) {
                builder.append(value);
                continue;
            }
            if (value instanceof Intent) {
                IntentUtil.traceIntent(builder, (Intent)value, tabs + "\t\t\t");
                continue;
            }
            stringValue = value != null ? value.toString() : "NULL";
            if (stringValue.length() <= 0 || stringValue.length() >= 100) continue;
            builder.append("(").append(stringValue).append(") ");
        }
        return builder;
    }

    public static StringBuilder traceIntent(StringBuilder builder, Intent i) {
        return IntentUtil.traceIntent(builder, i, "");
    }

    public static StringBuilder traceIntent(StringBuilder builder, Intent i, String tabs) {
        builder.append("\n" + tabs + "I: ");
        if (i == null) {
            builder.append("null");
        } else {
            if (i.getAction() != null) {
                builder.append("action: ").append(i.getAction()).append(" ");
            }
            if (i.getComponent() != null) {
                builder.append("class: ").append(i.getComponent().getClassName());
            }
            IntentUtil.traceBundle(builder, i.getExtras(), tabs);
        }
        return builder;
    }

    @NonNull
    public static String traceIntent(@Nullable Intent intent) {
        StringBuilder builder = new StringBuilder();
        IntentUtil.traceIntent(builder, intent);
        return builder.toString();
    }

    public static int resolveTimeout(@Nullable Intent intent) {
        int aliveTimeout;
        Intent rootIntent;
        boolean isCaptchaSolvedCallbackIntent = intent != null && intent.hasExtra("originIntent");
        Intent intent2 = rootIntent = isCaptchaSolvedCallbackIntent ? (Intent)intent.getParcelableExtra("originIntent") : intent;
        if (rootIntent != null && rootIntent.hasExtra("aliveTimeout") && (aliveTimeout = rootIntent.getIntExtra("aliveTimeout", -1)) != -1) {
            return aliveTimeout;
        }
        return 60;
    }

    @Nullable
    public static CaptchaChildResult getChildResult(final @Nullable Intent intent) {
        if (intent == null || !"com.urbandroid.sleep.captcha.intent.action.SOLVED".equals(intent.getAction())) {
            return null;
        }
        return new CaptchaChildResult(){

            @Override
            public int getCaptchaId() {
                return intent.getIntExtra("captchaInfo", -1);
            }

            @Override
            public boolean isSolved() {
                return intent.getBooleanExtra("success", true);
            }
        };
    }
}

