/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.finder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.urbandroid.sleep.captcha.domain.CaptchaGroup;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import com.urbandroid.sleep.captcha.finder.CaptchaFinder;
import com.urbandroid.sleep.captcha.finder.CaptchaInfoFilter;
import java.util.List;

public class FallbackCaptchaFinder
implements CaptchaFinder {
    private final CaptchaFinder captchaFinder;
    private final CaptchaInfo fallbackInternalCaptcha;

    public FallbackCaptchaFinder(@NonNull CaptchaFinder captchaFinder, int fallbackCaptchaId) {
        this.captchaFinder = captchaFinder;
        this.fallbackInternalCaptcha = this.findById(fallbackCaptchaId);
        if (this.fallbackInternalCaptcha == null || this.fallbackInternalCaptcha.isExternal()) {
            throw new RuntimeException("Invalid (not found or external) fallback captcha id: " + fallbackCaptchaId);
        }
    }

    @Override
    @NonNull
    public List<CaptchaInfo> lookup() {
        return this.captchaFinder.lookup();
    }

    @Override
    @NonNull
    public List<CaptchaInfo> lookup(@Nullable CaptchaInfoFilter filter) {
        return this.captchaFinder.lookup(filter);
    }

    @Override
    @NonNull
    public List<CaptchaGroup> findGroups(@Nullable CaptchaInfoFilter filter) {
        return this.captchaFinder.findGroups(filter);
    }

    @Override
    @Nullable
    public CaptchaInfo findById(int id) {
        if (id == 0) {
            return null;
        }
        CaptchaInfo captchaInfo = this.captchaFinder.findById(id);
        return captchaInfo == null ? this.fallbackInternalCaptcha : captchaInfo;
    }
}

