/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.domain;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;

public class BaseCaptchaInfo
implements CaptchaInfo {
    private final int id;
    private final int order;
    private final String packageName;
    private final String activityName;
    private final String label;
    private final boolean isExternal;
    private final boolean hasDifficulty;
    private String configActivityName;
    private transient String forCaptcha;

    private BaseCaptchaInfo(Context context, @NonNull ActivityInfo activityInfo, @NonNull String label) {
        this.packageName = activityInfo.packageName;
        this.activityName = activityInfo.name;
        this.label = label;
        this.isExternal = !context.getPackageName().equals(this.packageName);
        boolean isFromSleep = "com.urbandroid.sleep".equals(this.packageName);
        this.id = this.isExternal && !isFromSleep || activityInfo.metaData == null || !activityInfo.metaData.containsKey("com.urbandroid.sleep.captcha.meta.id") ? (this.packageName + this.activityName).hashCode() : activityInfo.metaData.getInt("com.urbandroid.sleep.captcha.meta.id");
        this.hasDifficulty = activityInfo.metaData != null && activityInfo.metaData.getBoolean("com.urbandroid.sleep.captcha.meta.has_difficulty");
        int order = activityInfo.metaData != null ? Math.abs(activityInfo.metaData.getInt("com.urbandroid.sleep.captcha.meta.order")) : Integer.MAX_VALUE;
        String string = this.forCaptcha = activityInfo.metaData != null ? activityInfo.metaData.getString("com.urbandroid.sleep.captcha.meta.for_captcha") : null;
        if (this.isExternal || order == 0) {
            order = Integer.MAX_VALUE;
        }
        this.order = order;
    }

    public static BaseCaptchaInfo build(Context context, @NonNull ActivityInfo activityInfo, @NonNull String label) {
        return new BaseCaptchaInfo(context, activityInfo, label);
    }

    @Override
    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NonNull
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    @NonNull
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean hasDifficulty() {
        return this.hasDifficulty;
    }

    @Override
    public boolean isConfigurable() {
        return this.configActivityName != null;
    }

    @Override
    @Nullable
    public String getConfigActivityName() {
        return this.configActivityName;
    }

    public void setConfigActivityName(@NonNull String configActivityName) {
        this.configActivityName = configActivityName;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public String getForCaptcha() {
        return this.forCaptcha;
    }

    public String toString() {
        return "Captcha Info{id=" + this.id + ", packageName='" + this.packageName + '\'' + ", activityName='" + this.activityName + '\'' + ", label='" + this.label + '\'' + ", configActivityName='" + this.configActivityName + '\'' + ", hasDifficulty='" + this.hasDifficulty + '\'' + ", isExternal=" + this.isExternal + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseCaptchaInfo that = (BaseCaptchaInfo)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

