/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.AbstractCaptchaSupport;
import com.urbandroid.sleep.captcha.intent.IntentExtraSetter;

public class BaseCaptchaSupport
extends AbstractCaptchaSupport {
    protected BaseCaptchaSupport(@NonNull Activity activity, @NonNull Intent intent, int aliveTimeout) {
        super(activity, intent, aliveTimeout);
    }

    @Override
    protected void doAlive() {
        this.send("alive", new IntentExtraSetter(){

            @Override
            public void setExtras(@NonNull Intent intent) {
                intent.putExtra("timeAddInSeconds", BaseCaptchaSupport.this.aliveTimeoutInSeconds);
            }
        });
    }

    @Override
    public void solved() {
        this.solved(null);
    }

    @Override
    public void solved(@Nullable IntentExtraSetter extraSetter) {
        this.send("solved", extraSetter);
    }

    @Override
    public void unsolved() {
        this.send("unsolved", null);
    }

    void send(String event, @Nullable IntentExtraSetter extraSetter) {
        if (!this.isOperationalMode()) {
            return;
        }
        Intent callbackIntent = this.intent != null ? (Intent)this.intent.getParcelableExtra(event) : null;
        Log.i((String)"captcha-support", (String)("Calling " + event + (callbackIntent != null ? ": " + callbackIntent : "")));
        if (callbackIntent == null) {
            return;
        }
        if (extraSetter != null) {
            extraSetter.setExtras(callbackIntent);
        }
        switch (event) {
            case "alive": {
                this.context.sendBroadcast(callbackIntent);
                break;
            }
            case "unsolved": {
                if (this.hasOperation()) break;
                callbackIntent.addFlags(0x4000000);
                callbackIntent.addFlags(0x20000000);
                this.context.startActivity(callbackIntent);
                break;
            }
            case "solved": {
                if (this.hasOperation()) {
                    this.context.sendBroadcast(callbackIntent);
                    break;
                }
                callbackIntent.addFlags(0x4000000);
                callbackIntent.addFlags(0x20000000);
                this.context.startActivity(callbackIntent);
            }
        }
    }
}

