/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.RemainingTimeListener;
import com.urbandroid.sleep.captcha.finder.BaseCaptchaFinder;
import com.urbandroid.sleep.captcha.finder.CaptchaFinder;
import com.urbandroid.sleep.captcha.launcher.BaseCaptchaLauncher;
import com.urbandroid.sleep.captcha.launcher.CaptchaLauncher;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractCaptchaSupport
implements CaptchaSupport {
    @NonNull
    protected final Activity activity;
    @NonNull
    protected final Context context;
    @Nullable
    protected final Intent intent;
    @NonNull
    protected final CaptchaFinder finder;
    @NonNull
    protected final CaptchaLauncher launcher;
    protected int aliveTimeoutInSeconds = 60;
    private long lastAliveSent = -1L;
    private final AtomicReference<RemainingTimeListener> remainingTimeListener = new AtomicReference();
    private final Handler handler = new Handler();
    private final RemainingTimeRunnable remainingTimeRunnable = new RemainingTimeRunnable();
    private final FinishReceiver finishReceiver = new FinishReceiver();

    protected AbstractCaptchaSupport(@NonNull Activity activity, @Nullable Intent intent, int aliveTimeout) {
        this.activity = activity;
        this.context = activity.getApplicationContext();
        this.intent = intent;
        this.finder = new BaseCaptchaFinder(this.context);
        this.launcher = new BaseCaptchaLauncher(this.context, activity.getClass().getName(), intent, aliveTimeout).suppressAlarmMode(this.getSuppressAlarmMode()).difficulty(this.getDifficulty()).operation(this.getOperation());
        this.aliveTimeout(aliveTimeout);
        this.finishReceiver.register();
    }

    @Override
    public boolean isPreviewMode() {
        return this.intent != null && this.intent.getBooleanExtra("preview", false);
    }

    @Override
    public boolean isConfigurationMode() {
        return this.intent != null && "com.urbandroid.sleep.captcha.intent.action.CONFIG".equals(this.intent.getAction());
    }

    @Override
    public boolean isOperationalMode() {
        return !this.isPreviewMode() && !this.isConfigurationMode();
    }

    @Override
    public int getMode() {
        if (this.isPreviewMode()) {
            return 2;
        }
        if (this.isConfigurationMode()) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getDifficulty() {
        return this.intent != null ? this.intent.getIntExtra("difficulty", 1) : 1;
    }

    @Override
    public int getSuppressAlarmMode() {
        return this.intent != null ? this.intent.getIntExtra("suppress-alarm-mode", 0) : 0;
    }

    protected boolean hasOperation() {
        return this.intent != null && !this.intent.hasExtra("no_operation");
    }

    private String getOperation() {
        if (this.intent == null || this.intent.hasExtra("no_operation")) {
            return "no_operation";
        }
        if (this.intent.hasExtra("delete_alarm")) {
            return "delete_alarm";
        }
        if (this.intent.hasExtra("disable_alarm")) {
            return "disable_alarm";
        }
        if (this.intent.hasExtra("edit_alarm")) {
            return "edit_alarm";
        }
        if (this.intent.hasExtra("edit_alarm_time_extra")) {
            return "edit_alarm_time_extra";
        }
        if (this.intent.hasExtra("should_skip")) {
            return "should_skip";
        }
        if (this.intent.hasExtra("snooze_cancel")) {
            return "snooze_cancel";
        }
        return "no_operation";
    }

    @Override
    public CaptchaSupport setRemainingTimeListener(@Nullable RemainingTimeListener remainingTimeListener) {
        if (this.hasOperation()) {
            Log.w((String)"captcha-support", (String)"Sleep operation set: RemainingTimeListener will be not active");
            return this;
        }
        if (!this.isOperationalMode()) {
            Log.w((String)"captcha-support", (String)"No operational mode: RemainingTimeListener will be not active");
            return this;
        }
        if (this.getSuppressAlarmMode() == 0) {
            Log.w((String)"captcha-support", (String)"SuppressAlarmMode: Full Alarm Volume - RemainingTimeListener will be not active");
            return this;
        }
        this.remainingTimeListener.set(remainingTimeListener);
        this.handler.removeCallbacks((Runnable)this.remainingTimeRunnable);
        if (remainingTimeListener != null) {
            this.handler.postDelayed((Runnable)this.remainingTimeRunnable, 500L);
        }
        return this;
    }

    @Override
    public CaptchaSupport aliveTimeout(int timeoutInSeconds) {
        if (timeoutInSeconds < 5 || timeoutInSeconds > 300) {
            Log.w((String)"captcha-support", (String)"aliveTimeout out of range <5, 300>");
            return this;
        }
        Log.d((String)"captcha-support", (String)("aliveTimeout set: " + timeoutInSeconds));
        this.aliveTimeoutInSeconds = timeoutInSeconds;
        return this;
    }

    @Override
    public int getRemainingTime() {
        if (this.lastAliveSent == -1L) {
            return 5;
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(this.lastAliveSent + (long)(this.aliveTimeoutInSeconds * 1000) - System.currentTimeMillis());
        if (seconds < 0L) {
            return 0;
        }
        return (int)seconds;
    }

    @Override
    public final void alive() {
        this.doAlive();
        this.lastAliveSent = System.currentTimeMillis();
    }

    protected abstract void doAlive();

    @Override
    @NonNull
    public CaptchaFinder getFinder() {
        return this.finder;
    }

    @Override
    @NonNull
    public CaptchaLauncher getLauncher() {
        return this.launcher;
    }

    @Override
    public void destroy() {
        this.finishReceiver.unregister();
        if (this.remainingTimeRunnable != null) {
            this.handler.removeCallbacks((Runnable)this.remainingTimeRunnable);
            this.remainingTimeListener.set(null);
        }
    }

    @Override
    public int getAliveTimeout() {
        return this.aliveTimeoutInSeconds;
    }

    private class FinishReceiver
    extends BroadcastReceiver {
        private final AtomicBoolean isRegistered = new AtomicBoolean(false);

        private FinishReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            AbstractCaptchaSupport.this.activity.finish();
        }

        public void register() {
            if (this.isRegistered.get()) {
                return;
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.urbandroid.sleep.alarmclock.ALARM_SNOOZE");
            filter.addAction("com.urbandroid.sleep.ACTION_FINISH_CAPTCHA");
            this.isRegistered.set(true);
            AbstractCaptchaSupport.this.context.registerReceiver((BroadcastReceiver)this, filter);
        }

        public void unregister() {
            if (!this.isRegistered.get()) {
                return;
            }
            AbstractCaptchaSupport.this.context.unregisterReceiver((BroadcastReceiver)this);
            this.isRegistered.set(false);
        }
    }

    private class RemainingTimeRunnable
    implements Runnable {
        private RemainingTimeRunnable() {
        }

        @Override
        public void run() {
            RemainingTimeListener remainingTimeListener = (RemainingTimeListener)AbstractCaptchaSupport.this.remainingTimeListener.get();
            if (remainingTimeListener == null) {
                return;
            }
            remainingTimeListener.timeRemain(AbstractCaptchaSupport.this.getRemainingTime(), AbstractCaptchaSupport.this.aliveTimeoutInSeconds);
            AbstractCaptchaSupport.this.handler.postDelayed((Runnable)this, 500L);
        }
    }
}

