/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.domain;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;

public class BaseCaptchaInfo
implements CaptchaInfo {
    private final int id;
    private final int order;
    private final String packageName;
    private final String activityName;
    private final String label;
    private final boolean isExternal;
    private final boolean hasDifficulty;
    private boolean configurable;
    public static final Parcelable.Creator<BaseCaptchaInfo> CREATOR = new Parcelable.Creator<BaseCaptchaInfo>(){

        public BaseCaptchaInfo createFromParcel(Parcel in) {
            return new BaseCaptchaInfo(in);
        }

        public BaseCaptchaInfo[] newArray(int size) {
            return new BaseCaptchaInfo[size];
        }
    };

    private BaseCaptchaInfo(Context context, @NonNull ActivityInfo activityInfo, @NonNull String label) {
        int order;
        this.packageName = activityInfo.packageName;
        this.activityName = activityInfo.name;
        this.label = label;
        this.isExternal = !context.getPackageName().equals(this.packageName);
        boolean isFromSleep = "com.urbandroid.sleep".equals(this.packageName);
        this.id = this.isExternal && !isFromSleep || activityInfo.metaData == null || !activityInfo.metaData.containsKey("com.urbandroid.sleep.captcha.meta.id") ? (this.packageName + this.activityName).hashCode() : activityInfo.metaData.getInt("com.urbandroid.sleep.captcha.meta.id");
        this.hasDifficulty = activityInfo.metaData != null && activityInfo.metaData.getBoolean("com.urbandroid.sleep.captcha.meta.has_difficulty");
        int n = order = activityInfo.metaData != null ? Math.abs(activityInfo.metaData.getInt("com.urbandroid.sleep.captcha.meta.order")) : Integer.MAX_VALUE;
        if (this.isExternal || order == 0) {
            order = Integer.MAX_VALUE;
        }
        this.order = order;
    }

    public static BaseCaptchaInfo build(Context context, @NonNull ActivityInfo activityInfo, @NonNull String label) {
        return new BaseCaptchaInfo(context, activityInfo, label);
    }

    @Override
    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NonNull
    public String getActivityName() {
        return this.activityName;
    }

    @Override
    @NonNull
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean hasDifficulty() {
        return this.hasDifficulty;
    }

    @Override
    public boolean isConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(boolean configurable) {
        this.configurable = configurable;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return "Captcha Info{id=" + this.id + ", packageName='" + this.packageName + '\'' + ", activityName='" + this.activityName + '\'' + ", label='" + this.label + '\'' + ", configurable='" + this.configurable + '\'' + ", hasDifficulty='" + this.hasDifficulty + '\'' + ", isExternal=" + this.isExternal + '}';
    }

    protected BaseCaptchaInfo(Parcel in) {
        this.id = in.readInt();
        this.order = in.readInt();
        this.packageName = in.readString();
        this.activityName = in.readString();
        this.label = in.readString();
        this.isExternal = in.readByte() != 0;
        this.hasDifficulty = in.readByte() != 0;
        this.configurable = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeInt(this.order);
        dest.writeString(this.packageName);
        dest.writeString(this.activityName);
        dest.writeString(this.label);
        dest.writeByte((byte)(this.isExternal ? 1 : 0));
        dest.writeByte((byte)(this.hasDifficulty ? 1 : 0));
        dest.writeByte((byte)(this.configurable ? 1 : 0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseCaptchaInfo that = (BaseCaptchaInfo)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

