/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.finder;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.domain.BaseCaptchaGroup;
import com.urbandroid.sleep.captcha.domain.BaseCaptchaInfo;
import com.urbandroid.sleep.captcha.domain.CaptchaGroup;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import com.urbandroid.sleep.captcha.finder.CaptchaFinder;
import com.urbandroid.sleep.captcha.finder.CaptchaInfoFilter;
import com.urbandroid.sleep.captcha.finder.filter.IdCaptchaInfoFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseCaptchaFinder
implements CaptchaFinder {
    private final Context context;

    public BaseCaptchaFinder(@NonNull Context context) {
        this.context = context;
    }

    @Override
    @NonNull
    public List<CaptchaGroup> findGroups(@Nullable CaptchaInfoFilter filter) {
        PackageManager packageManager = this.context.getPackageManager();
        HashMap<String, CaptchaGroup> groups = new HashMap<String, CaptchaGroup>();
        List apps = packageManager.getInstalledApplications(128);
        for (CaptchaInfo captcha : this.lookup(filter)) {
            CaptchaGroup group = this.findGroup(packageManager, groups, apps, captcha.getPackageName());
            if (group == null) continue;
            group.add(captcha);
        }
        return new ArrayList<CaptchaGroup>(groups.values());
    }

    private CaptchaGroup findGroup(@NonNull PackageManager packageManager, @Nullable Map<String, CaptchaGroup> groups, @NonNull List<ApplicationInfo> apps, @NonNull String packageName) {
        CaptchaGroup captchaGroup;
        CaptchaGroup captchaGroup2 = captchaGroup = groups != null ? groups.get(packageName) : null;
        if (captchaGroup != null) {
            return captchaGroup;
        }
        for (ApplicationInfo app : apps) {
            if (!packageName.equals(app.packageName)) continue;
            CharSequence label = app.loadLabel(packageManager);
            BaseCaptchaGroup group = new BaseCaptchaGroup(packageName, label == null ? packageName : label.toString());
            if (groups != null && !groups.containsKey(packageName)) {
                groups.put(packageName, group);
            }
            return group;
        }
        return null;
    }

    @Override
    @NonNull
    public List<CaptchaInfo> lookup() {
        return this.lookup(null);
    }

    @Override
    @NonNull
    public List<CaptchaInfo> lookup(@Nullable CaptchaInfoFilter filter) {
        ArrayList<CaptchaInfo> result = new ArrayList<CaptchaInfo>();
        PackageManager packageManager = this.context.getPackageManager();
        List apps = packageManager.getInstalledApplications(128);
        Intent launchCaptchaIntent = new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN");
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(launchCaptchaIntent, 128)) {
            CaptchaInfo captchaInfo = BaseCaptchaInfo.build(this.context, resolveInfo.activityInfo, resolveInfo.activityInfo.loadLabel(packageManager).toString());
            CaptchaGroup group = this.findGroup(packageManager, null, apps, ((BaseCaptchaInfo)captchaInfo).getPackageName());
            if (filter != null && !filter.apply(group, captchaInfo)) continue;
            result.add(captchaInfo);
        }
        Intent configCaptchaIntent = new Intent("com.urbandroid.sleep.captcha.intent.action.CONFIG");
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(configCaptchaIntent, 128)) {
            BaseCaptchaInfo configInfo = BaseCaptchaInfo.build(this.context, resolveInfo.activityInfo, resolveInfo.activityInfo.loadLabel(packageManager).toString());
            BaseCaptchaInfo captchaInfo = this.findById(result, configInfo.getId());
            if (captchaInfo == null) continue;
            captchaInfo.setConfigurable(true);
        }
        Collections.sort(result, CaptchaInfo.ORDER_COMPARATOR);
        if (!result.isEmpty()) {
            Log.d((String)"captcha-support", (String)"Found Captchas:");
            for (CaptchaInfo captchaInfo : result) {
                if (captchaInfo.getPackageName().equals(this.context.getPackageName())) continue;
                Log.d((String)"captcha-support", (String)captchaInfo.toString());
            }
        } else {
            Log.w((String)"captcha-support", (String)"No captcha found");
        }
        return result;
    }

    @Override
    @Nullable
    public CaptchaInfo findById(int id) {
        List<CaptchaInfo> list = this.lookup(new IdCaptchaInfoFilter(id));
        return list.isEmpty() ? null : list.get(0);
    }

    @Nullable
    protected BaseCaptchaInfo findById(List<CaptchaInfo> infos, int id) {
        for (CaptchaInfo info : infos) {
            if (info.getId() != id) continue;
            return (BaseCaptchaInfo)info;
        }
        return null;
    }
}

