/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.launcher;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.CaptchaSupportException;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import com.urbandroid.sleep.captcha.intent.CallbackIntentCreator;
import com.urbandroid.sleep.captcha.launcher.CaptchaLauncher;
import com.urbandroid.sleep.captcha.util.IntentUtil;

public class BaseCaptchaLauncher
implements CaptchaLauncher {
    protected final Context context;
    protected final Intent originIntent;
    protected final String captchaClassName;
    protected int difficulty = 1;
    protected int suppressAlarmMode = 0;
    protected int mode = 1;
    protected String operation = "no_operation";
    protected CallbackIntentCreator callbackIntentCreator;
    protected int flags = 0x30000000;
    private int aliveTimeout = -1;

    public BaseCaptchaLauncher(@NonNull Context context, String captchaClassName, @Nullable Intent originIntent) {
        this(context, captchaClassName, originIntent, -1);
    }

    public BaseCaptchaLauncher(@NonNull Context context, String captchaClassName, @Nullable Intent originIntent, int aliveTimeout) {
        this.context = context;
        this.captchaClassName = captchaClassName;
        this.originIntent = originIntent;
        this.aliveTimeout = aliveTimeout;
        if (originIntent != null && aliveTimeout != -1) {
            originIntent.putExtra("aliveTimeout", aliveTimeout);
        }
    }

    @Override
    public CaptchaLauncher difficulty(int difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    @Override
    public CaptchaLauncher aliveTimeout(int aliveTimeoutInSeconds) {
        if (aliveTimeoutInSeconds < 5 || aliveTimeoutInSeconds > 300) {
            Log.w((String)"captcha-support", (String)"aliveTimeout out of range <5, 300>");
            return this;
        }
        this.aliveTimeout = aliveTimeoutInSeconds;
        return this;
    }

    @Override
    public CaptchaLauncher suppressAlarmMode(int suppressAlarmMode) {
        this.suppressAlarmMode = suppressAlarmMode;
        return this;
    }

    @Override
    public CaptchaLauncher operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public CaptchaLauncher callbackIntentCreator(@NonNull CallbackIntentCreator callbackIntentCreator) {
        this.callbackIntentCreator = callbackIntentCreator;
        return this;
    }

    @Override
    public CaptchaLauncher addFlags(int flags) {
        this.flags |= flags;
        return this;
    }

    @Override
    public CaptchaLauncher mode(int mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public void start(@NonNull CaptchaInfo captchaInfo) {
        Log.i((String)"captcha-support", (String)("Starting captcha mode: " + this.mode + " difficulty: " + this.difficulty + " aliveTimeout: " + this.aliveTimeout + " operation: " + this.operation + " " + captchaInfo));
        Intent intent = this.prepareIntent(captchaInfo);
        Log.d((String)"captcha-support", (String)IntentUtil.traceIntent(intent));
        this.context.startActivity(intent);
    }

    @Override
    @NonNull
    public Intent prepareIntent(@NonNull CaptchaInfo captchaInfo) {
        switch (this.mode) {
            case 3: {
                Intent intent = new Intent("com.urbandroid.sleep.captcha.intent.action.CONFIG").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).addFlags(0x10000000).putExtra("suppress-alarm-mode", this.suppressAlarmMode).putExtra("difficulty", this.difficulty);
                if (this.aliveTimeout != -1) {
                    intent.putExtra("aliveTimeout", this.aliveTimeout);
                }
                return intent;
            }
            case 2: {
                Intent intent = new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).addFlags(0x10000000).putExtra("difficulty", this.difficulty).putExtra("suppress-alarm-mode", this.suppressAlarmMode).putExtra("preview", true);
                if (this.aliveTimeout != -1) {
                    intent.putExtra("aliveTimeout", this.aliveTimeout);
                }
                return intent;
            }
            case 1: {
                Intent solvedCaptchaIntent = this.callbackIntentCreator == null ? new Intent("com.urbandroid.sleep.captcha.intent.action.SOLVED").putExtra("originIntent", (Parcelable)this.originIntent).addFlags(0x10000000).setClassName(this.context.getPackageName(), this.captchaClassName) : this.callbackIntentCreator.createSolvedIntent(this.context, this.operation);
                solvedCaptchaIntent.putExtra(this.operation, true);
                solvedCaptchaIntent.putExtra("captchaInfo", captchaInfo.getId());
                Intent unsolvedCaptchaIntent = this.callbackIntentCreator == null ? new Intent("com.urbandroid.sleep.captcha.intent.action.SOLVED").putExtra("originIntent", (Parcelable)this.originIntent).putExtra("success", false).addFlags(0x10000000).setClassName(this.context.getPackageName(), this.captchaClassName) : this.callbackIntentCreator.createUnsolvedIntent(this.context, this.operation);
                unsolvedCaptchaIntent.putExtra("captchaInfo", captchaInfo.getId());
                Intent captchaAliveIntent = new Intent("com.urbandroid.sleep.captcha.intent.action.ALIVE");
                Intent intent = new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).setFlags(this.flags).putExtra("solved", (Parcelable)solvedCaptchaIntent).putExtra("unsolved", (Parcelable)unsolvedCaptchaIntent).putExtra("alive", (Parcelable)captchaAliveIntent).putExtra("difficulty", this.difficulty).putExtra("suppress-alarm-mode", this.suppressAlarmMode).putExtra(this.operation, true);
                if (this.aliveTimeout != -1) {
                    intent.putExtra("aliveTimeout", this.aliveTimeout);
                }
                return intent;
            }
        }
        throw new CaptchaSupportException("Unknown captcha mode: " + this.mode);
    }
}

