/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.BaseCaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupportHolder;
import com.urbandroid.sleep.captcha.FallbackPreviewCaptchaSupport;
import com.urbandroid.sleep.captcha.util.IntentUtil;

public class CaptchaSupportFactory {
    public static CaptchaSupport create(@NonNull Activity activity) {
        return CaptchaSupportFactory.create(activity, activity.getIntent(), IntentUtil.resolveTimeout(activity.getIntent()));
    }

    public static CaptchaSupport create(@NonNull Activity activity, @Nullable Intent intent) {
        return CaptchaSupportFactory.create(activity, intent, IntentUtil.resolveTimeout(intent));
    }

    public static CaptchaSupport create(@NonNull Activity activity, int aliveTimeout) {
        return CaptchaSupportFactory.create(activity, activity.getIntent(), aliveTimeout);
    }

    @NonNull
    public static CaptchaSupport create(@NonNull Activity activity, @Nullable Intent intent, int aliveTimeout) {
        boolean isCaptchaSolvedCallbackIntent;
        String captchaName = activity.getLocalClassName();
        Log.d((String)"captcha-support", (String)(captchaName + ": " + IntentUtil.traceIntent(intent)));
        if (CaptchaSupportHolder.get() != null) {
            CaptchaSupportHolder.get().destroy();
        }
        if (intent != null) {
            Log.d((String)"captcha-support", (String)("Child Captcha Id:" + intent.getIntExtra("captchaInfo", -1)));
        }
        boolean isCaptchaLaunchIntent = intent != null && "com.urbandroid.sleep.captcha.intent.action.OPEN".equals(intent.getAction());
        boolean bl = isCaptchaSolvedCallbackIntent = intent != null && intent.hasExtra("originIntent");
        if (!isCaptchaLaunchIntent && !isCaptchaSolvedCallbackIntent) {
            Log.w((String)"captcha-support", (String)(captchaName + ": Creating FAKE PREVIEW captcha support since it is activity with no captcha launch action (" + "com.urbandroid.sleep.captcha.intent.action.OPEN" + ")"));
            FallbackPreviewCaptchaSupport captchaSupport = new FallbackPreviewCaptchaSupport(activity, aliveTimeout);
            CaptchaSupportHolder.set(captchaSupport);
            Log.i((String)"captcha-support", (String)(captchaName + ": Captcha support created (alive timeout:" + aliveTimeout + ")"));
            return captchaSupport;
        }
        Intent rootIntent = isCaptchaSolvedCallbackIntent ? (Intent)intent.getParcelableExtra("originIntent") : intent;
        BaseCaptchaSupport baseCaptchaSupport = new BaseCaptchaSupport(activity, rootIntent, aliveTimeout);
        baseCaptchaSupport.alive();
        CaptchaSupportHolder.set(baseCaptchaSupport);
        Log.i((String)"captcha-support", (String)(captchaName + ": Captcha support created (alive timeout:" + aliveTimeout + ")"));
        return baseCaptchaSupport;
    }
}

