/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.BaseCaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupportHolder;
import com.urbandroid.sleep.captcha.FallbackPreviewCaptchaSupport;

public class CaptchaSupportFactory {
    public static CaptchaSupport create(@NonNull Activity activity) {
        return CaptchaSupportFactory.create(activity, activity.getIntent(), 60);
    }

    public static CaptchaSupport create(@NonNull Activity activity, @Nullable Intent intent) {
        return CaptchaSupportFactory.create(activity, intent, 60);
    }

    public static CaptchaSupport create(@NonNull Activity activity, int aliveTimeout) {
        return CaptchaSupportFactory.create(activity, activity.getIntent(), aliveTimeout);
    }

    @NonNull
    public static CaptchaSupport create(@NonNull Activity activity, @Nullable Intent intent, int aliveTimeout) {
        boolean isCaptchaSolvedCallbackIntent;
        if (CaptchaSupportHolder.get() != null) {
            CaptchaSupportHolder.get().destroy();
        }
        boolean isCaptchaLaunchIntent = intent != null && "com.urbandroid.sleep.captcha.intent.action.OPEN".equals(intent.getAction());
        boolean bl = isCaptchaSolvedCallbackIntent = intent != null && intent.hasExtra("originIntent");
        if (!isCaptchaLaunchIntent && !isCaptchaSolvedCallbackIntent) {
            Log.w((String)"captcha-support", (String)"Creating FAKE PREVIEW captcha support since it is activity with no captcha launch action (com.urbandroid.sleep.captcha.intent.action.OPEN)");
            CaptchaSupport captchaSupport = new FallbackPreviewCaptchaSupport(activity).aliveTimeout(aliveTimeout);
            CaptchaSupportHolder.set(captchaSupport);
            return captchaSupport;
        }
        Log.i((String)"captcha-support", (String)("isCaptchaSolvedCallbackIntent: " + isCaptchaLaunchIntent));
        Intent rootIntent = isCaptchaSolvedCallbackIntent ? (Intent)intent.getParcelableExtra("originIntent") : intent;
        BaseCaptchaSupport baseCaptchaSupport = new BaseCaptchaSupport(activity, rootIntent);
        baseCaptchaSupport.aliveTimeout(aliveTimeout).alive();
        CaptchaSupportHolder.set(baseCaptchaSupport);
        Log.w((String)"captcha-support", (String)"Captcha support created");
        return baseCaptchaSupport;
    }
}

