/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.finder;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.domain.BaseCaptchaInfo;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import com.urbandroid.sleep.captcha.finder.CaptchaFinder;
import com.urbandroid.sleep.captcha.finder.CaptchaInfoFilter;
import com.urbandroid.sleep.captcha.finder.IdCaptchaInfoFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BaseCaptchaFinder
implements CaptchaFinder {
    private final Context context;

    public BaseCaptchaFinder(@NonNull Context context) {
        this.context = context;
    }

    @Override
    @NonNull
    public List<CaptchaInfo> lookup() {
        return this.lookup(null);
    }

    @Override
    @NonNull
    public List<CaptchaInfo> lookup(@Nullable CaptchaInfoFilter filter) {
        ArrayList<CaptchaInfo> result = new ArrayList<CaptchaInfo>();
        PackageManager packageManager = this.context.getPackageManager();
        Intent launchCaptchaIntent = new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN");
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(launchCaptchaIntent, 128)) {
            Log.i((String)"captcha-support", (String)("Found: " + resolveInfo));
            CaptchaInfo captchaInfo = BaseCaptchaInfo.build(this.context, resolveInfo.activityInfo, resolveInfo.activityInfo.loadLabel(packageManager).toString());
            Log.i((String)"captcha-support", (String)("\tCaptcha: " + captchaInfo));
            if (filter != null && !filter.apply(captchaInfo)) continue;
            result.add(captchaInfo);
        }
        Intent configCaptchaIntent = new Intent("com.urbandroid.sleep.captcha.intent.action.CONFIG");
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(configCaptchaIntent, 128)) {
            BaseCaptchaInfo configInfo = BaseCaptchaInfo.build(this.context, resolveInfo.activityInfo, resolveInfo.activityInfo.loadLabel(packageManager).toString());
            BaseCaptchaInfo captchaInfo = this.findById(result, configInfo.getId());
            if (captchaInfo == null) continue;
            captchaInfo.setConfigurable(true);
        }
        Collections.sort(result, new Comparator<CaptchaInfo>(){

            @Override
            public int compare(CaptchaInfo info1, CaptchaInfo info2) {
                return Integer.valueOf(info1.getOrder()).compareTo(info2.getOrder());
            }
        });
        if (!result.isEmpty()) {
            for (CaptchaInfo captchaInfo : result) {
                Log.i((String)"captcha-support", (String)captchaInfo.toString());
            }
        } else {
            Log.i((String)"captcha-support", (String)"No captcha found");
        }
        return result;
    }

    @Override
    @Nullable
    public CaptchaInfo findById(int id) {
        List<CaptchaInfo> list = this.lookup(new IdCaptchaInfoFilter(id));
        return list.isEmpty() ? null : list.get(0);
    }

    @Nullable
    protected BaseCaptchaInfo findById(List<CaptchaInfo> infos, int id) {
        for (CaptchaInfo info : infos) {
            if (info.getId() != id) continue;
            return (BaseCaptchaInfo)info;
        }
        return null;
    }
}

