/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.util.Log;
import com.urbandroid.sleep.captcha.BaseCaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupportHolder;
import com.urbandroid.sleep.captcha.FallbackPreviewCaptchaSupport;

public class CaptchaSupportFactory {
    public static CaptchaSupport create(@NonNull Activity activity) {
        return CaptchaSupportFactory.create(activity, 60);
    }

    @NonNull
    public static CaptchaSupport create(@NonNull Activity activity, int aliveTimeout) {
        Context context = activity.getApplicationContext();
        Intent intent = activity.getIntent();
        boolean isCaptchaLaunchIntent = "com.urbandroid.sleep.captcha.intent.action.OPEN".equals(intent.getAction());
        boolean isCaptchaSolvedCallbackIntent = intent.hasExtra("originIntent");
        if (!isCaptchaLaunchIntent && !isCaptchaSolvedCallbackIntent) {
            Log.w((String)"captcha-support", (String)"Creating FAKE PREVIEW captcha support since it is activity with no captcha launch action (com.urbandroid.sleep.captcha.intent.action.OPEN)");
            CaptchaSupport captchaSupport = new FallbackPreviewCaptchaSupport(context).aliveTimeout(aliveTimeout);
            CaptchaSupportHolder.set(captchaSupport);
            return captchaSupport;
        }
        Log.i((String)"captcha-support", (String)("isCaptchaSolvedCallbackIntent: " + isCaptchaLaunchIntent));
        Intent rootIntent = isCaptchaSolvedCallbackIntent ? (Intent)intent.getParcelableExtra("originIntent") : intent;
        BaseCaptchaSupport baseCaptchaSupport = new BaseCaptchaSupport(context, rootIntent);
        baseCaptchaSupport.aliveTimeout(aliveTimeout).alive();
        CaptchaSupportHolder.set(baseCaptchaSupport);
        Log.w((String)"captcha-support", (String)"Captcha support created");
        return baseCaptchaSupport;
    }
}

