/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.AbstractCaptchaSupport;
import com.urbandroid.sleep.captcha.intent.IntentExtraSetter;

public class BaseCaptchaSupport
extends AbstractCaptchaSupport {
    protected BaseCaptchaSupport(@NonNull Context context, @NonNull Intent intent) {
        super(context, intent);
    }

    @Override
    public boolean isPreviewMode() {
        return this.intent.getBooleanExtra("preview", false);
    }

    @Override
    public boolean isConfigurationMode() {
        return "com.urbandroid.sleep.captcha.intent.action.CONFIG".equals(this.intent.getAction());
    }

    @Override
    public boolean isOperationalMode() {
        return !this.isPreviewMode() && !this.isConfigurationMode();
    }

    @Override
    public int getMode() {
        if (this.isPreviewMode()) {
            return 2;
        }
        if (this.isConfigurationMode()) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getDifficulty() {
        return this.intent.getIntExtra("difficulty", 1);
    }

    protected boolean hasOperation() {
        return !this.intent.hasExtra("no_operation");
    }

    @Override
    protected void doAlive() {
        this.send("alive", new IntentExtraSetter(){

            @Override
            public void setExtras(@NonNull Intent intent) {
                intent.putExtra("timeAddInSeconds", BaseCaptchaSupport.this.aliveTimeoutInSeconds);
            }
        });
    }

    @Override
    public void solved() {
        this.solved(null);
    }

    @Override
    public void solved(@Nullable IntentExtraSetter extraSetter) {
        this.send("solved", extraSetter);
    }

    @Override
    public void unsolved() {
        this.send("unsolved", null);
    }

    void send(String event, @Nullable IntentExtraSetter extraSetter) {
        if (!this.isOperationalMode()) {
            return;
        }
        Intent callbackIntent = (Intent)this.intent.getParcelableExtra(event);
        Log.i((String)"captcha-support", (String)("calling " + event + ": " + callbackIntent));
        if (callbackIntent == null) {
            return;
        }
        if (extraSetter != null) {
            extraSetter.setExtras(callbackIntent);
        }
        switch (event) {
            case "alive": {
                this.context.sendBroadcast(callbackIntent);
                break;
            }
            case "unsolved": {
                if (this.hasOperation()) break;
                this.context.startActivity(callbackIntent);
                break;
            }
            case "solved": {
                if (this.hasOperation()) {
                    this.context.sendBroadcast(callbackIntent);
                    break;
                }
                this.context.startActivity(callbackIntent);
            }
        }
    }
}

