/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.launcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.util.Log;
import com.urbandroid.sleep.captcha.RemoteCaptchaCallbackListener;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import java.util.concurrent.atomic.AtomicReference;

public class SolvedBroadcastReceiver
extends BroadcastReceiver {
    public static final String CAPTCHA_ACTION_NESTED_SOLVED = "com.urbandroid.sleep.captcha.intent.action.NESTED_SOLVED";
    private RemoteCaptchaCallbackListener listener;
    private CaptchaInfo captchaInfo;
    private static final AtomicReference<SolvedBroadcastReceiver> registerReceiver = new AtomicReference();

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        boolean success = intent.getBooleanExtra("success", false);
        if (success) {
            this.listener.solved(this.captchaInfo);
        } else {
            this.listener.unsolved(this.captchaInfo);
        }
        SolvedBroadcastReceiver.unregister(context);
    }

    public static void register(@NonNull Context context, @NonNull CaptchaInfo captchaInfo, @NonNull RemoteCaptchaCallbackListener listener) {
        if (registerReceiver.get() != null) {
            Log.w((String)"captcha-support", (String)"Already registered");
            return;
        }
        SolvedBroadcastReceiver receiver = new SolvedBroadcastReceiver();
        receiver.listener = listener;
        receiver.captchaInfo = captchaInfo;
        context.registerReceiver((BroadcastReceiver)receiver, new IntentFilter(CAPTCHA_ACTION_NESTED_SOLVED));
        registerReceiver.set(receiver);
        Log.i((String)"captcha-support", (String)("RemoteCaptchaCallbackListener registered for " + captchaInfo));
    }

    public static void unregister(@NonNull Context context) {
        if (registerReceiver.get() == null) {
            return;
        }
        SolvedBroadcastReceiver receiver = registerReceiver.get();
        context.unregisterReceiver((BroadcastReceiver)registerReceiver.get());
        registerReceiver.set(null);
        Log.i((String)"captcha-support", (String)("RemoteCaptchaCallbackListener unregistered for " + receiver.captchaInfo));
    }
}

