/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.util.Log;
import com.urbandroid.sleep.captcha.BaseCaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.CaptchaSupportHolder;
import com.urbandroid.sleep.captcha.FallbackPreviewCaptchaSupport;

public class CaptchaSupportFactory {
    public static CaptchaSupport create(@NonNull Activity activity) {
        return CaptchaSupportFactory.create(activity, 60);
    }

    @NonNull
    public static CaptchaSupport create(@NonNull Activity activity, int aliveTimeout) {
        if (!"com.urbandroid.sleep.captcha.intent.action.OPEN".equals(activity.getIntent().getAction())) {
            Log.w((String)"captcha-support", (String)"Creating FAKE PREVIEW captcha support since it is activity with no captcha launch action (com.urbandroid.sleep.captcha.intent.action.OPEN)");
            CaptchaSupport captchaSupport = new FallbackPreviewCaptchaSupport(activity.getApplicationContext()).aliveTimeout(aliveTimeout);
            CaptchaSupportHolder.set(captchaSupport);
            return captchaSupport;
        }
        BaseCaptchaSupport baseCaptchaSupport = new BaseCaptchaSupport(activity.getApplicationContext(), activity.getIntent());
        baseCaptchaSupport.aliveTimeout(aliveTimeout).alive();
        CaptchaSupportHolder.set(baseCaptchaSupport);
        Log.w((String)"captcha-support", (String)"Captcha support created");
        return baseCaptchaSupport;
    }
}

