/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.RemainingTimeListener;
import com.urbandroid.sleep.captcha.finder.BaseCaptchaFinder;
import com.urbandroid.sleep.captcha.finder.CaptchaFinder;
import com.urbandroid.sleep.captcha.launcher.BaseCaptchaLauncher;
import com.urbandroid.sleep.captcha.launcher.CaptchaLauncher;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCaptchaSupport
implements CaptchaSupport {
    protected final Context context;
    protected final CaptchaFinder finder;
    protected final CaptchaLauncher launcher;
    private int aliveTimeoutInSeconds = 60;
    private long lastAliveSent = -1L;
    private RemainingTimeListener remainingTimeListener;
    private final Handler handler = new Handler();
    private final RemainingTimeRunnable remainingTimeRunnable = new RemainingTimeRunnable();

    protected AbstractCaptchaSupport(@NonNull Context context) {
        this.context = context;
        this.finder = new BaseCaptchaFinder(context);
        this.launcher = new BaseCaptchaLauncher(context);
    }

    @Override
    public CaptchaSupport setRemainingTimeListener(@Nullable RemainingTimeListener remainingTimeListener) {
        this.remainingTimeListener = remainingTimeListener;
        this.handler.removeCallbacks((Runnable)this.remainingTimeRunnable);
        if (remainingTimeListener != null) {
            this.handler.postDelayed((Runnable)this.remainingTimeRunnable, 500L);
        }
        return this;
    }

    @Override
    public CaptchaSupport aliveTimeout(@IntRange(from=5L, to=300L) int timeoutInSeconds) {
        if (this.aliveTimeoutInSeconds < 5 || this.aliveTimeoutInSeconds > 300) {
            Log.w((String)"captcha-support", (String)"aliveTimeout out of range <5, 300>");
            return this;
        }
        this.aliveTimeoutInSeconds = timeoutInSeconds;
        return this;
    }

    @Override
    public int getRemainingTime() {
        if (this.lastAliveSent == -1L) {
            return 5;
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(this.lastAliveSent + (long)(this.aliveTimeoutInSeconds * 1000) - System.currentTimeMillis());
        if (seconds < 0L) {
            return 0;
        }
        return (int)seconds;
    }

    @Override
    public final void alive() {
        this.doAlive();
        this.lastAliveSent = System.currentTimeMillis();
    }

    protected abstract void doAlive();

    @Override
    public CaptchaFinder getFinder() {
        return this.finder;
    }

    @Override
    public CaptchaLauncher getLauncher() {
        return this.launcher;
    }

    private class RemainingTimeRunnable
    implements Runnable {
        private RemainingTimeRunnable() {
        }

        @Override
        public void run() {
            if (AbstractCaptchaSupport.this.remainingTimeListener == null) {
                return;
            }
            AbstractCaptchaSupport.this.remainingTimeListener.timeRemain(AbstractCaptchaSupport.this.getRemainingTime(), AbstractCaptchaSupport.this.aliveTimeoutInSeconds);
            AbstractCaptchaSupport.this.handler.postDelayed((Runnable)this, 500L);
        }
    }
}

